/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.security.AuditEvent;
import org.apache.solr.security.AuditLoggerPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrLogAuditLoggerPlugin
extends AuditLoggerPlugin {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public void init(Map<String, Object> pluginConfig) {
        super.init(pluginConfig);
        this.setFormatter(event -> "type=\"" + event.getEventType().name() + "\"" + " message=\"" + event.getMessage() + "\"" + " method=\"" + event.getHttpMethod() + "\"" + " status=\"" + event.getStatus() + "\"" + " requestType=\"" + (Object)((Object)event.getRequestType()) + "\"" + " username=\"" + event.getUsername() + "\"" + " resource=\"" + event.getResource() + "\"" + " queryString=\"" + event.getHttpQueryString() + "\"" + " collections=" + event.getCollections());
        if (pluginConfig.size() > 0) {
            throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "Plugin config was not fully consumed. Remaining parameters are " + pluginConfig);
        }
        log.debug("Initialized SolrLogAuditLoggerPlugin");
    }

    @Override
    public void audit(AuditEvent event) {
        switch (event.getLevel()) {
            case INFO: {
                if (!log.isInfoEnabled()) break;
                log.info(this.formatter.formatEvent(event));
                break;
            }
            case WARN: {
                log.warn(this.formatter.formatEvent(event));
                break;
            }
            case ERROR: {
                log.error(this.formatter.formatEvent(event));
            }
        }
    }
}

