/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.solr.common.SolrException;

public class HdfsUtil {
    public static Configuration TEST_CONF = null;
    private static final String[] HADOOP_CONF_FILES = new String[]{"core-site.xml", "hdfs-site.xml", "mapred-site.xml", "yarn-site.xml", "hadoop-site.xml"};

    public static void addHdfsResources(Configuration conf, String confDir) {
        if (confDir != null && confDir.length() > 0) {
            File confDirFile = new File(confDir);
            if (!confDirFile.exists()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Resource directory does not exist: " + confDirFile.getAbsolutePath());
            }
            if (!confDirFile.isDirectory()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Specified resource directory is not a directory" + confDirFile.getAbsolutePath());
            }
            if (!confDirFile.canRead()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Resource directory must be readable by the Solr process: " + confDirFile.getAbsolutePath());
            }
            for (String file : HADOOP_CONF_FILES) {
                if (!new File(confDirFile, file).exists()) continue;
                conf.addResource(new Path(confDir, file));
            }
        }
        if (TEST_CONF != null) {
            conf.addResource(TEST_CONF);
        }
    }
}

