/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.langdetect;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import opennlp.tools.langdetect.LanguageDetectorFactory;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.BaseModel;

public class LanguageDetectorModel
extends BaseModel {
    private static final String COMPONENT_NAME = "LanguageDetectorME";
    private static final String LANGDETECT_MODEL_ENTRY_NAME = "langdetect.model";

    public LanguageDetectorModel(MaxentModel langdetectModel, Map<String, String> manifestInfoEntries, LanguageDetectorFactory factory) {
        super(COMPONENT_NAME, "und", manifestInfoEntries, factory);
        this.artifactMap.put(LANGDETECT_MODEL_ENTRY_NAME, langdetectModel);
        this.checkArtifactMap();
    }

    public LanguageDetectorModel(InputStream in) throws IOException {
        super(COMPONENT_NAME, in);
    }

    public LanguageDetectorModel(File modelFile) throws IOException {
        super(COMPONENT_NAME, modelFile);
    }

    public LanguageDetectorModel(URL modelURL) throws IOException {
        super(COMPONENT_NAME, modelURL);
    }

    @Override
    protected void validateArtifactMap() throws InvalidFormatException {
        super.validateArtifactMap();
        if (!(this.artifactMap.get(LANGDETECT_MODEL_ENTRY_NAME) instanceof AbstractModel)) {
            throw new InvalidFormatException("Language detector model is incomplete!");
        }
    }

    public LanguageDetectorFactory getFactory() {
        return (LanguageDetectorFactory)this.toolFactory;
    }

    @Override
    protected Class<? extends BaseToolFactory> getDefaultFactory() {
        return LanguageDetectorFactory.class;
    }

    public MaxentModel getMaxentModel() {
        return (MaxentModel)this.artifactMap.get(LANGDETECT_MODEL_ENTRY_NAME);
    }
}

