/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.clustering.stc;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.IntStack;
import java.util.ArrayList;
import org.carrot2.text.suffixtree.IntegerSequence;
import org.carrot2.text.suffixtree.SuffixTree;
import org.carrot2.text.suffixtree.SuffixTreeBuilder;

final class GeneralizedSuffixTree {
    private GeneralizedSuffixTree() {
    }

    static abstract class Visitor {
        private final IntStack edges = new IntStack();
        private final ArrayList<BitSet> bsets = new ArrayList();
        private final SuffixTree stree;
        protected final SequenceBuilder sb;
        private int minCardinality;

        public Visitor(SequenceBuilder sb, int minCardinality) {
            assert (minCardinality > 1);
            this.stree = sb.stree;
            this.sb = sb;
            this.minCardinality = minCardinality;
        }

        public void visit() {
            if (this.stree.isLeaf(this.stree.getRootState())) {
                return;
            }
            this.countDocs(0, this.stree.getRootState());
        }

        private void countDocs(int level, int state) {
            int card;
            assert (!this.stree.isLeaf(state));
            BitSet me = this.getBitSet(level);
            int edge = this.stree.firstEdge(state);
            while (edge != -1) {
                int childState = this.stree.getToState(edge);
                if (this.stree.isLeaf(childState)) {
                    int documentIndex = this.sb.stateOriginDocument.get(childState);
                    me.set((long)documentIndex);
                } else {
                    BitSet child = this.getBitSet(level + 1);
                    child.clear();
                    this.edges.push(this.stree.getStartIndex(edge), this.stree.getEndIndex(edge));
                    this.countDocs(level + 1, childState);
                    this.edges.discard(2);
                    me.or(child);
                }
                edge = this.stree.nextEdge(edge);
            }
            if (this.stree.getRootState() != state && (card = (int)me.cardinality()) >= this.minCardinality) {
                this.visit(state, card, me, this.edges);
            }
        }

        protected abstract void visit(int var1, int var2, BitSet var3, IntStack var4);

        private BitSet getBitSet(int level) {
            while (this.bsets.size() <= level) {
                this.bsets.add(new BitSet());
            }
            return this.bsets.get(level);
        }
    }

    static class SequenceBuilder {
        private int separator = -1;
        public final IntStack input = new IntStack();
        public IntStack documentMarkers = new IntStack();
        public IntStack stateOriginDocument = new IntStack();
        public SuffixTree stree;

        SequenceBuilder() {
        }

        public void addPhrase(int[] terms, int start, int len) {
            this.input.push(terms, start, len);
            this.input.push(this.separator--);
        }

        public void addPhrase(int ... terms) {
            this.addPhrase(terms, 0, terms.length);
        }

        public void endDocument() {
            this.documentMarkers.push(this.input.size());
        }

        public void buildSuffixTree() {
            this.stateOriginDocument.clear();
            LeafStateMarker marker = new LeafStateMarker();
            IntegerSequence seq = new IntegerSequence(this.input.buffer, 0, this.input.elementsCount);
            this.stree = SuffixTreeBuilder.from(seq).withProgressCallback(marker).withStateCallback(marker).build();
        }

        private final class LeafStateMarker
        implements SuffixTree.IStateCallback,
        SuffixTree.IProgressCallback {
            private int currentDocument = 0;
            private int markerIndex = 0;

            private LeafStateMarker() {
            }

            @Override
            public void next(int pos) {
                if (pos == SequenceBuilder.this.documentMarkers.get(this.markerIndex)) {
                    ++this.currentDocument;
                    ++this.markerIndex;
                }
            }

            @Override
            public void newState(int state, int position) {
                while (SequenceBuilder.this.stateOriginDocument.size() < state) {
                    SequenceBuilder.this.stateOriginDocument.push(-1);
                }
                SequenceBuilder.this.stateOriginDocument.push(this.currentDocument);
            }
        }
    }
}

