/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing;

import com.carrotsearch.hppc.IntArrayList;
import java.util.Arrays;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.filter.CompleteLabelFilter;
import org.carrot2.text.preprocessing.filter.GenitiveLabelFilter;
import org.carrot2.text.preprocessing.filter.MinLengthLabelFilter;
import org.carrot2.text.preprocessing.filter.NumericLabelFilter;
import org.carrot2.text.preprocessing.filter.QueryLabelFilter;
import org.carrot2.text.preprocessing.filter.StopLabelFilter;
import org.carrot2.text.preprocessing.filter.StopWordLabelFilter;
import org.carrot2.util.attribute.Bindable;

@Bindable(prefix="LabelFilterProcessor")
public class LabelFilterProcessor {
    public QueryLabelFilter queryLabelFilter = new QueryLabelFilter();
    public StopWordLabelFilter stopWordLabelFilter = new StopWordLabelFilter();
    public NumericLabelFilter numericLabelFilter = new NumericLabelFilter();
    public CompleteLabelFilter completeLabelFilter = new CompleteLabelFilter();
    public MinLengthLabelFilter minLengthLabelFilter = new MinLengthLabelFilter();
    public GenitiveLabelFilter genitiveLabelFilter = new GenitiveLabelFilter();
    public StopLabelFilter stopLabelFilter = new StopLabelFilter();

    public void process(PreprocessingContext context) {
        int i;
        int wordCount = context.allWords.image.length;
        boolean[] acceptedStems = new boolean[context.allStems.image.length];
        boolean[] acceptedPhrases = new boolean[context.allPhrases.tf.length];
        Arrays.fill(acceptedStems, true);
        Arrays.fill(acceptedPhrases, true);
        this.minLengthLabelFilter.filter(context, acceptedStems, acceptedPhrases);
        this.genitiveLabelFilter.filter(context, acceptedStems, acceptedPhrases);
        this.queryLabelFilter.filter(context, acceptedStems, acceptedPhrases);
        this.stopWordLabelFilter.filter(context, acceptedStems, acceptedPhrases);
        this.numericLabelFilter.filter(context, acceptedStems, acceptedPhrases);
        this.stopLabelFilter.filter(context, acceptedStems, acceptedPhrases);
        this.completeLabelFilter.filter(context, acceptedStems, acceptedPhrases);
        IntArrayList acceptedFeatures = new IntArrayList(acceptedStems.length + acceptedPhrases.length);
        int[] mostFrequentOriginalWordIndex = context.allStems.mostFrequentOriginalWordIndex;
        for (i = 0; i < acceptedStems.length; ++i) {
            if (!acceptedStems[i]) continue;
            acceptedFeatures.add(mostFrequentOriginalWordIndex[i]);
        }
        for (i = 0; i < acceptedPhrases.length; ++i) {
            if (!acceptedPhrases[i]) continue;
            acceptedFeatures.add(i + wordCount);
        }
        context.allLabels.featureIndex = acceptedFeatures.toArray();
        LabelFilterProcessor.updateFirstPhraseIndex(context);
    }

    static void updateFirstPhraseIndex(PreprocessingContext context) {
        int wordCount = context.allWords.image.length;
        int[] labelsFeatureIndex = context.allLabels.featureIndex;
        int firstPhraseIndex = -1;
        for (int i = 0; i < labelsFeatureIndex.length; ++i) {
            if (labelsFeatureIndex[i] < wordCount) continue;
            firstPhraseIndex = i;
            break;
        }
        context.allLabels.firstPhraseIndex = firstPhraseIndex;
    }
}

