/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;
import org.carrot2.util.attribute.IObjectFactory;

public final class PhraseExtractorDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.text.preprocessing.PhraseExtractor";
    public final String prefix = "PhraseExtractor";
    public final String title = "Extracts frequent phrases from the provided document";
    public final String label = "";
    public final String description = "A frequent phrase is a sequence of words that appears in the documents more than once. This phrase extractor aggregates different inflection variants of phrase words into one phrase, returning the most frequent variant. For example, if phrase <i>computing science</i> appears 2 times and <i>computer sciences</i> appears 4 times, the latter will be returned with aggregated frequency of 6. <p> This class saves the following results to the <code>PreprocessingContext</code>: <ul> <li><code>AllPhrases.wordIndices</code></li> <li><code>AllPhrases.tf</code></li> <li><code>AllPhrases.tfByDocument</code></li> <li><code>AllTokens.suffixOrder</code></li> <li><code>AllTokens.lcp</code></li> </ul> <p> This class requires that <code>Tokenizer</code>, <code>CaseNormalizer</code> and <code>LanguageModelStemmer</code> be invoked first.";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    public String getPrefix() {
        return "PhraseExtractor";
    }

    public String getTitle() {
        return "Extracts frequent phrases from the provided document";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "A frequent phrase is a sequence of words that appears in the documents more than once. This phrase extractor aggregates different inflection variants of phrase words into one phrase, returning the most frequent variant. For example, if phrase <i>computing science</i> appears 2 times and <i>computer sciences</i> appears 4 times, the latter will be returned with aggregated frequency of 6. <p> This class saves the following results to the <code>PreprocessingContext</code>: <ul> <li><code>AllPhrases.wordIndices</code></li> <li><code>AllPhrases.tf</code></li> <li><code>AllPhrases.tfByDocument</code></li> <li><code>AllTokens.suffixOrder</code></li> <li><code>AllTokens.lcp</code></li> </ul> <p> This class requires that <code>Tokenizer</code>, <code>CaseNormalizer</code> and <code>LanguageModelStemmer</code> be invoked first.";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(PhraseExtractorDescriptor.attributes.dfThreshold);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(PhraseExtractorDescriptor.attributes.dfThreshold);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public AttributeBuilder dfThreshold(int value) {
            this.map.put("PhraseExtractor.dfThreshold", value);
            return this;
        }

        public AttributeBuilder dfThreshold(IObjectFactory<? extends Integer> value) {
            this.map.put("PhraseExtractor.dfThreshold", value);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo dfThreshold = new AttributeInfo("PhraseExtractor.dfThreshold", "org.carrot2.text.preprocessing.PhraseExtractor", "dfThreshold", "Phrase Document Frequency threshold. Phrases appearing in fewer than\n<code>dfThreshold</code> documents will be ignored.", "Phrase document frequency threshold", "Phrase Document Frequency threshold", "Phrases appearing in fewer than <code>dfThreshold</code> documents will be ignored.", "Phrase extraction", AttributeLevel.ADVANCED, null);

        private Attributes() {
        }
    }

    public static class Keys {
        public static final String DF_THRESHOLD = "PhraseExtractor.dfThreshold";

        protected Keys() {
        }
    }
}

