/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing.filter;

import java.util.ArrayList;
import java.util.List;
import org.carrot2.shaded.guava.common.collect.Lists;
import org.carrot2.text.preprocessing.PreprocessingContext;

abstract class CompleteLabelFilterBase {
    CompleteLabelFilterBase() {
    }

    void filter(PreprocessingContext context, boolean[] acceptedStems, boolean[] acceptedPhrases, double labelOverrideThreshold) {
        if (acceptedStems.length + acceptedPhrases.length < 2) {
            return;
        }
        int[] stemTf = context.allStems.tf;
        int[] phraseTf = context.allPhrases.tf;
        int[] mostFrequentOriginalWordIndex = context.allStems.mostFrequentOriginalWordIndex;
        int[] wordsStemIndex = context.allWords.stemIndex;
        ArrayList phraseIndexesWithCodes = Lists.newArrayListWithExpectedSize((int)(acceptedStems.length + acceptedPhrases.length));
        for (int i = 0; i < acceptedStems.length + acceptedPhrases.length; ++i) {
            phraseIndexesWithCodes.add(new LabelIndexWithCodes(i, CompleteLabelFilterBase.getLabelWordIndexes(acceptedStems.length, mostFrequentOriginalWordIndex, context.allPhrases.wordIndices, i)));
        }
        List<LabelIndexWithCodes> sortedPhrasesWithCodes = this.sortPhraseCodes(phraseIndexesWithCodes);
        int[] lcpArray = this.createLcp(sortedPhrasesWithCodes);
        block1: for (int i = 0; i < sortedPhrasesWithCodes.size() - 1; ++i) {
            LabelIndexWithCodes currentLabelWithCodes = sortedPhrasesWithCodes.get(i);
            int currentLabelIndex = currentLabelWithCodes.getLabelIndex();
            if (CompleteLabelFilterBase.getLabelLength(acceptedStems.length, context.allPhrases.wordIndices, currentLabelIndex) != lcpArray[i] || !CompleteLabelFilterBase.isLabelAccepted(acceptedStems.length, wordsStemIndex, currentLabelIndex, acceptedStems, acceptedPhrases)) continue;
            for (int j = i; j < sortedPhrasesWithCodes.size() - 1 && lcpArray[j] >= lcpArray[i]; ++j) {
                LabelIndexWithCodes nextPhraseWithCodes = sortedPhrasesWithCodes.get(j + 1);
                int nextLabelIndex = nextPhraseWithCodes.getLabelIndex();
                double labelOverride = CompleteLabelFilterBase.calculateLabelOverride(acceptedStems.length, stemTf, phraseTf, nextLabelIndex, currentLabelIndex);
                if (!CompleteLabelFilterBase.isLabelAccepted(acceptedStems.length, wordsStemIndex, nextLabelIndex, acceptedStems, acceptedPhrases) || !(labelOverride >= labelOverrideThreshold)) continue;
                CompleteLabelFilterBase.markLabelAsRemoved(acceptedStems.length, currentLabelIndex, acceptedStems, acceptedPhrases);
                continue block1;
            }
        }
    }

    abstract List<LabelIndexWithCodes> sortPhraseCodes(List<LabelIndexWithCodes> var1);

    abstract int[] createLcp(List<LabelIndexWithCodes> var1);

    private static final int[] getLabelWordIndexes(int wordCount, int[] mostFrequentWordIndex, int[][] wordIndices, int featureIndex) {
        if (featureIndex < wordCount) {
            return new int[]{mostFrequentWordIndex[featureIndex]};
        }
        return wordIndices[featureIndex - wordCount];
    }

    private static final int getLabelLength(int wordCount, int[][] wordIndices, int featureIndex) {
        return featureIndex < wordCount ? 1 : wordIndices[featureIndex - wordCount].length;
    }

    private static final boolean isLabelAccepted(int wordCount, int[] wordStemIndex, int featureIndex, boolean[] acceptedStems, boolean[] acceptedPhrases) {
        if (featureIndex < wordCount) {
            return acceptedStems[featureIndex];
        }
        return acceptedPhrases[featureIndex - wordCount];
    }

    private static final void markLabelAsRemoved(int wordCount, int featureIndex, boolean[] acceptedWords, boolean[] acceptedPhrases) {
        if (featureIndex < wordCount) {
            acceptedWords[featureIndex] = false;
        } else {
            acceptedPhrases[featureIndex - wordCount] = false;
        }
    }

    private static final double calculateLabelOverride(int wordCount, int[] wordTf, int[] phraseTf, int overridingLabelIndex, int overridenLabelIndex) {
        int overridingTf = overridingLabelIndex < wordCount ? wordTf[overridingLabelIndex] : phraseTf[overridingLabelIndex - wordCount];
        int overridenTf = overridenLabelIndex < wordCount ? wordTf[overridenLabelIndex] : phraseTf[overridenLabelIndex - wordCount];
        return (double)overridingTf / (double)overridenTf;
    }

    static class LabelIndexWithCodes {
        private final int labelIndex;
        private final int[] codes;

        public LabelIndexWithCodes(int labelIndex, int[] codes) {
            this.labelIndex = labelIndex;
            this.codes = codes;
        }

        public int[] getCodes() {
            return this.codes;
        }

        public int getLabelIndex() {
            return this.labelIndex;
        }
    }
}

