/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

public class RangeUtils {
    public static int getIntMinorTicks(int min, int max) {
        int majorTicks = RangeUtils.getIntMajorTicks(min, max);
        if (majorTicks % 2 == 0) {
            return majorTicks / 2;
        }
        return majorTicks;
    }

    public static int getIntMajorTicks(int min, int max) {
        int diff = max - min;
        if (diff < 0) {
            diff = -diff;
        }
        if (diff <= 10) {
            return 1;
        }
        int magnitude = (int)(Math.log(diff - 1) / Math.log(10.0));
        int bucket = (int)((double)diff / Math.pow(10.0, magnitude));
        if (bucket <= 2) {
            return (int)(5.0 * Math.pow(10.0, magnitude - 1));
        }
        if (bucket <= 5) {
            return (int)(10.0 * Math.pow(10.0, magnitude - 1));
        }
        return (int)(20.0 * Math.pow(10.0, magnitude - 1));
    }

    public static double getDoubleMinorTicks(double min, double max) {
        return RangeUtils.getDoubleMajorTicks(min, max) / 2.0;
    }

    public static double getDoubleMajorTicks(double min, double max) {
        double diff = max - min;
        if (diff < 0.0) {
            diff = -diff;
        }
        if (diff <= 1.0) {
            return 0.2;
        }
        int magnitude = (int)(Math.log(diff - 1.0E-5) / Math.log(10.0));
        int bucket = (int)(diff / Math.pow(10.0, magnitude));
        if (bucket <= 2) {
            return 5.0 * Math.pow(10.0, magnitude - 1);
        }
        if (bucket <= 5) {
            return 10.0 * Math.pow(10.0, magnitude - 1);
        }
        return 20.0 * Math.pow(10.0, magnitude - 1);
    }
}

