/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.resource;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Objects;
import org.carrot2.shaded.guava.common.collect.Lists;
import org.carrot2.util.resource.IResource;
import org.carrot2.util.resource.IResourceLocator;
import org.carrot2.util.resource.URLResource;

public final class ClassLoaderLocator
implements IResourceLocator {
    private final ClassLoader loader;

    public ClassLoaderLocator(ClassLoader loader) {
        if (loader == null) {
            throw new IllegalArgumentException("Class loader must be not-null.");
        }
        this.loader = loader;
    }

    @Override
    public IResource[] getAll(String resource) {
        return ClassLoaderLocator.getAll(this.loader, resource);
    }

    static IResource[] getAll(ClassLoader loader, String resource) {
        ArrayList result = Lists.newArrayList();
        try {
            while (resource.startsWith("/")) {
                resource = resource.substring(1);
            }
            Enumeration<URL> e = loader.getResources(resource);
            while (e.hasMoreElements()) {
                URL resourceURL = e.nextElement();
                result.add(new URLResource(resourceURL));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result.toArray(new IResource[result.size()]);
    }

    @Override
    public int hashCode() {
        return this.loader.hashCode();
    }

    @Override
    public boolean equals(Object target) {
        if (target == this) {
            return true;
        }
        if (target != null && target instanceof ClassLoaderLocator) {
            return Objects.equals(this.loader, ((ClassLoaderLocator)target).loader);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + " [class loader: " + this.loader + "]";
    }
}

