/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.xsltfilter;

import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class AddHeaderFilter
implements Filter {
    private static final String INIT_PARAM_URI_REGEXP = "uri.regexp";
    private static final String INIT_PARAM_HTTP_HEADER_PREFIX = "http:";
    private Pattern uriRegexp;
    private Map<String, String> httpHeaders = new LinkedHashMap<String, String>();

    public void init(FilterConfig filterConfig) throws ServletException {
        if (filterConfig == null) {
            throw new IllegalArgumentException("FilterConfig must not be null.");
        }
        Enumeration e = filterConfig.getInitParameterNames();
        while (e.hasMoreElements()) {
            String initParam = (String)e.nextElement();
            if (initParam.startsWith(INIT_PARAM_HTTP_HEADER_PREFIX)) {
                this.httpHeaders.put(initParam.substring(INIT_PARAM_HTTP_HEADER_PREFIX.length()), filterConfig.getInitParameter(initParam));
                continue;
            }
            if (initParam.equals(INIT_PARAM_URI_REGEXP)) {
                this.uriRegexp = Pattern.compile(filterConfig.getInitParameter(INIT_PARAM_URI_REGEXP));
                continue;
            }
            throw new ServletException("Not a valid parameter: " + initParam);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.uriRegexp.matcher(httpRequest.getRequestURI()).matches()) {
            for (Map.Entry<String, String> e : this.httpHeaders.entrySet()) {
                httpResponse.setHeader(e.getKey(), e.getValue());
            }
        }
        chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
    }

    public void destroy() {
    }
}

