/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ddf;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EscherRecordTypes {
    DGG_CONTAINER(61440, "DggContainer", null),
    BSTORE_CONTAINER(61441, "BStoreContainer", null),
    DG_CONTAINER(61442, "DgContainer", null),
    SPGR_CONTAINER(61443, "SpgrContainer", null),
    SP_CONTAINER(61444, "SpContainer", null),
    SOLVER_CONTAINER(61445, "SolverContainer", null),
    DGG(61446, "Dgg", "MsofbtDgg"),
    BSE(61447, "BSE", "MsofbtBSE"),
    DG(61448, "Dg", "MsofbtDg"),
    SPGR(61449, "Spgr", "MsofbtSpgr"),
    SP(61450, "Sp", "MsofbtSp"),
    OPT(61451, "Opt", "msofbtOPT"),
    TEXTBOX(61452, null, null),
    CLIENT_TEXTBOX(61453, "ClientTextbox", "msofbtClientTextbox"),
    ANCHOR(61454, null, null),
    CHILD_ANCHOR(61455, "ChildAnchor", "MsofbtChildAnchor"),
    CLIENT_ANCHOR(61456, "ClientAnchor", "MsofbtClientAnchor"),
    CLIENT_DATA(61457, "ClientData", "MsofbtClientData"),
    CONNECTOR_RULE(61458, null, null),
    ALIGN_RULE(61459, null, null),
    ARC_RULE(61460, null, null),
    CLIENT_RULE(61461, null, null),
    CLSID(61462, null, null),
    CALLOUT_RULE(61463, null, null),
    BLIP_START(61464, "Blip", "msofbtBlip"),
    BLIP_EMF(61466, "BlipEmf", null),
    BLIP_WMF(61467, "BlipWmf", null),
    BLIP_PICT(61468, "BlipPict", null),
    BLIP_JPEG(61469, "BlipJpeg", null),
    BLIP_PNG(61470, "BlipPng", null),
    BLIP_DIB(61471, "BlipDib", null),
    BLIP_END(61719, "Blip", "msofbtBlip"),
    REGROUP_ITEMS(61720, null, null),
    SELECTION(61721, null, null),
    COLOR_MRU(61722, null, null),
    DELETED_PSPL(61725, null, null),
    SPLIT_MENU_COLORS(61726, "SplitMenuColors", "MsofbtSplitMenuColors"),
    OLE_OBJECT(61727, null, null),
    COLOR_SCHEME(61728, null, null),
    USER_DEFINED(61730, "TertiaryOpt", null),
    UNKNOWN(65535, "unknown", "unknown");

    public final short typeID;
    public final String recordName;
    public final String description;
    private static final Map<Short, EscherRecordTypes> LOOKUP;

    private EscherRecordTypes(int typeID, String recordName, String description) {
        this.typeID = (short)typeID;
        this.recordName = recordName;
        this.description = description;
    }

    private Short getTypeId() {
        return this.typeID;
    }

    public static EscherRecordTypes forTypeID(int typeID) {
        EscherRecordTypes rt = LOOKUP.get((short)typeID);
        return rt != null ? rt : UNKNOWN;
    }

    static {
        LOOKUP = Stream.of(EscherRecordTypes.values()).collect(Collectors.toMap(EscherRecordTypes::getTypeId, Function.identity()));
    }
}

