/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl.expr;

import com.healthmarketscience.jackcess.expr.LocaleContext;
import com.healthmarketscience.jackcess.expr.Value;
import com.healthmarketscience.jackcess.impl.expr.BaseNumericValue;
import java.math.BigDecimal;

public class LongValue
extends BaseNumericValue {
    private final Integer _val;

    public LongValue(Integer val) {
        this._val = val;
    }

    @Override
    public Value.Type getType() {
        return Value.Type.LONG;
    }

    @Override
    public Object get() {
        return this._val;
    }

    @Override
    protected Number getNumber() {
        return this._val;
    }

    @Override
    public boolean getAsBoolean(LocaleContext ctx) {
        return this._val.longValue() != 0L;
    }

    @Override
    public Integer getAsLongInt(LocaleContext ctx) {
        return this._val;
    }

    @Override
    public BigDecimal getAsBigDecimal(LocaleContext ctx) {
        return BigDecimal.valueOf(this._val.intValue());
    }

    @Override
    public String getAsString(LocaleContext ctx) {
        return this._val.toString();
    }
}

