/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.util;

import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.impl.DatabaseImpl;
import java.util.Iterator;

public class TableIterableBuilder
implements Iterable<Table> {
    private final Database _db;
    private boolean _includeNormalTables = true;
    private boolean _includeSystemTables;
    private boolean _includeLinkedTables = true;

    public TableIterableBuilder(Database db) {
        this._db = db;
    }

    public boolean isIncludeNormalTables() {
        return this._includeNormalTables;
    }

    public boolean isIncludeSystemTables() {
        return this._includeSystemTables;
    }

    public boolean isIncludeLinkedTables() {
        return this._includeLinkedTables;
    }

    public TableIterableBuilder setIncludeNormalTables(boolean includeNormalTables) {
        this._includeNormalTables = includeNormalTables;
        return this;
    }

    public TableIterableBuilder setIncludeSystemTables(boolean includeSystemTables) {
        this._includeSystemTables = includeSystemTables;
        return this;
    }

    public TableIterableBuilder setIncludeLinkedTables(boolean includeLinkedTables) {
        this._includeLinkedTables = includeLinkedTables;
        return this;
    }

    public TableIterableBuilder withLocalUserTablesOnly() {
        this.setIncludeNormalTables(true);
        this.setIncludeSystemTables(false);
        return this.setIncludeLinkedTables(false);
    }

    public TableIterableBuilder withSystemTablesOnly() {
        this.setIncludeNormalTables(false);
        this.setIncludeSystemTables(true);
        return this.setIncludeLinkedTables(false);
    }

    @Override
    public Iterator<Table> iterator() {
        return ((DatabaseImpl)this._db).iterator(this);
    }
}

