/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hemf.usermodel;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.poi.common.usermodel.GenericRecord;
import org.apache.poi.hemf.draw.HemfDrawProperties;
import org.apache.poi.hemf.draw.HemfGraphics;
import org.apache.poi.hemf.record.emf.HemfHeader;
import org.apache.poi.hemf.record.emf.HemfRecord;
import org.apache.poi.hemf.record.emf.HemfRecordIterator;
import org.apache.poi.hemf.record.emf.HemfWindowing;
import org.apache.poi.hemf.usermodel.HemfEmbeddedIterator;
import org.apache.poi.hwmf.usermodel.HwmfEmbedded;
import org.apache.poi.util.Dimension2DDouble;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndianInputStream;
import org.apache.poi.util.Units;

@Internal
public class HemfPicture
implements Iterable<HemfRecord>,
GenericRecord {
    private final LittleEndianInputStream stream;
    private final List<HemfRecord> records = new ArrayList<HemfRecord>();
    private boolean isParsed = false;

    public HemfPicture(InputStream is) throws IOException {
        this(new LittleEndianInputStream(is));
    }

    public HemfPicture(LittleEndianInputStream is) throws IOException {
        this.stream = is;
    }

    public HemfHeader getHeader() {
        return (HemfHeader)this.getRecords().get(0);
    }

    public List<HemfRecord> getRecords() {
        if (!this.isParsed) {
            this.isParsed = true;
            HemfHeader[] header = new HemfHeader[1];
            new HemfRecordIterator(this.stream).forEachRemaining(r -> {
                if (r instanceof HemfHeader) {
                    header[0] = (HemfHeader)r;
                }
                r.setHeader(header[0]);
                this.records.add((HemfRecord)r);
            });
        }
        return this.records;
    }

    @Override
    public Iterator<HemfRecord> iterator() {
        return this.getRecords().iterator();
    }

    @Override
    public Spliterator<HemfRecord> spliterator() {
        return this.getRecords().spliterator();
    }

    @Override
    public void forEach(Consumer<? super HemfRecord> action) {
        this.getRecords().forEach(action);
    }

    public Rectangle2D getBounds() {
        Rectangle2D dim = this.getHeader().getFrameRectangle();
        double x = dim.getX();
        double y = dim.getY();
        double width = dim.getWidth();
        double height = dim.getHeight();
        if (dim.isEmpty() || Math.rint(width) == 0.0 || Math.rint(height) == 0.0) {
            for (HemfRecord r : this.getRecords()) {
                if (r instanceof HemfWindowing.EmfSetWindowExtEx) {
                    HemfWindowing.EmfSetWindowExtEx extEx = (HemfWindowing.EmfSetWindowExtEx)r;
                    Dimension2D d = extEx.getSize();
                    width = d.getWidth();
                    height = d.getHeight();
                }
                if (!(r instanceof HemfWindowing.EmfSetWindowOrgEx)) continue;
                HemfWindowing.EmfSetWindowOrgEx orgEx = (HemfWindowing.EmfSetWindowOrgEx)r;
                x = orgEx.getX();
                y = orgEx.getY();
            }
        }
        return new Rectangle2D.Double(x, y, width, height);
    }

    public Dimension2D getSize() {
        Rectangle2D b = this.getHeader().getBoundsRectangle();
        return Units.pixelToPoints((Dimension2D)new Dimension2DDouble(Math.abs(b.getWidth()), Math.abs(b.getHeight())));
    }

    private static double minX(Rectangle2D bounds) {
        return Math.min(bounds.getMinX(), bounds.getMaxX());
    }

    private static double minY(Rectangle2D bounds) {
        return Math.min(bounds.getMinY(), bounds.getMaxY());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics2D ctx, Rectangle2D graphicsBounds) {
        Shape clip = ctx.getClip();
        AffineTransform at = ctx.getTransform();
        try {
            Rectangle2D emfBounds = this.getHeader().getBoundsRectangle();
            ctx.translate(graphicsBounds.getCenterX(), graphicsBounds.getCenterY());
            ctx.scale(graphicsBounds.getWidth() / emfBounds.getWidth(), graphicsBounds.getHeight() / emfBounds.getHeight());
            ctx.translate(-emfBounds.getCenterX(), -emfBounds.getCenterY());
            HemfGraphics g = new HemfGraphics(ctx, emfBounds);
            HemfDrawProperties prop = g.getProperties();
            prop.setViewportOrg(emfBounds.getX(), emfBounds.getY());
            prop.setViewportExt(emfBounds.getWidth(), emfBounds.getHeight());
            int idx = 0;
            for (HemfRecord r : this.getRecords()) {
                try {
                    g.draw(r);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                ++idx;
            }
        }
        finally {
            ctx.setTransform(at);
            ctx.setClip(clip);
        }
    }

    public Iterable<HwmfEmbedded> getEmbeddings() {
        return () -> new HemfEmbeddedIterator(this);
    }

    public List<? extends GenericRecord> getGenericChildren() {
        return this.getRecords();
    }

    public Map<String, Supplier<?>> getGenericProperties() {
        return null;
    }
}

