/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.rawcoder;

import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import org.apache.hadoop.io.erasurecode.rawcoder.ByteArrayDecodingState;
import org.apache.hadoop.io.erasurecode.rawcoder.ByteBufferDecodingState;
import org.apache.hadoop.io.erasurecode.rawcoder.CoderUtil;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureDecoder;

@InterfaceAudience.Private
public class XORRawDecoder
extends RawErasureDecoder {
    public XORRawDecoder(ErasureCoderOptions coderOptions) {
        super(coderOptions);
    }

    @Override
    protected void doDecode(ByteBufferDecodingState decodingState) {
        CoderUtil.resetOutputBuffers(decodingState.outputs, decodingState.decodeLength);
        ByteBuffer output = decodingState.outputs[0];
        int erasedIdx = decodingState.erasedIndexes[0];
        for (int i = 0; i < decodingState.inputs.length; ++i) {
            if (i == erasedIdx) continue;
            int iIdx = decodingState.inputs[i].position();
            int oIdx = output.position();
            while (iIdx < decodingState.inputs[i].limit()) {
                output.put(oIdx, (byte)(output.get(oIdx) ^ decodingState.inputs[i].get(iIdx)));
                ++iIdx;
                ++oIdx;
            }
        }
    }

    @Override
    protected void doDecode(ByteArrayDecodingState decodingState) {
        byte[] output = decodingState.outputs[0];
        int dataLen = decodingState.decodeLength;
        CoderUtil.resetOutputBuffers(decodingState.outputs, decodingState.outputOffsets, dataLen);
        int erasedIdx = decodingState.erasedIndexes[0];
        for (int i = 0; i < decodingState.inputs.length; ++i) {
            if (i == erasedIdx) continue;
            int oIdx = decodingState.outputOffsets[0];
            for (int iIdx = decodingState.inputOffsets[i]; iIdx < decodingState.inputOffsets[i] + dataLen; ++iIdx) {
                int n = oIdx++;
                output[n] = (byte)(output[n] ^ decodingState.inputs[i][iIdx]);
            }
        }
    }
}

