/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core.backup.repository;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.backup.repository.BackupRepository;

public class LocalFileSystemRepository
implements BackupRepository {
    private NamedList config = null;

    @Override
    public void init(NamedList args) {
        this.config = args;
    }

    @Override
    public <T> T getConfigProperty(String name) {
        return (T)this.config.get(name);
    }

    @Override
    public URI createURI(String location) {
        Objects.requireNonNull(location);
        URI result = null;
        try {
            result = new URI(location);
            if (!result.isAbsolute()) {
                result = Paths.get(location, new String[0]).toUri();
            }
        }
        catch (URISyntaxException ex) {
            result = Paths.get(location, new String[0]).toUri();
        }
        return result;
    }

    @Override
    public URI resolve(URI baseUri, String ... pathComponents) {
        Preconditions.checkArgument((pathComponents.length > 0 ? 1 : 0) != 0);
        Path result = Paths.get(baseUri);
        for (int i = 0; i < pathComponents.length; ++i) {
            result = result.resolve(pathComponents[i]);
        }
        return result.toUri();
    }

    @Override
    public void createDirectory(URI path) throws IOException {
        Files.createDirectory(Paths.get(path), new FileAttribute[0]);
    }

    @Override
    public void deleteDirectory(URI path) throws IOException {
        Files.walkFileTree(Paths.get(path), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @Override
    public boolean exists(URI path) throws IOException {
        return Files.exists(Paths.get(path), new LinkOption[0]);
    }

    @Override
    public IndexInput openInput(URI dirPath, String fileName, IOContext ctx) throws IOException {
        try (SimpleFSDirectory dir = new SimpleFSDirectory(Paths.get(dirPath), (LockFactory)NoLockFactory.INSTANCE);){
            IndexInput indexInput = dir.openInput(fileName, ctx);
            return indexInput;
        }
    }

    @Override
    public OutputStream createOutput(URI path) throws IOException {
        return Files.newOutputStream(Paths.get(path), new OpenOption[0]);
    }

    @Override
    public String[] listAll(URI dirPath) throws IOException {
        try (SimpleFSDirectory dir = new SimpleFSDirectory(Paths.get(dirPath), (LockFactory)NoLockFactory.INSTANCE);){
            String[] stringArray = dir.listAll();
            return stringArray;
        }
    }

    @Override
    public BackupRepository.PathType getPathType(URI path) throws IOException {
        return Files.isDirectory(Paths.get(path), new LinkOption[0]) ? BackupRepository.PathType.DIRECTORY : BackupRepository.PathType.FILE;
    }

    @Override
    public void copyFileFrom(Directory sourceDir, String fileName, URI dest) throws IOException {
        try (SimpleFSDirectory dir = new SimpleFSDirectory(Paths.get(dest), (LockFactory)NoLockFactory.INSTANCE);){
            dir.copyFrom(sourceDir, fileName, fileName, DirectoryFactory.IOCONTEXT_NO_CACHE);
        }
    }

    @Override
    public void copyFileTo(URI sourceDir, String fileName, Directory dest) throws IOException {
        try (SimpleFSDirectory dir = new SimpleFSDirectory(Paths.get(sourceDir), (LockFactory)NoLockFactory.INSTANCE);){
            dest.copyFrom((Directory)dir, fileName, fileName, DirectoryFactory.IOCONTEXT_NO_CACHE);
        }
    }

    @Override
    public void close() throws IOException {
    }
}

