/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.facet.AggValueSource;
import org.apache.solr.search.facet.BlockJoin;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetDebugInfo;
import org.apache.solr.search.facet.FacetRequest;
import org.apache.solr.search.facet.SlotAcc;

public abstract class FacetProcessor<FacetRequestT extends FacetRequest> {
    SimpleOrderedMap<Object> response;
    FacetContext fcontext;
    FacetRequestT freq;
    DocSet filter;
    LinkedHashMap<String, SlotAcc> accMap;
    SlotAcc[] accs;
    SlotAcc.CountSlotAcc countAcc;

    FacetProcessor(FacetContext fcontext, FacetRequestT freq) {
        this.fcontext = fcontext;
        this.freq = freq;
        fcontext.processor = this;
    }

    public MapWriter getResponse() {
        return this.response;
    }

    public void process() throws IOException {
        this.handleDomainChanges();
    }

    private void evalFilters() throws IOException {
        if (((FacetRequest)this.freq).domain.filters == null || ((FacetRequest)this.freq).domain.filters.isEmpty()) {
            return;
        }
        this.filter = this.fcontext.searcher.getDocSet(FacetProcessor.evalJSONFilterQueryStruct(this.fcontext, ((FacetRequest)this.freq).domain.filters));
    }

    private static List<Query> evalJSONFilterQueryStruct(FacetContext fcontext, List<Object> filters) throws IOException {
        ArrayList<Query> qlist = new ArrayList<Query>(filters.size());
        for (Object rawFilter : filters) {
            if (rawFilter instanceof String) {
                qlist.add(FacetProcessor.parserFilter((String)rawFilter, fcontext.req));
                continue;
            }
            if (rawFilter instanceof Map) {
                Map m = (Map)rawFilter;
                if (m.size() != 1) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't convert map to query:" + rawFilter);
                }
                Map.Entry entry = m.entrySet().iterator().next();
                String type = (String)entry.getKey();
                Object args = entry.getValue();
                if (!"param".equals(type)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown type. Can't convert map to query:" + rawFilter);
                }
                if (!(args instanceof String)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't retrieve non-string param:" + args);
                }
                String tag = (String)args;
                String[] qstrings = fcontext.req.getParams().getParams(tag);
                if (qstrings == null) continue;
                for (String qstring : qstrings) {
                    qlist.add(FacetProcessor.parserFilter(qstring, fcontext.req));
                }
                continue;
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Bad query (expected a string):" + rawFilter);
        }
        return qlist;
    }

    private static Query parserFilter(String rawFilter, SolrQueryRequest req) {
        QParser parser = null;
        try {
            parser = QParser.getParser(rawFilter, req);
            parser.setIsFilter(true);
            Query symbolicFilter = parser.getQuery();
            if (symbolicFilter == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "QParser yields null, perhaps unresolved parameter reference in: " + rawFilter);
            }
            return symbolicFilter;
        }
        catch (SyntaxError syntaxError) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)syntaxError);
        }
    }

    private void handleDomainChanges() throws IOException {
        if (((FacetRequest)this.freq).domain == null) {
            return;
        }
        if (null != ((FacetRequest)this.freq).domain.explicitQueries) {
            try {
                List<Query> domainQs = FacetProcessor.evalJSONFilterQueryStruct(this.fcontext, ((FacetRequest)this.freq).domain.explicitQueries);
                if (domainQs.isEmpty()) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'query' domain must not evaluate to an empty list of queries");
                }
                this.fcontext.base = this.fcontext.searcher.getDocSet(domainQs);
            }
            catch (SolrException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to parse domain 'query': " + ((FacetRequest)this.freq).domain.explicitQueries + " -- reason: " + e.getMessage(), (Throwable)e);
            }
        } else {
            this.handleFilterExclusions();
        }
        this.evalFilters();
        this.handleJoinField();
        this.handleGraphField();
        boolean appliedFilters = this.handleBlockJoin();
        if (this.filter != null && !appliedFilters) {
            this.fcontext.base = this.fcontext.base.intersection(this.filter);
        }
    }

    private void handleFilterExclusions() throws IOException {
        List<String> excludeTags = ((FacetRequest)this.freq).domain.excludeTags;
        if (excludeTags == null || excludeTags.size() == 0) {
            return;
        }
        Map tagMap = (Map)this.fcontext.req.getContext().get("tags");
        if (tagMap == null) {
            return;
        }
        IdentityHashMap<Query, Boolean> excludeSet = new IdentityHashMap<Query, Boolean>();
        for (String excludeTag : excludeTags) {
            Object olst = tagMap.get(excludeTag);
            if (!(olst instanceof Collection)) continue;
            for (Object o : (Collection)olst) {
                if (!(o instanceof QParser)) continue;
                QParser qp = (QParser)o;
                try {
                    excludeSet.put(qp.getQuery(), Boolean.TRUE);
                }
                catch (SyntaxError syntaxError) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)syntaxError);
                }
            }
        }
        if (excludeSet.size() == 0) {
            return;
        }
        ArrayList<Query> qlist = new ArrayList<Query>();
        ResponseBuilder rb = SolrRequestInfo.getRequestInfo().getResponseBuilder();
        if (!excludeSet.containsKey(rb.getQuery())) {
            qlist.add(rb.getQuery());
        }
        if (rb.getFilters() != null) {
            for (Query q : rb.getFilters()) {
                if (excludeSet.containsKey(q)) continue;
                qlist.add(q);
            }
        }
        FacetContext curr = this.fcontext;
        while (curr != null) {
            if (curr.filter != null) {
                qlist.add(curr.filter);
            }
            curr = curr.parent;
        }
        this.fcontext.base = this.fcontext.searcher.getDocSet(qlist);
    }

    private void handleJoinField() throws IOException {
        if (null == ((FacetRequest)this.freq).domain.joinField) {
            return;
        }
        Query domainQuery = ((FacetRequest)this.freq).domain.joinField.createDomainQuery(this.fcontext);
        this.fcontext.base = this.fcontext.searcher.getDocSet(domainQuery);
    }

    private void handleGraphField() throws IOException {
        if (null == ((FacetRequest)this.freq).domain.graphField) {
            return;
        }
        Query domainQuery = ((FacetRequest)this.freq).domain.graphField.createDomainQuery(this.fcontext);
        this.fcontext.base = this.fcontext.searcher.getDocSet(domainQuery);
    }

    private boolean handleBlockJoin() throws IOException {
        DocSet result;
        Query parentQuery;
        boolean appliedFilters = false;
        if (!((FacetRequest)this.freq).domain.toChildren && !((FacetRequest)this.freq).domain.toParent) {
            return appliedFilters;
        }
        String parentStr = ((FacetRequest)this.freq).domain.parents;
        try {
            QParser parser = QParser.getParser(parentStr, this.fcontext.req);
            parser.setIsFilter(true);
            parentQuery = parser.getQuery();
        }
        catch (SyntaxError err) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error parsing block join parent specification: " + parentStr);
        }
        BitDocSet parents = this.fcontext.searcher.getDocSetBits(parentQuery);
        DocSet input = this.fcontext.base;
        if (((FacetRequest)this.freq).domain.toChildren) {
            DocSet acceptDocs = this.filter;
            if (acceptDocs == null) {
                acceptDocs = this.fcontext.searcher.getLiveDocSet();
            } else {
                appliedFilters = true;
            }
            result = BlockJoin.toChildren(input, parents, acceptDocs, this.fcontext.qcontext);
        } else {
            result = BlockJoin.toParents(input, parents, this.fcontext.qcontext);
        }
        this.fcontext.base = result;
        return appliedFilters;
    }

    protected void processStats(SimpleOrderedMap<Object> bucket, Query bucketQ, DocSet docs, int docCount) throws IOException {
        if (docCount == 0 && !((FacetRequest)this.freq).processEmpty || ((FacetRequest)this.freq).getFacetStats().size() == 0) {
            bucket.add("count", (Object)docCount);
            return;
        }
        this.createAccs(docCount, 1);
        int collected = this.collect(docs, 0, (int slotNum) -> new SlotAcc.SlotContext(bucketQ));
        this.countAcc.incrementCount(0, collected);
        assert (collected == docCount);
        this.addStats(bucket, 0);
    }

    protected void createAccs(int docCount, int slotCount) throws IOException {
        this.accMap = new LinkedHashMap();
        if (this.countAcc == null) {
            this.countAcc = new SlotAcc.CountSlotArrAcc(this.fcontext, slotCount);
            this.countAcc.key = "count";
        }
        for (Map.Entry<String, AggValueSource> entry : ((FacetRequest)this.freq).getFacetStats().entrySet()) {
            SlotAcc acc = entry.getValue().createSlotAcc(this.fcontext, docCount, slotCount);
            acc.key = entry.getKey();
            this.accMap.put(acc.key, acc);
        }
        this.accs = new SlotAcc[this.accMap.size()];
        int i = 0;
        for (SlotAcc acc : this.accMap.values()) {
            this.accs[i++] = acc;
        }
    }

    void resetStats() throws IOException {
        this.countAcc.reset();
        for (SlotAcc acc : this.accs) {
            acc.reset();
        }
    }

    int collect(DocSet docs, int slot, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
        int count = 0;
        SolrIndexSearcher searcher = this.fcontext.searcher;
        if (0 == docs.size()) {
            if (this.accs != null) {
                for (SlotAcc acc : this.accs) {
                    acc.collect(docs, slot, slotContext);
                }
            }
            return count;
        }
        List leaves = searcher.getIndexReader().leaves();
        Iterator ctxIt = leaves.iterator();
        LeafReaderContext ctx = null;
        int segBase = 0;
        int adjustedMax = 0;
        DocIterator docsIt = docs.iterator();
        while (docsIt.hasNext()) {
            int doc = docsIt.nextDoc();
            if (doc >= adjustedMax) {
                int segMax;
                do {
                    if ((ctx = (LeafReaderContext)ctxIt.next()) != null) continue;
                    throw new RuntimeException("INTERNAL FACET ERROR");
                } while (doc >= (adjustedMax = (segBase = ctx.docBase) + (segMax = ctx.reader().maxDoc())));
                assert (doc >= ctx.docBase);
                this.setNextReader(ctx);
            }
            ++count;
            this.collect(doc - segBase, slot, slotContext);
        }
        return count;
    }

    void collect(int segDoc, int slot, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
        if (this.accs != null) {
            for (SlotAcc acc : this.accs) {
                acc.collect(segDoc, slot, slotContext);
            }
        }
    }

    void setNextReader(LeafReaderContext ctx) throws IOException {
        for (SlotAcc acc : this.accs) {
            acc.setNextReader(ctx);
        }
    }

    void addStats(SimpleOrderedMap<Object> target, int slotNum) throws IOException {
        int count = this.countAcc.getCount(slotNum);
        target.add("count", (Object)count);
        if (count > 0 || ((FacetRequest)this.freq).processEmpty) {
            for (SlotAcc acc : this.accs) {
                acc.setValues(target, slotNum);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fillBucket(SimpleOrderedMap<Object> bucket, Query q, DocSet result, boolean skip, Map<String, Object> facetInfo) throws IOException {
        int count;
        boolean needDocSet;
        boolean bl = needDocSet = !skip && ((FacetRequest)this.freq).getFacetStats().size() > 0 || ((FacetRequest)this.freq).getSubFacets().size() > 0;
        if (result != null) {
            count = result.size();
        } else if (needDocSet) {
            result = q == null ? this.fcontext.base : this.fcontext.searcher.getDocSet(q, this.fcontext.base);
            count = result.size();
        } else {
            count = q == null ? this.fcontext.base.size() : this.fcontext.searcher.numDocs(q, this.fcontext.base);
        }
        try {
            if (!skip) {
                this.processStats(bucket, q, result, count);
            }
            this.processSubs(bucket, q, result, skip, facetInfo);
        }
        finally {
            if (result != null) {
                result = null;
            }
        }
    }

    void processSubs(SimpleOrderedMap<Object> response, Query filter, DocSet domain, boolean skip, Map<String, Object> facetInfo) throws IOException {
        boolean emptyDomain = domain == null || domain.size() == 0;
        for (Map.Entry<String, FacetRequest> sub : ((FacetRequest)this.freq).getSubFacets().entrySet()) {
            FacetRequest subRequest = sub.getValue();
            if (emptyDomain && !((FacetRequest)this.freq).processEmpty && !subRequest.canProduceFromEmpty()) continue;
            Map facetInfoSub = null;
            if (facetInfo != null) {
                facetInfoSub = (Map)facetInfo.get(sub.getKey());
            }
            if (skip && facetInfoSub == null) continue;
            FacetContext subContext = this.fcontext.sub(filter, domain);
            subContext.facetInfo = facetInfoSub;
            if (!skip) {
                subContext.flags &= 0xFFFFFFFB;
            }
            if (this.fcontext.getDebugInfo() != null) {
                FacetDebugInfo fdebug = new FacetDebugInfo();
                subContext.setDebugInfo(fdebug);
                this.fcontext.getDebugInfo().addChild(fdebug);
            }
            Object result = subRequest.process(subContext);
            response.add(sub.getKey(), result);
        }
    }

    static DocSet getFieldMissing(SolrIndexSearcher searcher, DocSet docs, String fieldName) throws IOException {
        SchemaField sf = searcher.getSchema().getField(fieldName);
        DocSet hasVal = searcher.getDocSet(sf.getType().getRangeQuery(null, sf, null, null, false, false));
        DocSet answer = docs.andNot(hasVal);
        return answer;
    }

    static Query getFieldMissingQuery(SolrIndexSearcher searcher, String fieldName) throws IOException {
        SchemaField sf = searcher.getSchema().getField(fieldName);
        Query hasVal = sf.getType().getRangeQuery(null, sf, null, null, false, false);
        BooleanQuery.Builder noVal = new BooleanQuery.Builder();
        noVal.add(hasVal, BooleanClause.Occur.MUST_NOT);
        return noVal.build();
    }
}

