/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.text.NumberFormat;
import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.StringFormatter;
import net.arnx.jsonic.io.OutputSource;

final class FloatArrayFormatter
implements Formatter {
    public static final FloatArrayFormatter INSTANCE = new FloatArrayFormatter();

    FloatArrayFormatter() {
    }

    public boolean format(JSON jSON, JSON.Context context, Object object, Object object2, OutputSource outputSource) throws Exception {
        NumberFormat numberFormat = context.format(NumberFormat.class);
        float[] fArray = (float[])object2;
        outputSource.append('[');
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.isNaN(fArray[i]) || Float.isInfinite(fArray[i])) {
                if (context.getMode() != JSON.Mode.SCRIPT) {
                    outputSource.append('\"');
                    outputSource.append(Float.toString(fArray[i]));
                    outputSource.append('\"');
                } else if (Double.isNaN(fArray[i])) {
                    outputSource.append("Number.NaN");
                } else {
                    outputSource.append("Number.");
                    outputSource.append(fArray[i] > 0.0f ? "POSITIVE" : "NEGATIVE");
                    outputSource.append("_INFINITY");
                }
            } else if (numberFormat != null) {
                StringFormatter.serialize(context, numberFormat.format(fArray[i]), outputSource);
            } else {
                outputSource.append(String.valueOf(fArray[i]));
            }
            if (i == fArray.length - 1) continue;
            outputSource.append(',');
            if (!context.isPrettyPrint()) continue;
            outputSource.append(' ');
        }
        outputSource.append(']');
        return true;
    }
}

