/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.FileDataSource;

public class BinFileDataSource
extends DataSource<InputStream> {
    protected String basePath;

    @Override
    public void init(Context context, Properties initProps) {
        this.basePath = initProps.getProperty("basePath");
    }

    @Override
    public InputStream getData(String query) {
        File f = FileDataSource.getFile(this.basePath, query);
        try {
            return new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            DataImportHandlerException.wrapAndThrow(500, e, "Unable to open file " + f.getAbsolutePath());
            return null;
        }
    }

    @Override
    public void close() {
    }
}

