/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.TriggerReferencingStruct;
import org.apache.derby.impl.sql.compile.ValueNode;

public class CreateTriggerNode
extends DDLStatementNode {
    private TableName triggerName;
    private TableName tableName;
    private int triggerEventMask;
    private ResultColumnList triggerCols;
    private boolean isBefore;
    private boolean isRow;
    private boolean isEnabled;
    private Vector refClause;
    private ValueNode whenClause;
    private String whenText;
    private int whenOffset;
    private StatementNode actionNode;
    private String actionText;
    private String originalActionText;
    private int actionOffset;
    private SchemaDescriptor triggerSchemaDescriptor;
    private SchemaDescriptor compSchemaDescriptor;
    private int[] referencedColInts;
    private int[] referencedColsInTriggerAction;
    private TableDescriptor triggerTableDescriptor;
    private UUID actionCompSchemaId;
    private String oldTableName;
    private String newTableName;
    private boolean oldTableInReferencingClause;
    private boolean newTableInReferencingClause;
    private static final Comparator OFFSET_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return ((FromBaseTable)object).getTableNameField().getBeginOffset() - ((FromBaseTable)object2).getTableNameField().getBeginOffset();
        }
    };

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13, Object object14) throws StandardException {
        this.initAndCheck(object);
        this.triggerName = (TableName)object;
        this.tableName = (TableName)object2;
        this.triggerEventMask = (Integer)object3;
        this.triggerCols = (ResultColumnList)object4;
        this.isBefore = (Boolean)object5;
        this.isRow = (Boolean)object6;
        this.isEnabled = (Boolean)object7;
        this.refClause = (Vector)object8;
        this.whenClause = (ValueNode)object9;
        this.whenText = object10 == null ? null : ((String)object10).trim();
        this.whenOffset = (Integer)object11;
        this.actionNode = (StatementNode)object12;
        this.originalActionText = (String)object13;
        this.actionText = object13 == null ? null : ((String)object13).trim();
        this.actionOffset = (Integer)object14;
        this.implicitCreateSchema = true;
    }

    public String statementToString() {
        return "CREATE TRIGGER";
    }

    public void printSubNodes(int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindStatement() throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        DataDictionary dataDictionary = this.getDataDictionary();
        LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
        this.compSchemaDescriptor = languageConnectionContext.getDefaultSchema();
        this.triggerSchemaDescriptor = this.getSchemaDescriptor();
        this.triggerTableDescriptor = this.getTableDescriptor(this.tableName);
        if (this.isSessionSchema(this.triggerTableDescriptor.getSchemaDescriptor())) {
            throw StandardException.newException("XCL51.S");
        }
        if (this.isPrivilegeCollectionRequired()) {
            compilerContext.pushCurrentPrivType(5);
            compilerContext.addRequiredTablePriv(this.triggerTableDescriptor);
            compilerContext.popCurrentPrivType();
        }
        boolean bl = this.bindReferencesClause(dataDictionary);
        languageConnectionContext.pushTriggerTable(this.triggerTableDescriptor);
        try {
            if (bl) {
                compilerContext.setReliability(0);
            }
            if (this.isBefore) {
                compilerContext.setReliability(2048);
            }
            this.actionNode.bindStatement();
        }
        finally {
            languageConnectionContext.popTriggerTable(this.triggerTableDescriptor);
        }
        compilerContext.createDependency(this.triggerTableDescriptor);
        if (this.triggerCols != null && this.triggerCols.size() != 0) {
            Hashtable<String, ResultColumn> hashtable = new Hashtable<String, ResultColumn>();
            int n = this.triggerCols.size();
            for (int i = 0; i < n; ++i) {
                ResultColumn resultColumn = (ResultColumn)this.triggerCols.elementAt(i);
                if (hashtable.put(resultColumn.getName(), resultColumn) != null) {
                    throw StandardException.newException("42Y40", (Object)resultColumn.getName(), (Object)this.triggerName);
                }
                ColumnDescriptor columnDescriptor = this.triggerTableDescriptor.getColumnDescriptor(resultColumn.getName());
                if (columnDescriptor != null) continue;
                throw StandardException.newException("42X14", (Object)resultColumn.getName(), (Object)this.tableName);
            }
        }
        if (this.actionNode.referencesSessionSchema()) {
            throw StandardException.newException("XCL51.S");
        }
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.isSessionSchema(this.triggerTableDescriptor.getSchemaName()) || this.actionNode.referencesSessionSchema();
    }

    private boolean bindReferencesClause(DataDictionary dataDictionary) throws StandardException {
        String string;
        Object object;
        this.validateReferencesClause(dataDictionary);
        if (this.isBefore) {
            this.forbidActionsOnGenCols();
        }
        int n = 0;
        if (this.triggerCols != null && this.triggerCols.size() != 0) {
            this.referencedColInts = new int[this.triggerCols.size()];
            for (int i = 0; i < this.triggerCols.size(); ++i) {
                ResultColumn resultColumn = (ResultColumn)this.triggerCols.elementAt(i);
                object = this.triggerTableDescriptor.getColumnDescriptor(resultColumn.getName());
                if (object == null) {
                    throw StandardException.newException("42X14", (Object)resultColumn.getName(), (Object)this.tableName);
                }
                this.referencedColInts[i] = ((ColumnDescriptor)object).getPosition();
            }
            Arrays.sort(this.referencedColInts);
        }
        if (this.isRow) {
            this.referencedColsInTriggerAction = new int[this.triggerTableDescriptor.getNumberOfColumns()];
            Arrays.fill(this.referencedColsInTriggerAction, -1);
            string = this.getDataDictionary().getTriggerActionString(this.actionNode, this.oldTableName, this.newTableName, this.originalActionText, this.referencedColInts, this.referencedColsInTriggerAction, this.actionOffset, this.triggerTableDescriptor, this.triggerEventMask, true);
            this.referencedColsInTriggerAction = this.justTheRequiredColumns(this.referencedColsInTriggerAction);
        } else {
            int n2 = this.triggerTableDescriptor.getNumberOfColumns();
            object = new StringBuffer();
            CollectNodesVisitor collectNodesVisitor = new CollectNodesVisitor(FromBaseTable.class);
            this.actionNode.accept(collectNodesVisitor);
            Vector vector = collectNodesVisitor.getList();
            Collections.sort(vector, OFFSET_COMPARATOR);
            for (int i = 0; i < vector.size(); ++i) {
                FromBaseTable fromBaseTable = (FromBaseTable)vector.get(i);
                String string2 = fromBaseTable.getTableName().getTableName();
                String string3 = fromBaseTable.getBaseTableName();
                if (string3 == null || (this.oldTableName == null || !this.oldTableName.equals(string3)) && (this.newTableName == null || !this.newTableName.equals(string3))) continue;
                int n3 = fromBaseTable.getTableNameField().getBeginOffset();
                int n4 = fromBaseTable.getTableNameField().getEndOffset();
                if (n3 == -1) continue;
                this.checkInvalidTriggerReference(string3);
                ((StringBuffer)object).append(this.originalActionText.substring(n, n3 - this.actionOffset));
                ((StringBuffer)object).append(string3.equals(this.oldTableName) ? "new org.apache.derby.catalog.TriggerOldTransitionRows() " : "new org.apache.derby.catalog.TriggerNewTransitionRows() ");
                if (string2.equals(string3)) {
                    ((StringBuffer)object).append(string3).append(" ");
                }
                n = n4 - this.actionOffset + 1;
                this.referencedColInts = new int[n2];
                for (int j = 0; j < n2; ++j) {
                    this.referencedColInts[j] = j + 1;
                }
            }
            if (n < this.originalActionText.length()) {
                ((StringBuffer)object).append(this.originalActionText.substring(n));
            }
            string = ((StringBuffer)object).toString();
        }
        if (this.referencedColsInTriggerAction != null) {
            Arrays.sort(this.referencedColsInTriggerAction);
        }
        boolean bl = false;
        if (!string.equals(this.actionText)) {
            bl = true;
            this.actionText = string;
            this.actionNode = this.parseStatement(this.actionText, true);
        }
        return bl;
    }

    private int[] justTheRequiredColumns(int[] nArray) {
        int n = 0;
        int n2 = this.triggerTableDescriptor.getNumberOfColumns();
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] == -1) continue;
            ++n;
        }
        if (n > 0) {
            int[] nArray2 = new int[n];
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                if (nArray[i] == -1) continue;
                nArray2[n3++] = nArray[i];
            }
            return nArray2;
        }
        return null;
    }

    private void forbidActionsOnGenCols() throws StandardException {
        ColumnDescriptorList columnDescriptorList = this.triggerTableDescriptor.getGeneratedColumns();
        int n = columnDescriptorList.size();
        if (n == 0) {
            return;
        }
        CollectNodesVisitor collectNodesVisitor = new CollectNodesVisitor(ColumnReference.class);
        this.actionNode.accept(collectNodesVisitor);
        Vector vector = collectNodesVisitor.getList();
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            ColumnReference columnReference = (ColumnReference)vector.get(i);
            String string = columnReference.getColumnName();
            String string2 = columnReference.getTableName();
            for (int j = 0; j < n; ++j) {
                String string3 = columnDescriptorList.elementAt(j).getColumnName();
                if (!string3.equals(string) || !this.equals(this.newTableName, string2)) continue;
                throw StandardException.newException("42XAA", string3);
            }
        }
    }

    private boolean equals(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    private void checkInvalidTriggerReference(String string) throws StandardException {
        if (string.equals(this.oldTableName) && (this.triggerEventMask & 4) == 4) {
            throw StandardException.newException("42Y92", (Object)"INSERT", (Object)"new");
        }
        if (string.equals(this.newTableName) && (this.triggerEventMask & 2) == 2) {
            throw StandardException.newException("42Y92", (Object)"DELETE", (Object)"old");
        }
    }

    private void validateReferencesClause(DataDictionary dataDictionary) throws StandardException {
        if (this.refClause == null || this.refClause.size() == 0) {
            return;
        }
        Enumeration enumeration = this.refClause.elements();
        while (enumeration.hasMoreElements()) {
            TriggerReferencingStruct triggerReferencingStruct = (TriggerReferencingStruct)enumeration.nextElement();
            if (this.isRow && !triggerReferencingStruct.isRow) {
                throw StandardException.newException("42Y92", (Object)"ROW", (Object)"row");
            }
            if (!this.isRow && triggerReferencingStruct.isRow) {
                throw StandardException.newException("42Y92", (Object)"STATEMENT", (Object)"table");
            }
            if (triggerReferencingStruct.isNew) {
                if (this.newTableInReferencingClause) {
                    throw StandardException.newException("42Y93");
                }
                if ((this.triggerEventMask & 2) == 2) {
                    throw StandardException.newException("42Y92", (Object)"DELETE", (Object)"old");
                }
                this.newTableName = triggerReferencingStruct.identifier;
                this.newTableInReferencingClause = true;
            } else {
                if (this.oldTableInReferencingClause) {
                    throw StandardException.newException("42Y93");
                }
                if ((this.triggerEventMask & 4) == 4) {
                    throw StandardException.newException("42Y92", (Object)"INSERT", (Object)"new");
                }
                this.oldTableName = triggerReferencingStruct.identifier;
                this.oldTableInReferencingClause = true;
            }
            if (!this.isBefore || triggerReferencingStruct.isRow) continue;
            throw StandardException.newException("42Y92", (Object)"BEFORE", (Object)"row");
        }
    }

    public ConstantAction makeConstantAction() throws StandardException {
        String string = this.oldTableInReferencingClause ? this.oldTableName : null;
        String string2 = this.newTableInReferencingClause ? this.newTableName : null;
        return this.getGenericConstantActionFactory().getCreateTriggerConstantAction(this.triggerSchemaDescriptor.getSchemaName(), this.getRelativeName(), this.triggerEventMask, this.isBefore, this.isRow, this.isEnabled, this.triggerTableDescriptor, null, this.whenText, null, this.actionText, this.actionCompSchemaId == null ? this.compSchemaDescriptor.getUUID() : this.actionCompSchemaId, null, this.referencedColInts, this.referencedColsInTriggerAction, this.originalActionText, this.oldTableInReferencingClause, this.newTableInReferencingClause, string, string2);
    }

    public String toString() {
        return "";
    }
}

