/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.attribute;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.carrot2.shaded.guava.common.base.Function;
import org.carrot2.shaded.guava.common.base.Predicate;
import org.carrot2.shaded.guava.common.collect.BiMap;
import org.carrot2.shaded.guava.common.collect.Collections2;
import org.carrot2.shaded.guava.common.collect.Lists;
import org.carrot2.shaded.guava.common.primitives.Primitives;
import org.carrot2.util.attribute.AttributeMetadata;
import org.carrot2.util.attribute.BindableUtils;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Output;
import org.carrot2.util.attribute.Required;
import org.carrot2.util.attribute.constraint.Constraint;
import org.carrot2.util.attribute.constraint.ConstraintFactory;
import org.carrot2.util.attribute.constraint.ConstraintValidator;
import org.carrot2.util.attribute.constraint.ImplementingClasses;
import org.carrot2.util.attribute.constraint.ValueHintEnum;
import org.carrot2.util.attribute.constraint.ValueHintEnumConstraint;
import org.carrot2.util.attribute.constraint.ValueHintMappingUtils;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Text;

@Root(name="attribute-descriptor")
public class AttributeDescriptor {
    @Element
    public final AttributeMetadata metadata;
    @Attribute
    public final String key;
    @Attribute
    public final Class<?> type;
    public final Object defaultValue;
    public final List<Annotation> constraints;
    public final boolean inputAttribute;
    public final boolean outputAttribute;
    @Attribute(name="required")
    public final boolean requiredAttribute;
    final Field attributeField;
    @Attribute(name="field")
    private String attributeFieldString;
    @Attribute(name="declaring-class")
    private String attributeDeclaringClassString;
    @Attribute(name="default", required=false)
    private String defaultValueString;
    @ElementList(entry="annotation", required=false)
    private ArrayList<String> annotations;
    @ElementList(name="constraints", required=false)
    private ArrayList<Constraint> constraintInstances;
    @Element(name="allowed-values", required=false)
    private AllowedValues allowedValues;

    AttributeDescriptor(Field field, Object defaultValue, List<Annotation> constraints, AttributeMetadata metadata) {
        this.attributeField = field;
        this.attributeDeclaringClassString = field.getDeclaringClass().getName();
        this.key = BindableUtils.getKey(field);
        this.type = Primitives.wrap(field.getType());
        this.defaultValue = defaultValue;
        this.constraints = constraints;
        this.metadata = metadata;
        this.inputAttribute = field.getAnnotation(Input.class) != null;
        this.outputAttribute = field.getAnnotation(Output.class) != null;
        this.requiredAttribute = field.getAnnotation(Required.class) != null;
        this.prepareForSerialization();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.attributeField.getAnnotation(annotationClass);
    }

    public final boolean isValid(Object value) {
        Annotation[] constraints;
        if (this.requiredAttribute && value == null) {
            return false;
        }
        if (value == null) {
            value = this.defaultValue;
        }
        return ConstraintValidator.isMet(value, constraints = this.constraints.toArray(new Annotation[this.constraints.size()])).length == 0;
    }

    public String toString() {
        return this.key + "=" + this.type;
    }

    private void prepareForSerialization() {
        ValueHintEnum hint;
        this.attributeFieldString = this.attributeField.getName();
        if (this.inputAttribute && this.defaultValue != null) {
            if (this.defaultValue instanceof Collection && ((Collection)this.defaultValue).isEmpty()) {
                return;
            }
            this.defaultValueString = this.attributeField.getAnnotation(ImplementingClasses.class) != null ? this.defaultValue.getClass().getName() : (this.defaultValue instanceof Enum ? ((Enum)this.defaultValue).name() : this.defaultValue.toString());
        }
        Annotation[] annotationInstances = this.attributeField.getAnnotations();
        this.annotations = Lists.newArrayListWithExpectedSize((int)annotationInstances.length);
        for (Annotation annotation : annotationInstances) {
            this.annotations.add(annotation.annotationType().getSimpleName());
        }
        this.constraintInstances = Lists.newArrayList((Iterable)Collections2.filter(ConstraintFactory.createConstraints(this.attributeField.getAnnotations()), (Predicate)new Predicate<Constraint>(){

            public boolean apply(Constraint constraint) {
                return !(constraint instanceof ValueHintEnumConstraint);
            }
        }));
        if (this.constraintInstances.isEmpty()) {
            this.constraintInstances = null;
        }
        Class<Object> enumType = null;
        boolean otherValuesAllowed = false;
        if (this.type.isEnum()) {
            enumType = this.type;
            otherValuesAllowed = false;
        } else if (CharSequence.class.isAssignableFrom(this.type) && (hint = this.getAnnotation(ValueHintEnum.class)) != null) {
            enumType = hint.values();
            otherValuesAllowed = true;
        }
        if (enumType != null) {
            this.allowedValues = new AllowedValues(otherValuesAllowed);
            BiMap<String, String> valueToLabel = ValueHintMappingUtils.getValueToFriendlyName(enumType);
            for (String value : ValueHintMappingUtils.getValidValuesMap(enumType).keySet()) {
                this.allowedValues.add(value, (String)valueToLabel.get((Object)value));
            }
        }
    }

    private static class AllowedValue {
        @Attribute
        String label;
        @Text
        String value;

        public AllowedValue(String value, String label) {
            this.value = value;
            this.label = label;
        }
    }

    @Root(name="allowed-values")
    private static class AllowedValues {
        @ElementList(name="allowed-values", entry="value", required=false, inline=true)
        private ArrayList<AllowedValue> allowedValues = Lists.newArrayList();
        @Attribute(name="other-values-allowed")
        private boolean otherValuesAllowed;

        private AllowedValues(boolean otherValuesAllowed) {
            this.otherValuesAllowed = otherValuesAllowed;
        }

        void add(String value, String label) {
            this.allowedValues.add(new AllowedValue(value, label));
        }
    }

    public static final class AttributeDescriptorToKey
    implements Function<AttributeDescriptor, String> {
        public static final AttributeDescriptorToKey INSTANCE = new AttributeDescriptorToKey();

        private AttributeDescriptorToKey() {
        }

        public String apply(AttributeDescriptor d) {
            return d.key;
        }
    }
}

