/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

class WindowResultSet
extends NoPutResultSetImpl {
    private GeneratedMethod restriction = null;
    private GeneratedMethod row;
    public NoPutResultSet source = null;
    public long restrictionTime;
    private FormatableBitSet referencedColumns;
    private ExecRow allocatedRow;
    private long rownumber;

    WindowResultSet(Activation activation, NoPutResultSet noPutResultSet, GeneratedMethod generatedMethod, int n, int n2, GeneratedMethod generatedMethod2, double d, double d2) {
        super(activation, n, d, d2);
        this.restriction = generatedMethod2;
        this.source = noPutResultSet;
        this.row = generatedMethod;
        this.allocatedRow = null;
        this.rownumber = 0L;
        if (n2 != -1) {
            this.referencedColumns = (FormatableBitSet)activation.getPreparedStatement().getSavedObject(n2);
        }
        this.recordConstructorTime();
    }

    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.source.openCore();
        this.isOpen = true;
        this.rownumber = 0L;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public void reopenCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.source.reopenCore();
        this.rownumber = 0L;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public ExecRow getNextRowCore() throws StandardException {
        ExecRow execRow = null;
        ExecRow execRow2 = null;
        boolean bl = false;
        long l = 0L;
        this.beginTime = this.getCurrentTimeMillis();
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "next");
        }
        ExecRow execRow3 = null;
        do {
            if ((execRow = this.source.getNextRowCore()) != null) {
                ++this.rownumber;
                execRow3 = this.getAllocatedRow();
                this.populateFromSourceRow(execRow, execRow3);
                this.setCurrentRow(execRow3);
                DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)(this.restriction == null ? null : this.restriction.invoke(this.activation));
                this.restrictionTime += this.getElapsedMillis(l);
                boolean bl2 = bl = dataValueDescriptor == null || !dataValueDescriptor.isNull() && dataValueDescriptor.getBoolean();
                if (!bl) {
                    ++this.rowsFiltered;
                    this.clearCurrentRow();
                }
                ++this.rowsSeen;
                execRow2 = this.currentRow;
                continue;
            }
            this.clearCurrentRow();
            execRow2 = null;
        } while (execRow != null && !bl);
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execRow2;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            this.source.close();
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public void populateFromSourceRow(ExecRow execRow, ExecRow execRow2) throws StandardException {
        int n = 1;
        try {
            DataValueDescriptor[] dataValueDescriptorArray = execRow2.getRowArray();
            for (int i = 0; i < dataValueDescriptorArray.length; ++i) {
                if (this.referencedColumns != null && !this.referencedColumns.get(i)) {
                    dataValueDescriptorArray[i].setValue(this.rownumber);
                    continue;
                }
                execRow2.setColumn(i + 1, execRow.getColumn(n));
                ++n;
            }
        }
        catch (StandardException standardException) {
            throw standardException;
        }
        catch (Throwable throwable) {
            throw StandardException.unexpectedUserException(throwable);
        }
    }

    public long getTimeSpent(int n) {
        long l = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n == 0) {
            return l - this.source.getTimeSpent(1);
        }
        return l;
    }

    private ExecRow getAllocatedRow() throws StandardException {
        if (this.allocatedRow == null) {
            this.allocatedRow = (ExecRow)this.row.invoke(this.activation);
        }
        return this.allocatedRow;
    }
}

