/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.uniformsplit;

import org.apache.lucene.codecs.uniformsplit.RamUsageUtil;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.StringHelper;

public class TermBytes
implements Accountable {
    private static final long BASE_RAM_USAGE = RamUsageEstimator.shallowSizeOfInstance(TermBytes.class);
    protected int mdpLength;
    protected BytesRef term;

    public TermBytes(int mdpLength, BytesRef term) {
        this.reset(mdpLength, term);
    }

    public TermBytes reset(int mdpLength, BytesRef term) {
        assert (term.length > 0 && mdpLength > 0 || term.length == 0 && mdpLength == 0) : "Inconsistent mdpLength=" + mdpLength + ", term.length=" + term.length;
        assert (term.length == 0 || mdpLength <= term.length) : "Too large mdpLength=" + mdpLength + ", term.length=" + term.length;
        assert (term.offset == 0);
        this.mdpLength = mdpLength;
        this.term = term;
        return this;
    }

    public int getMdpLength() {
        return this.mdpLength;
    }

    public BytesRef getTerm() {
        return this.term;
    }

    public int getSuffixOffset() {
        return Math.max(this.mdpLength - 1, 0);
    }

    public int getSuffixLength() {
        return this.term.length - this.getSuffixOffset();
    }

    public static int computeMdpLength(BytesRef previousTerm, BytesRef currentTerm) {
        int mdpLength = previousTerm == null ? 1 : StringHelper.sortKeyLength((BytesRef)previousTerm, (BytesRef)currentTerm);
        return Math.min(mdpLength, currentTerm.length);
    }

    public long ramBytesUsed() {
        return BASE_RAM_USAGE + RamUsageUtil.ramBytesUsed(this.term);
    }
}

