/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.util.function.BooleanConsumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.analytics.value.BooleanValueStream;
import org.apache.solr.common.SolrException;

class BooleanStreamFilterFunction
extends BooleanValueStream.AbstractBooleanValueStream {
    private final BooleanValueStream baseExpr;
    private final BooleanValue filterExpr;
    public static final String name = "filter";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;

    public BooleanStreamFilterFunction(BooleanValueStream baseExpr, BooleanValue filterExpr) throws SolrException {
        this.baseExpr = baseExpr;
        this.filterExpr = filterExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, baseExpr, filterExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, filterExpr);
    }

    @Override
    public void streamBooleans(BooleanConsumer cons) {
        if (this.filterExpr.getBoolean() && this.filterExpr.exists()) {
            this.baseExpr.streamBooleans(cons);
        }
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

