/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.mapping.CompareDateStreamFunction;
import org.apache.solr.analytics.function.mapping.CompareDateValueFunction;
import org.apache.solr.analytics.function.mapping.CompareDoubleStreamFunction;
import org.apache.solr.analytics.function.mapping.CompareDoubleValueFunction;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValueStream;
import org.apache.solr.analytics.value.DateValue;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.common.SolrException;

public class ComparisonFunction {
    public static BooleanValueStream createComparisonFunction(String name, CompResultFunction comp, AnalyticsValueStream ... params) {
        if (params.length != 2) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The " + name + " function requires 2 paramaters, " + params.length + " found.");
        }
        AnalyticsValueStream paramA = params[0];
        AnalyticsValueStream paramB = params[1];
        if (paramA instanceof DoubleValueStream && paramB instanceof DoubleValueStream) {
            if (paramA instanceof DoubleValue) {
                if (paramB instanceof DoubleValue) {
                    return new CompareDoubleValueFunction(name, (DoubleValue)paramA, (DoubleValue)paramB, comp);
                }
                return new CompareDoubleStreamFunction(name, (DoubleValue)paramA, (DoubleValueStream)paramB, comp);
            }
            if (paramB instanceof DoubleValue) {
                return new CompareDoubleStreamFunction(name, (DoubleValue)paramB, (DoubleValueStream)paramA, ComparisonFunction.reverse(comp));
            }
        } else if (paramA instanceof DateValueStream && paramB instanceof DateValueStream) {
            if (paramA instanceof DateValue) {
                if (paramB instanceof DateValue) {
                    return new CompareDateValueFunction(name, (DateValue)paramA, (DateValue)paramB, comp);
                }
                return new CompareDateStreamFunction(name, (DateValue)paramA, (DateValueStream)paramB, comp);
            }
            if (paramB instanceof DateValue) {
                return new CompareDateStreamFunction(name, (DateValue)paramB, (DateValueStream)paramA, ComparisonFunction.reverse(comp));
            }
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The " + name + " function requires comparable (numeric or date) parameters.");
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The " + name + " function requires that at least 1 parameter be single-valued.");
    }

    private static CompResultFunction reverse(CompResultFunction original) {
        return val -> original.apply(val * -1);
    }

    @FunctionalInterface
    public static interface CompResultFunction {
        public boolean apply(int var1);
    }

    public static class LTEFunction {
        public static final String name = "lte";
        public static final ExpressionFactory.CreatorFunction creatorFunction = params -> ComparisonFunction.createComparisonFunction(name, val -> val <= 0, params);
    }

    public static class LTFunction {
        public static final String name = "lt";
        public static final ExpressionFactory.CreatorFunction creatorFunction = params -> ComparisonFunction.createComparisonFunction(name, val -> val < 0, params);
    }

    public static class GTEFunction {
        public static final String name = "gte";
        public static final ExpressionFactory.CreatorFunction creatorFunction = params -> ComparisonFunction.createComparisonFunction(name, val -> val >= 0, params);
    }

    public static class GTFunction {
        public static final String name = "gt";
        public static final ExpressionFactory.CreatorFunction creatorFunction = params -> ComparisonFunction.createComparisonFunction(name, val -> val > 0, params);
    }
}

