/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.impl;

import com.adobe.xmp.XMPConst;
import com.adobe.xmp.XMPError;
import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPMetaFactory;
import com.adobe.xmp.XMPSchemaRegistry;
import com.adobe.xmp.impl.Utils;
import com.adobe.xmp.impl.XMPMetaImpl;
import com.adobe.xmp.impl.XMPNode;
import com.adobe.xmp.impl.XMPNodeUtils;
import com.adobe.xmp.options.PropertyOptions;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ParseRDF
implements XMPError,
XMPConst {
    public static final int RDFTERM_OTHER = 0;
    public static final int RDFTERM_RDF = 1;
    public static final int RDFTERM_ID = 2;
    public static final int RDFTERM_ABOUT = 3;
    public static final int RDFTERM_PARSE_TYPE = 4;
    public static final int RDFTERM_RESOURCE = 5;
    public static final int RDFTERM_NODE_ID = 6;
    public static final int RDFTERM_DATATYPE = 7;
    public static final int RDFTERM_DESCRIPTION = 8;
    public static final int RDFTERM_LI = 9;
    public static final int RDFTERM_ABOUT_EACH = 10;
    public static final int RDFTERM_ABOUT_EACH_PREFIX = 11;
    public static final int RDFTERM_BAG_ID = 12;
    public static final int RDFTERM_FIRST_CORE = 1;
    public static final int RDFTERM_LAST_CORE = 7;
    public static final int RDFTERM_FIRST_SYNTAX = 1;
    public static final int RDFTERM_LAST_SYNTAX = 9;
    public static final int RDFTERM_FIRST_OLD = 10;
    public static final int RDFTERM_LAST_OLD = 12;
    public static final String DEFAULT_PREFIX = "_dflt";

    static XMPMetaImpl parse(Node node) throws XMPException {
        XMPMetaImpl xMPMetaImpl = new XMPMetaImpl();
        ParseRDF.rdf_RDF(xMPMetaImpl, node);
        return xMPMetaImpl;
    }

    static void rdf_RDF(XMPMetaImpl xMPMetaImpl, Node node) throws XMPException {
        if (!node.hasAttributes()) {
            throw new XMPException("Invalid attributes of rdf:RDF element", 202);
        }
        ParseRDF.rdf_NodeElementList(xMPMetaImpl, xMPMetaImpl.getRoot(), node);
    }

    private static void rdf_NodeElementList(XMPMetaImpl xMPMetaImpl, XMPNode xMPNode, Node node) throws XMPException {
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node node2 = node.getChildNodes().item(i);
            if (ParseRDF.isWhitespaceNode(node2)) continue;
            ParseRDF.rdf_NodeElement(xMPMetaImpl, xMPNode, node2, true);
        }
    }

    private static void rdf_NodeElement(XMPMetaImpl xMPMetaImpl, XMPNode xMPNode, Node node, boolean bl) throws XMPException {
        int n = ParseRDF.getRDFTermKind(node);
        if (n != 8 && n != 0) {
            throw new XMPException("Node element must be rdf:Description or typed node", 202);
        }
        if (bl && n == 0) {
            throw new XMPException("Top level typed node not allowed", 203);
        }
        ParseRDF.rdf_NodeElementAttrs(xMPMetaImpl, xMPNode, node, bl);
        ParseRDF.rdf_PropertyElementList(xMPMetaImpl, xMPNode, node, bl);
    }

    private static void rdf_NodeElementAttrs(XMPMetaImpl xMPMetaImpl, XMPNode xMPNode, Node node, boolean bl) throws XMPException {
        int n = 0;
        block4: for (int i = 0; i < node.getAttributes().getLength(); ++i) {
            Node node2 = node.getAttributes().item(i);
            if ("xmlns".equals(node2.getPrefix()) || node2.getPrefix() == null && "xmlns".equals(node2.getNodeName())) continue;
            int n2 = ParseRDF.getRDFTermKind(node2);
            switch (n2) {
                case 2: 
                case 3: 
                case 6: {
                    if (n > 0) {
                        throw new XMPException("Mutally exclusive about, ID, nodeID attributes", 202);
                    }
                    ++n;
                    if (!bl || n2 != 3) continue block4;
                    if (xMPNode.getName() != null && xMPNode.getName().length() > 0) {
                        if (xMPNode.getName().equals(node2.getNodeValue())) continue block4;
                        throw new XMPException("Mismatched top level rdf:about values", 203);
                    }
                    xMPNode.setName(node2.getNodeValue());
                    continue block4;
                }
                case 0: {
                    ParseRDF.addChildNode(xMPMetaImpl, xMPNode, node2, node2.getNodeValue(), bl);
                    continue block4;
                }
                default: {
                    throw new XMPException("Invalid nodeElement attribute", 202);
                }
            }
        }
    }

    private static void rdf_PropertyElementList(XMPMetaImpl xMPMetaImpl, XMPNode xMPNode, Node node, boolean bl) throws XMPException {
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node node2 = node.getChildNodes().item(i);
            if (ParseRDF.isWhitespaceNode(node2)) continue;
            if (node2.getNodeType() != 1) {
                throw new XMPException("Expected property element node not found", 202);
            }
            ParseRDF.rdf_PropertyElement(xMPMetaImpl, xMPNode, node2, bl);
        }
    }

    private static void rdf_PropertyElement(XMPMetaImpl xMPMetaImpl, XMPNode xMPNode, Node node, boolean bl) throws XMPException {
        int n;
        int n2 = ParseRDF.getRDFTermKind(node);
        if (!ParseRDF.isPropertyElementName(n2)) {
            throw new XMPException("Invalid property element name", 202);
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        ArrayList<String> arrayList = null;
        for (n = 0; n < namedNodeMap.getLength(); ++n) {
            Node object2 = namedNodeMap.item(n);
            if (!"xmlns".equals(object2.getPrefix()) && (object2.getPrefix() != null || !"xmlns".equals(object2.getNodeName()))) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(object2.getNodeName());
        }
        if (arrayList != null) {
            for (String string : arrayList) {
                namedNodeMap.removeNamedItem(string);
            }
        }
        if (namedNodeMap.getLength() > 3) {
            ParseRDF.rdf_EmptyPropertyElement(xMPMetaImpl, xMPNode, node, bl);
        } else {
            for (n = 0; n < namedNodeMap.getLength(); ++n) {
                Node node2 = namedNodeMap.item(n);
                String string = node2.getLocalName();
                String string2 = node2.getNamespaceURI();
                String string3 = node2.getNodeValue();
                if ("xml:lang".equals(node2.getNodeName()) && (!"ID".equals(string) || !"http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(string2))) continue;
                if ("datatype".equals(string) && "http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(string2)) {
                    ParseRDF.rdf_LiteralPropertyElement(xMPMetaImpl, xMPNode, node, bl);
                } else if (!"parseType".equals(string) || !"http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(string2)) {
                    ParseRDF.rdf_EmptyPropertyElement(xMPMetaImpl, xMPNode, node, bl);
                } else if ("Literal".equals(string3)) {
                    ParseRDF.rdf_ParseTypeLiteralPropertyElement();
                } else if ("Resource".equals(string3)) {
                    ParseRDF.rdf_ParseTypeResourcePropertyElement(xMPMetaImpl, xMPNode, node, bl);
                } else if ("Collection".equals(string3)) {
                    ParseRDF.rdf_ParseTypeCollectionPropertyElement();
                } else {
                    ParseRDF.rdf_ParseTypeOtherPropertyElement();
                }
                return;
            }
            if (node.hasChildNodes()) {
                for (n = 0; n < node.getChildNodes().getLength(); ++n) {
                    Node node3 = node.getChildNodes().item(n);
                    if (node3.getNodeType() == 3) continue;
                    ParseRDF.rdf_ResourcePropertyElement(xMPMetaImpl, xMPNode, node, bl);
                    return;
                }
                ParseRDF.rdf_LiteralPropertyElement(xMPMetaImpl, xMPNode, node, bl);
            } else {
                ParseRDF.rdf_EmptyPropertyElement(xMPMetaImpl, xMPNode, node, bl);
            }
        }
    }

    private static void rdf_ResourcePropertyElement(XMPMetaImpl xMPMetaImpl, XMPNode xMPNode, Node node, boolean bl) throws XMPException {
        if (bl && "iX:changes".equals(node.getNodeName())) {
            return;
        }
        XMPNode xMPNode2 = ParseRDF.addChildNode(xMPMetaImpl, xMPNode, node, "", bl);
        for (int i = 0; i < node.getAttributes().getLength(); ++i) {
            Node node2 = node.getAttributes().item(i);
            if ("xmlns".equals(node2.getPrefix()) || node2.getPrefix() == null && "xmlns".equals(node2.getNodeName())) continue;
            String string = node2.getLocalName();
            String string2 = node2.getNamespaceURI();
            if ("xml:lang".equals(node2.getNodeName())) {
                ParseRDF.addQualifierNode(xMPNode2, "xml:lang", node2.getNodeValue());
                continue;
            }
            if ("ID".equals(string) && "http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(string2)) continue;
            throw new XMPException("Invalid attribute for resource property element", 202);
        }
        Node node3 = null;
        boolean bl2 = false;
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            node3 = node.getChildNodes().item(i);
            if (ParseRDF.isWhitespaceNode(node3)) continue;
            if (node3.getNodeType() == 1 && !bl2) {
                boolean bl3 = "http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(node3.getNamespaceURI());
                String string = node3.getLocalName();
                if (bl3 && "Bag".equals(string)) {
                    xMPNode2.getOptions().setArray(true);
                } else if (bl3 && "Seq".equals(string)) {
                    xMPNode2.getOptions().setArray(true).setArrayOrdered(true);
                } else if (bl3 && "Alt".equals(string)) {
                    xMPNode2.getOptions().setArray(true).setArrayOrdered(true).setArrayAlternate(true);
                } else {
                    xMPNode2.getOptions().setStruct(true);
                    if (!bl3 && !"Description".equals(string)) {
                        String string3 = node3.getNamespaceURI();
                        if (string3 == null) {
                            throw new XMPException("All XML elements must be in a namespace", 203);
                        }
                        string3 = string3 + ':' + string;
                        ParseRDF.addQualifierNode(xMPNode2, "rdf:type", string3);
                    }
                }
                ParseRDF.rdf_NodeElement(xMPMetaImpl, xMPNode2, node3, false);
                if (xMPNode2.getHasValueChild()) {
                    ParseRDF.fixupQualifiedNode(xMPNode2);
                } else if (xMPNode2.getOptions().isArrayAlternate()) {
                    XMPNodeUtils.detectAltText(xMPNode2);
                }
                bl2 = true;
                continue;
            }
            if (bl2) {
                throw new XMPException("Invalid child of resource property element", 202);
            }
            throw new XMPException("Children of resource property element must be XML elements", 202);
        }
        if (!bl2) {
            throw new XMPException("Missing child of resource property element", 202);
        }
    }

    private static void rdf_LiteralPropertyElement(XMPMetaImpl xMPMetaImpl, XMPNode xMPNode, Node node, boolean bl) throws XMPException {
        Object object;
        XMPNode xMPNode2 = ParseRDF.addChildNode(xMPMetaImpl, xMPNode, node, null, bl);
        for (int i = 0; i < node.getAttributes().getLength(); ++i) {
            Node node2 = node.getAttributes().item(i);
            if ("xmlns".equals(node2.getPrefix()) || node2.getPrefix() == null && "xmlns".equals(node2.getNodeName())) continue;
            object = node2.getNamespaceURI();
            String string = node2.getLocalName();
            if ("xml:lang".equals(node2.getNodeName())) {
                ParseRDF.addQualifierNode(xMPNode2, "xml:lang", node2.getNodeValue());
                continue;
            }
            if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(object) && ("ID".equals(string) || "datatype".equals(string))) continue;
            throw new XMPException("Invalid attribute for literal property element", 202);
        }
        String string = "";
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            object = node.getChildNodes().item(i);
            if (object.getNodeType() != 3) {
                throw new XMPException("Invalid child of literal property element", 202);
            }
            string = string + object.getNodeValue();
        }
        xMPNode2.setValue(string);
    }

    private static void rdf_ParseTypeLiteralPropertyElement() throws XMPException {
        throw new XMPException("ParseTypeLiteral property element not allowed", 203);
    }

    private static void rdf_ParseTypeResourcePropertyElement(XMPMetaImpl xMPMetaImpl, XMPNode xMPNode, Node node, boolean bl) throws XMPException {
        XMPNode xMPNode2 = ParseRDF.addChildNode(xMPMetaImpl, xMPNode, node, "", bl);
        xMPNode2.getOptions().setStruct(true);
        for (int i = 0; i < node.getAttributes().getLength(); ++i) {
            Node node2 = node.getAttributes().item(i);
            if ("xmlns".equals(node2.getPrefix()) || node2.getPrefix() == null && "xmlns".equals(node2.getNodeName())) continue;
            String string = node2.getLocalName();
            String string2 = node2.getNamespaceURI();
            if ("xml:lang".equals(node2.getNodeName())) {
                ParseRDF.addQualifierNode(xMPNode2, "xml:lang", node2.getNodeValue());
                continue;
            }
            if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(string2) && ("ID".equals(string) || "parseType".equals(string))) continue;
            throw new XMPException("Invalid attribute for ParseTypeResource property element", 202);
        }
        ParseRDF.rdf_PropertyElementList(xMPMetaImpl, xMPNode2, node, false);
        if (xMPNode2.getHasValueChild()) {
            ParseRDF.fixupQualifiedNode(xMPNode2);
        }
    }

    private static void rdf_ParseTypeCollectionPropertyElement() throws XMPException {
        throw new XMPException("ParseTypeCollection property element not allowed", 203);
    }

    private static void rdf_ParseTypeOtherPropertyElement() throws XMPException {
        throw new XMPException("ParseTypeOther property element not allowed", 203);
    }

    private static void rdf_EmptyPropertyElement(XMPMetaImpl xMPMetaImpl, XMPNode xMPNode, Node node, boolean bl) throws XMPException {
        int n;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        Node node2 = null;
        if (node.hasChildNodes()) {
            throw new XMPException("Nested content not allowed with rdf:resource or property attributes", 202);
        }
        block11: for (int i = 0; i < node.getAttributes().getLength(); ++i) {
            Node node3 = node.getAttributes().item(i);
            if ("xmlns".equals(node3.getPrefix()) || node3.getPrefix() == null && "xmlns".equals(node3.getNodeName())) continue;
            n = ParseRDF.getRDFTermKind(node3);
            switch (n) {
                case 2: {
                    continue block11;
                }
                case 5: {
                    if (bl4) {
                        throw new XMPException("Empty property element can't have both rdf:resource and rdf:nodeID", 202);
                    }
                    if (bl5) {
                        throw new XMPException("Empty property element can't have both rdf:value and rdf:resource", 203);
                    }
                    bl3 = true;
                    if (bl5) continue block11;
                    node2 = node3;
                    continue block11;
                }
                case 6: {
                    if (bl3) {
                        throw new XMPException("Empty property element can't have both rdf:resource and rdf:nodeID", 202);
                    }
                    bl4 = true;
                    continue block11;
                }
                case 0: {
                    if ("value".equals(node3.getLocalName()) && "http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(node3.getNamespaceURI())) {
                        if (bl3) {
                            throw new XMPException("Empty property element can't have both rdf:value and rdf:resource", 203);
                        }
                        bl5 = true;
                        node2 = node3;
                        continue block11;
                    }
                    if ("xml:lang".equals(node3.getNodeName())) continue block11;
                    bl2 = true;
                    continue block11;
                }
                default: {
                    throw new XMPException("Unrecognized attribute of empty property element", 202);
                }
            }
        }
        XMPNode xMPNode2 = ParseRDF.addChildNode(xMPMetaImpl, xMPNode, node, "", bl);
        boolean bl6 = false;
        if (bl5 || bl3) {
            xMPNode2.setValue(node2 != null ? node2.getNodeValue() : "");
            if (!bl5) {
                xMPNode2.getOptions().setURI(true);
            }
        } else if (bl2) {
            xMPNode2.getOptions().setStruct(true);
            bl6 = true;
        }
        block12: for (n = 0; n < node.getAttributes().getLength(); ++n) {
            Node node4 = node.getAttributes().item(n);
            if (node4 == node2 || "xmlns".equals(node4.getPrefix()) || node4.getPrefix() == null && "xmlns".equals(node4.getNodeName())) continue;
            int n2 = ParseRDF.getRDFTermKind(node4);
            switch (n2) {
                case 2: 
                case 6: {
                    continue block12;
                }
                case 5: {
                    ParseRDF.addQualifierNode(xMPNode2, "rdf:resource", node4.getNodeValue());
                    continue block12;
                }
                case 0: {
                    if (!bl6) {
                        ParseRDF.addQualifierNode(xMPNode2, node4.getNodeName(), node4.getNodeValue());
                        continue block12;
                    }
                    if ("xml:lang".equals(node4.getNodeName())) {
                        ParseRDF.addQualifierNode(xMPNode2, "xml:lang", node4.getNodeValue());
                        continue block12;
                    }
                    ParseRDF.addChildNode(xMPMetaImpl, xMPNode2, node4, node4.getNodeValue(), false);
                    continue block12;
                }
                default: {
                    throw new XMPException("Unrecognized attribute of empty property element", 202);
                }
            }
        }
    }

    private static XMPNode addChildNode(XMPMetaImpl xMPMetaImpl, XMPNode xMPNode, Node node, String string, boolean bl) throws XMPException {
        Object object;
        XMPSchemaRegistry xMPSchemaRegistry = XMPMetaFactory.getSchemaRegistry();
        String string2 = node.getNamespaceURI();
        if (string2 != null) {
            if ("http://purl.org/dc/1.1/".equals(string2)) {
                string2 = "http://purl.org/dc/elements/1.1/";
            }
            if ((object = xMPSchemaRegistry.getNamespacePrefix(string2)) == null) {
                object = node.getPrefix() != null ? node.getPrefix() : DEFAULT_PREFIX;
                object = xMPSchemaRegistry.registerNamespace(string2, (String)object);
            }
        } else {
            throw new XMPException("XML namespace required for all elements and attributes", 202);
        }
        String string3 = (String)object + node.getLocalName();
        object = new PropertyOptions();
        boolean bl2 = false;
        if (bl) {
            XMPNode xMPNode2 = XMPNodeUtils.findSchemaNode(xMPMetaImpl.getRoot(), string2, DEFAULT_PREFIX, true);
            xMPNode2.setImplicit(false);
            xMPNode = xMPNode2;
            if (xMPSchemaRegistry.findAlias(string3) != null) {
                bl2 = true;
                xMPMetaImpl.getRoot().setHasAliases(true);
                xMPNode2.setHasAliases(true);
            }
        }
        boolean bl3 = "rdf:li".equals(string3);
        boolean bl4 = "rdf:value".equals(string3);
        XMPNode xMPNode3 = new XMPNode(string3, string, (PropertyOptions)object);
        xMPNode3.setAlias(bl2);
        if (!bl4) {
            xMPNode.addChild(xMPNode3);
        } else {
            xMPNode.addChild(1, xMPNode3);
        }
        if (bl4) {
            if (bl || !xMPNode.getOptions().isStruct()) {
                throw new XMPException("Misplaced rdf:value element", 202);
            }
            xMPNode.setHasValueChild(true);
        }
        if (bl3) {
            if (!xMPNode.getOptions().isArray()) {
                throw new XMPException("Misplaced rdf:li element", 202);
            }
            xMPNode3.setName("[]");
        }
        return xMPNode3;
    }

    private static XMPNode addQualifierNode(XMPNode xMPNode, String string, String string2) throws XMPException {
        boolean bl = "xml:lang".equals(string);
        XMPNode xMPNode2 = null;
        xMPNode2 = new XMPNode(string, bl ? Utils.normalizeLangValue(string2) : string2, null);
        xMPNode.addQualifier(xMPNode2);
        return xMPNode2;
    }

    private static void fixupQualifiedNode(XMPNode xMPNode) throws XMPException {
        XMPNode xMPNode2;
        int n;
        assert (xMPNode.getOptions().isStruct() && xMPNode.hasChildren());
        XMPNode xMPNode3 = xMPNode.getChild(1);
        assert ("rdf:value".equals(xMPNode3.getName()));
        if (xMPNode3.getOptions().getHasLanguage()) {
            if (xMPNode.getOptions().getHasLanguage()) {
                throw new XMPException("Redundant xml:lang for rdf:value element", 203);
            }
            XMPNode xMPNode4 = xMPNode3.getQualifier(1);
            xMPNode3.removeQualifier(xMPNode4);
            xMPNode.addQualifier(xMPNode4);
        }
        for (n = 1; n <= xMPNode3.getQualifierLength(); ++n) {
            xMPNode2 = xMPNode3.getQualifier(n);
            xMPNode.addQualifier(xMPNode2);
        }
        for (n = 2; n <= xMPNode.getChildrenLength(); ++n) {
            xMPNode2 = xMPNode.getChild(n);
            xMPNode.addQualifier(xMPNode2);
        }
        assert (xMPNode.getOptions().isStruct() || xMPNode.getHasValueChild());
        xMPNode.setHasValueChild(false);
        xMPNode.getOptions().setStruct(false);
        xMPNode.getOptions().mergeWith(xMPNode3.getOptions());
        xMPNode.setValue(xMPNode3.getValue());
        xMPNode.removeChildren();
        Iterator iterator = xMPNode3.iterateChildren();
        while (iterator.hasNext()) {
            xMPNode2 = (XMPNode)iterator.next();
            xMPNode.addChild(xMPNode2);
        }
    }

    private static boolean isWhitespaceNode(Node node) {
        if (node.getNodeType() != 3) {
            return false;
        }
        String string = node.getNodeValue();
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isPropertyElementName(int n) {
        if (n == 8 || ParseRDF.isOldTerm(n)) {
            return false;
        }
        return !ParseRDF.isCoreSyntaxTerm(n);
    }

    private static boolean isOldTerm(int n) {
        return 10 <= n && n <= 12;
    }

    private static boolean isCoreSyntaxTerm(int n) {
        return 1 <= n && n <= 7;
    }

    private static int getRDFTermKind(Node node) {
        String string = node.getLocalName();
        String string2 = node.getNamespaceURI();
        if (string2 == null && ("about".equals(string) || "ID".equals(string)) && node instanceof Attr && "http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(((Attr)node).getOwnerElement().getNamespaceURI())) {
            string2 = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
        }
        if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(string2)) {
            if ("li".equals(string)) {
                return 9;
            }
            if ("parseType".equals(string)) {
                return 4;
            }
            if ("Description".equals(string)) {
                return 8;
            }
            if ("about".equals(string)) {
                return 3;
            }
            if ("resource".equals(string)) {
                return 5;
            }
            if ("RDF".equals(string)) {
                return 1;
            }
            if ("ID".equals(string)) {
                return 2;
            }
            if ("nodeID".equals(string)) {
                return 6;
            }
            if ("datatype".equals(string)) {
                return 7;
            }
            if ("aboutEach".equals(string)) {
                return 10;
            }
            if ("aboutEachPrefix".equals(string)) {
                return 11;
            }
            if ("bagID".equals(string)) {
                return 12;
            }
        }
        return 0;
    }
}

