/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.image;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.poi.util.IOUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.image.ICNSType;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ICNSParser
extends AbstractParser {
    private static final long serialVersionUID = 922010233654248327L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.image((String)"icns"));
    public static final String ICNS_MIME_TYPE = "image/icns";

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        int icon_length;
        byte[] header = new byte[4];
        IOUtils.readFully((InputStream)stream, (byte[])header, (int)0, (int)4);
        if (header[0] != 105 || header[1] != 99 || header[2] != 110 || header[3] != 115) {
            throw new TikaException("ICNS magic signature invalid");
        }
        IOUtils.readFully((InputStream)stream, (byte[])header, (int)0, (int)4);
        int image_length = ByteBuffer.wrap(header).getInt();
        byte[] full_file = new byte[image_length];
        IOUtils.readFully((InputStream)stream, (byte[])full_file);
        ArrayList<ICNSType> icons = new ArrayList<ICNSType>();
        ArrayList<ICNSType> icon_masks = new ArrayList<ICNSType>();
        byte[] tempByteArray = new byte[4];
        for (int offset = 0; offset < image_length - 8; offset += icon_length) {
            tempByteArray[0] = full_file[offset];
            tempByteArray[1] = full_file[offset + 1];
            tempByteArray[2] = full_file[offset + 2];
            tempByteArray[3] = full_file[offset + 3];
            ICNSType icnstype = ICNSType.findIconType(tempByteArray);
            if (icnstype == null) {
                offset = image_length - 8;
            } else if (icnstype.hasMask()) {
                icon_masks.add(ICNSType.findIconType(tempByteArray));
            } else {
                icons.add(ICNSType.findIconType(tempByteArray));
            }
            tempByteArray[0] = full_file[offset + 4];
            tempByteArray[1] = full_file[offset + 5];
            tempByteArray[2] = full_file[offset + 6];
            tempByteArray[3] = full_file[offset + 7];
            icon_length = ByteBuffer.wrap(tempByteArray).getInt();
        }
        String icon_details = "";
        String iconmask_details = "";
        for (ICNSType icon : icons) {
            String bitsPerPixel = icon.getBitsPerPixel() != 0 ? icon.getBitsPerPixel() + " bpp" : "JPEG 2000 or PNG format";
            String dimensions = !icon.hasRetinaDisplay() ? icon.getHeight() + "x" + icon.getWidth() : icon.getHeight() + "x" + icon.getWidth() + "@2X";
            icon_details = icon_details + ", " + dimensions + " (" + bitsPerPixel + ")";
        }
        for (ICNSType icon : icon_masks) {
            iconmask_details = iconmask_details + ", " + icon.getHeight() + "x" + icon.getWidth() + " (" + icon.getBitsPerPixel() + " bpp)";
        }
        metadata.set("Content-Type", ICNS_MIME_TYPE);
        if (!icon_details.equals("")) {
            metadata.set("Icon count", String.valueOf(icons.size()));
            icon_details = icon_details.substring(2);
            metadata.set("Icon details", icon_details);
        }
        if (!iconmask_details.equals("")) {
            metadata.set("Masked icon count", String.valueOf(icon_masks.size()));
            iconmask_details = iconmask_details.substring(2);
            metadata.set("Masked icon details", iconmask_details);
        }
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        xhtml.endDocument();
    }
}

