/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import com.cybozu.labs.langdetect.Detector;
import com.cybozu.labs.langdetect.DetectorFactory;
import com.cybozu.labs.langdetect.LangDetectException;
import com.cybozu.labs.langdetect.Language;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.DetectedLanguage;
import org.apache.solr.update.processor.LanguageIdentifierUpdateProcessor;
import org.apache.solr.update.processor.SolrInputDocumentReader;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LangDetectLanguageIdentifierUpdateProcessor
extends LanguageIdentifierUpdateProcessor {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public LangDetectLanguageIdentifierUpdateProcessor(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        super(req, rsp, next);
    }

    @Override
    protected List<DetectedLanguage> detectLanguage(Reader solrDocReader) {
        try {
            Detector detector = DetectorFactory.create();
            detector.setMaxTextLength(this.maxTotalChars);
            if (solrDocReader instanceof SolrInputDocumentReader) {
                ((SolrInputDocumentReader)solrDocReader).setEodReturnValue(0);
            }
            detector.append(solrDocReader);
            ArrayList langlist = detector.getProbabilities();
            ArrayList<DetectedLanguage> solrLangList = new ArrayList<DetectedLanguage>();
            for (Language l : langlist) {
                solrLangList.add(new DetectedLanguage(l.lang, l.prob));
            }
            return solrLangList;
        }
        catch (LangDetectException e) {
            log.debug("Could not determine language, returning empty list: ", (Throwable)e);
            return Collections.emptyList();
        }
        catch (IOException e) {
            log.warn("Could not determine language.", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

