/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.mp4.boxes;

import com.drew.lang.SequentialReader;
import com.drew.metadata.mp4.Mp4HandlerFactory;
import com.drew.metadata.mp4.boxes.Box;
import com.drew.metadata.mp4.boxes.FullBox;
import java.io.IOException;

public class MediaHeaderBox
extends FullBox {
    long creationTime;
    long modificationTime;
    long timescale;
    long duration;
    String language;

    public MediaHeaderBox(SequentialReader reader, Box box) throws IOException {
        super(reader, box);
        if (this.version == 1) {
            this.creationTime = reader.getInt64();
            this.modificationTime = reader.getInt64();
            this.timescale = reader.getInt32();
            this.duration = reader.getInt64();
        } else {
            this.creationTime = reader.getUInt32();
            this.modificationTime = reader.getUInt32();
            this.timescale = reader.getUInt32();
            this.duration = reader.getUInt32();
        }
        short languageBits = reader.getInt16();
        this.language = new String(new char[]{(char)(((languageBits & 0x7C00) >> 10) + 96), (char)(((languageBits & 0x3E0) >> 5) + 96), (char)((languageBits & 0x1F) + 96)});
        Mp4HandlerFactory.HANDLER_PARAM_CREATION_TIME = this.creationTime;
        Mp4HandlerFactory.HANDLER_PARAM_MODIFICATION_TIME = this.modificationTime;
        Mp4HandlerFactory.HANDLER_PARAM_TIME_SCALE = this.timescale;
        Mp4HandlerFactory.HANDLER_PARAM_DURATION = this.duration;
        Mp4HandlerFactory.HANDLER_PARAM_LANGUAGE = this.language;
    }
}

