/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rfb.ConnParams;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.ModifiablePixelBuffer;
import com.tigervnc.rfb.PixelFormat;
import com.tigervnc.rfb.Point;
import com.tigervnc.rfb.Rect;
import com.tigervnc.rfb.ScreenSet;

public abstract class CMsgHandler {
    public ConnParams cp = new ConnParams();
    static LogWriter vlog = new LogWriter("CMsgHandler");

    public void setDesktopSize(int n, int n2) {
        this.cp.width = n;
        this.cp.height = n2;
    }

    public void setExtendedDesktopSize(int n, int n2, int n3, int n4, ScreenSet screenSet) {
        this.cp.supportsSetDesktopSize = true;
        if (n == 1 && n2 != 0) {
            return;
        }
        if (!screenSet.validate(n3, n4)) {
            vlog.error("Server sent us an invalid screen layout", new Object[0]);
        }
        this.cp.width = n3;
        this.cp.height = n4;
        this.cp.screenLayout = screenSet;
    }

    public void setPixelFormat(PixelFormat pixelFormat) {
        this.cp.setPF(pixelFormat);
    }

    public void setName(String string) {
        this.cp.setName(string);
    }

    public void fence(int n, int n2, byte[] byArray) {
        this.cp.supportsFence = true;
    }

    public void endOfContinuousUpdates() {
        this.cp.supportsContinuousUpdates = true;
    }

    public abstract void clientRedirect(int var1, String var2, String var3);

    public abstract void setCursor(int var1, int var2, Point var3, byte[] var4);

    public abstract void serverInit();

    public abstract void readAndDecodeRect(Rect var1, int var2, ModifiablePixelBuffer var3);

    public void framebufferUpdateStart() {
    }

    public void framebufferUpdateEnd() {
    }

    public abstract void dataRect(Rect var1, int var2);

    public abstract void setColourMapEntries(int var1, int var2, int[] var3);

    public abstract void bell();

    public abstract void serverCutText(String var1, int var2);
}

