/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rdr.OutStream;
import com.tigervnc.rfb.ConnParams;
import com.tigervnc.rfb.Decoder;
import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.PixelFormat;
import com.tigervnc.rfb.Point;
import com.tigervnc.rfb.Rect;
import com.tigervnc.rfb.Screen;
import com.tigervnc.rfb.ScreenSet;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class CMsgWriter {
    ConnParams cp;
    OutStream os;

    protected CMsgWriter(ConnParams connParams, OutStream outStream) {
        this.cp = connParams;
        this.os = outStream;
    }

    public synchronized void writeClientInit(boolean bl) {
        this.os.writeU8(bl ? 1 : 0);
        this.endMsg();
    }

    public synchronized void writeSetPixelFormat(PixelFormat pixelFormat) {
        this.startMsg(0);
        this.os.pad(3);
        pixelFormat.write(this.os);
        this.endMsg();
    }

    public synchronized void writeSetEncodings(int n, int[] nArray) {
        this.startMsg(2);
        this.os.skip(1);
        this.os.writeU16(n);
        for (int i = 0; i < n; ++i) {
            this.os.writeU32(nArray[i]);
        }
        this.endMsg();
    }

    public synchronized void writeSetEncodings(int n, boolean bl) {
        int n2 = 0;
        int[] nArray = new int[258];
        if (this.cp.supportsLocalCursor) {
            if (this.cp.supportsLocalCursorWithAlpha) {
                nArray[n2++] = -314;
            }
            nArray[n2++] = -239;
            nArray[n2++] = -240;
        }
        if (this.cp.supportsDesktopResize) {
            nArray[n2++] = -223;
        }
        if (this.cp.supportsExtendedDesktopSize) {
            nArray[n2++] = -308;
        }
        if (this.cp.supportsDesktopRename) {
            nArray[n2++] = -307;
        }
        if (this.cp.supportsClientRedirect) {
            nArray[n2++] = -311;
        }
        nArray[n2++] = -224;
        nArray[n2++] = -313;
        nArray[n2++] = -312;
        if (Decoder.supported(n)) {
            nArray[n2++] = n;
        }
        if (bl) {
            nArray[n2++] = 1;
        }
        if (n != 7 && Decoder.supported(7)) {
            nArray[n2++] = 7;
        }
        if (n != 16 && Decoder.supported(16)) {
            nArray[n2++] = 16;
        }
        if (n != 5 && Decoder.supported(5)) {
            nArray[n2++] = 5;
        }
        block3: for (int i = 255; i >= 0; --i) {
            switch (i) {
                case 1: 
                case 5: 
                case 7: 
                case 16: {
                    continue block3;
                }
                default: {
                    if (i == n || !Decoder.supported(i)) continue block3;
                    nArray[n2++] = i;
                }
            }
        }
        if (this.cp.compressLevel >= 0 && this.cp.compressLevel <= 9) {
            nArray[n2++] = -256 + this.cp.compressLevel;
        }
        if (this.cp.qualityLevel >= 0 && this.cp.qualityLevel <= 9) {
            nArray[n2++] = -32 + this.cp.qualityLevel;
        }
        this.writeSetEncodings(n2, nArray);
    }

    public synchronized void writeSetDesktopSize(int n, int n2, ScreenSet screenSet) {
        if (!this.cp.supportsSetDesktopSize) {
            throw new Exception("Server does not support SetDesktopSize");
        }
        this.startMsg(251);
        this.os.pad(1);
        this.os.writeU16(n);
        this.os.writeU16(n2);
        this.os.writeU8(screenSet.num_screens());
        this.os.pad(1);
        for (Screen screen : screenSet.screens) {
            this.os.writeU32(screen.id);
            this.os.writeU16(screen.dimensions.tl.x);
            this.os.writeU16(screen.dimensions.tl.y);
            this.os.writeU16(screen.dimensions.width());
            this.os.writeU16(screen.dimensions.height());
            this.os.writeU32(screen.flags);
        }
        this.endMsg();
    }

    public synchronized void writeFramebufferUpdateRequest(Rect rect, boolean bl) {
        this.startMsg(3);
        this.os.writeU8(bl ? 1 : 0);
        this.os.writeU16(rect.tl.x);
        this.os.writeU16(rect.tl.y);
        this.os.writeU16(rect.width());
        this.os.writeU16(rect.height());
        this.endMsg();
    }

    public synchronized void writeEnableContinuousUpdates(boolean bl, int n, int n2, int n3, int n4) {
        if (!this.cp.supportsContinuousUpdates) {
            throw new Exception("Server does not support continuous updates");
        }
        this.startMsg(150);
        this.os.writeU8(bl ? 1 : 0);
        this.os.writeU16(n);
        this.os.writeU16(n2);
        this.os.writeU16(n3);
        this.os.writeU16(n4);
        this.endMsg();
    }

    public synchronized void writeFence(int n, int n2, byte[] byArray) {
        if (!this.cp.supportsFence) {
            throw new Exception("Server does not support fences");
        }
        if (n2 > 64) {
            throw new Exception("Too large fence payload");
        }
        if ((n & 0x7FFFFFF8) != 0) {
            throw new Exception("Unknown fence flags");
        }
        this.startMsg(248);
        this.os.pad(3);
        this.os.writeU32(n);
        this.os.writeU8(n2);
        this.os.writeBytes(byArray, 0, n2);
        this.endMsg();
    }

    public synchronized void keyEvent(int n, boolean bl) {
        this.startMsg(4);
        this.os.writeU8(bl ? 1 : 0);
        this.os.pad(2);
        this.os.writeU32(n);
        this.endMsg();
    }

    public synchronized void pointerEvent(Point point, int n) {
        Point point2 = new Point(point.x, point.y);
        if (point2.x < 0) {
            point2.x = 0;
        }
        if (point2.y < 0) {
            point2.y = 0;
        }
        if (point2.x >= this.cp.width) {
            point2.x = this.cp.width - 1;
        }
        if (point2.y >= this.cp.height) {
            point2.y = this.cp.height - 1;
        }
        this.startMsg(5);
        this.os.writeU8(n);
        this.os.writeU16(point2.x);
        this.os.writeU16(point2.y);
        this.endMsg();
    }

    public synchronized void writeClientCutText(String string, int n) {
        this.startMsg(6);
        this.os.pad(3);
        this.os.writeU32(n);
        Charset charset = Charset.forName("ISO-8859-1");
        ByteBuffer byteBuffer = charset.encode(string);
        this.os.writeBytes(byteBuffer.array(), 0, n);
        this.endMsg();
    }

    public synchronized void startMsg(int n) {
        this.os.writeU8(n);
    }

    public synchronized void endMsg() {
        this.os.flush();
    }
}

