/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.hsqldb.jdbc.JDBCBlobFile;
import org.hsqldb.jdbc.JDBCClob;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.FrameworkLogger;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.InOutUtil;
import org.hsqldb.lib.Iterator;

public class JDBCClobFile
implements Clob {
    private static final FrameworkLogger LOG = FrameworkLogger.getLog(JDBCClobFile.class);
    public static final String TEMP_FILE_PREFIX = "hsql_jdbc_clob_file_";
    public static final String TEMP_FILE_SUFFIX = ".tmp";
    private final File m_file;
    private boolean m_closed;
    private boolean m_deleteOnFree;
    private String m_encoding;
    private Charset m_charset;
    private CharsetEncoder m_encoder;
    private boolean m_fixedWidthCharset;
    private int m_maxCharWidth;
    private HsqlList m_streams = new HsqlArrayList();

    @Override
    public long length() throws SQLException {
        long l;
        this.checkClosed();
        if (this.m_fixedWidthCharset) {
            return this.m_file.length() / (long)this.m_maxCharWidth;
        }
        ReaderAdapter readerAdapter = null;
        try {
            long l2;
            readerAdapter = new ReaderAdapter(this.m_file, 0L, Long.MAX_VALUE);
            l = l2 = readerAdapter.skip(Long.MAX_VALUE);
        }
        catch (IOException iOException) {
            try {
                throw JDBCUtil.sqlException(iOException);
            }
            catch (Throwable throwable) {
                JDBCClobFile.closeSafely(readerAdapter);
                throw throwable;
            }
        }
        JDBCClobFile.closeSafely(readerAdapter);
        return l;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getSubString(long l, int n) throws SQLException {
        String string;
        Reader reader = null;
        int n2 = Math.min(8192, n);
        try {
            reader = this.getCharacterStream(l, n);
            CharArrayWriter charArrayWriter = new CharArrayWriter(n2);
            InOutUtil.copy(reader, charArrayWriter, (long)n);
            string = charArrayWriter.toString();
        }
        catch (SQLException sQLException) {
            try {
                throw sQLException;
                catch (IOException iOException) {
                    throw JDBCUtil.sqlException(iOException);
                }
            }
            catch (Throwable throwable) {
                JDBCClobFile.closeSafely(reader);
                throw throwable;
            }
        }
        JDBCClobFile.closeSafely(reader);
        return string;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return this.getCharacterStream(1L, Long.MAX_VALUE);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        JDBCBlobFile.InputStreamAdapter inputStreamAdapter;
        try {
            inputStreamAdapter = new JDBCBlobFile.InputStreamAdapter(this.m_file, 0L, Long.MAX_VALUE){
                private boolean closed;

                @Override
                public synchronized void close() throws IOException {
                    if (this.closed) {
                        return;
                    }
                    this.closed = true;
                    try {
                        super.close();
                    }
                    finally {
                        JDBCClobFile.this.m_streams.remove(this);
                    }
                }
            };
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw JDBCUtil.sqlException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw JDBCUtil.sqlException(iOException);
        }
        catch (SecurityException securityException) {
            throw JDBCUtil.sqlException(securityException);
        }
        catch (NullPointerException nullPointerException) {
            throw JDBCUtil.sqlException(nullPointerException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw JDBCUtil.sqlException(illegalArgumentException);
        }
        this.m_streams.add(inputStreamAdapter);
        return inputStreamAdapter;
    }

    public long position(char[] cArray, long l) throws SQLException {
        if (l < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + l);
        }
        if (cArray == null || cArray.length == 0) {
            return -1L;
        }
        long l2 = this.length();
        if (l > l2 || (long)cArray.length > l2 || l > l2 - (long)cArray.length) {
            return -1L;
        }
        return this.position0(new String(cArray), l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long position0(String string, long l) throws SQLException {
        Scanner scanner;
        ReaderAdapter readerAdapter;
        Pattern pattern;
        block13: {
            try {
                pattern = Pattern.compile(Pattern.quote(string));
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw JDBCUtil.sqlException(patternSyntaxException);
            }
            readerAdapter = null;
            scanner = null;
            boolean bl = false;
            try {
                readerAdapter = new ReaderAdapter(this.m_file, l - 1L, this.m_file.length());
                scanner = new Scanner(readerAdapter);
                bl = true;
                if (bl) break block13;
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    throw JDBCUtil.sqlException(fileNotFoundException);
                    catch (IOException iOException) {
                        throw JDBCUtil.sqlException(iOException);
                    }
                    catch (SecurityException securityException) {
                        throw JDBCUtil.sqlException(securityException);
                    }
                    catch (NullPointerException nullPointerException) {
                        throw JDBCUtil.sqlException(nullPointerException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw JDBCUtil.sqlException(illegalArgumentException);
                    }
                }
                catch (Throwable throwable) {
                    if (bl) throw throwable;
                    JDBCClobFile.closeSafely(scanner);
                    JDBCClobFile.closeSafely(readerAdapter);
                    throw throwable;
                }
            }
            JDBCClobFile.closeSafely(scanner);
            JDBCClobFile.closeSafely(readerAdapter);
        }
        int n = -1;
        try {
            if (!scanner.hasNext()) return n;
            boolean bl = null != scanner.findWithinHorizon(pattern, 0);
            if (!bl) return n;
            MatchResult matchResult = scanner.match();
            n = matchResult.start() + 1;
            return n;
        }
        finally {
            JDBCClobFile.closeSafely(scanner);
            JDBCClobFile.closeSafely(readerAdapter);
        }
    }

    @Override
    public long position(String string, long l) throws SQLException {
        if (l < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + l);
        }
        if (string == null || string.length() == 0) {
            return -1L;
        }
        long l2 = this.length();
        int n = string.length();
        if (l > l2 || (long)n > l2 || l > l2 - (long)n) {
            return -1L;
        }
        return this.position0(string, l);
    }

    @Override
    public long position(Clob clob, long l) throws SQLException {
        String string;
        if (l < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + l);
        }
        long l2 = clob == null ? 0L : clob.length();
        if (l2 == 0L) {
            return -1L;
        }
        if (l2 > Integer.MAX_VALUE) {
            throw JDBCUtil.outOfRangeArgument("pattern.length(): " + l2);
        }
        long l3 = this.length();
        if (l > l3 || l2 > l3 || l > l3 - l2) {
            return -1L;
        }
        if (clob instanceof JDBCClob) {
            string = ((JDBCClob)clob).getData();
        } else {
            Reader reader = null;
            StringWriter stringWriter = new StringWriter();
            try {
                reader = clob.getCharacterStream();
                InOutUtil.copy(reader, stringWriter, l2);
            }
            catch (IOException iOException) {
                throw JDBCUtil.sqlException(iOException);
            }
            catch (Throwable throwable) {
                throw JDBCUtil.sqlException(throwable);
            }
            finally {
                JDBCClobFile.closeSafely(reader);
            }
            string = stringWriter.toString();
        }
        return this.position0(string, l);
    }

    @Override
    public int setString(long l, String string) throws SQLException {
        return this.setString(l, string, 0, string == null ? 0 : string.length());
    }

    @Override
    public int setString(long l, String string, int n, int n2) throws SQLException {
        this.checkClosed();
        if (string == null) {
            throw JDBCUtil.nullArgument("str");
        }
        int n3 = string.length();
        if (n < 0 || n > n3) {
            throw JDBCUtil.outOfRangeArgument("offset: " + n);
        }
        if (n2 < 0 || n2 > n3 - n) {
            throw JDBCUtil.outOfRangeArgument("len: " + n2);
        }
        if (l < 1L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l);
        }
        long l2 = this.length();
        if (l > l2 + 1L) {
            this.fillSpace(l2 + 1L, l);
        }
        Writer writer = null;
        try {
            writer = this.setCharacterStream(l);
            writer.write(string, n, n2);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (IOException iOException) {
            throw JDBCUtil.sqlException(iOException);
        }
        catch (Throwable throwable) {
            throw JDBCUtil.sqlException(throwable);
        }
        finally {
            JDBCClobFile.closeSafely(writer);
        }
        return n2;
    }

    private void fillSpace(long l, long l2) throws SQLException {
        Writer writer = null;
        try {
            writer = this.setCharacterStream(l);
            for (long i = l2 - l; i >= 0L; --i) {
                writer.append(' ');
            }
        }
        catch (IOException iOException) {
            throw JDBCUtil.sqlException(iOException);
        }
        catch (Throwable throwable) {
            throw JDBCUtil.sqlException(throwable);
        }
        finally {
            JDBCClobFile.closeSafely(writer);
        }
    }

    @Override
    public OutputStream setAsciiStream(long l) throws SQLException {
        JDBCBlobFile.OutputStreamAdapter outputStreamAdapter;
        if (l < 1L) {
            throw JDBCUtil.invalidArgument("pos: " + l);
        }
        this.checkClosed();
        this.createFile();
        long l2 = this.length();
        if (l > l2 + 1L) {
            this.fillSpace(l2 + 1L, l);
        }
        try {
            outputStreamAdapter = new JDBCBlobFile.OutputStreamAdapter(this.m_file, l - 1L){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        JDBCClobFile.this.m_streams.remove(this);
                    }
                }
            };
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw JDBCUtil.sqlException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw JDBCUtil.sqlException(iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw JDBCUtil.sqlException(illegalArgumentException);
        }
        catch (NullPointerException nullPointerException) {
            throw JDBCUtil.sqlException(nullPointerException);
        }
        catch (SecurityException securityException) {
            throw JDBCUtil.sqlException(securityException);
        }
        this.m_streams.add(outputStreamAdapter);
        return outputStreamAdapter;
    }

    @Override
    public Writer setCharacterStream(long l) throws SQLException {
        BufferedWriter bufferedWriter;
        WriterAdapter writerAdapter;
        if (l < 1L) {
            throw JDBCUtil.invalidArgument("pos: " + l);
        }
        this.checkClosed();
        this.createFile();
        long l2 = this.length();
        if (l > l2 + 1L) {
            this.fillSpace(l2 + 1L, l);
        }
        try {
            writerAdapter = new WriterAdapter(this.m_file, l - 1L){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        JDBCClobFile.this.m_streams.remove(this);
                    }
                }
            };
            bufferedWriter = new BufferedWriter(writerAdapter);
        }
        catch (IOException iOException) {
            throw JDBCUtil.sqlException(iOException);
        }
        catch (Throwable throwable) {
            throw JDBCUtil.sqlException(throwable);
        }
        this.m_streams.add(writerAdapter);
        return bufferedWriter;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void truncate(long l) throws SQLException {
        if (l < 0L) {
            throw JDBCUtil.invalidArgument("len: " + l);
        }
        this.checkClosed();
        ReaderAdapter readerAdapter = null;
        RandomAccessFile randomAccessFile = null;
        try {
            readerAdapter = new ReaderAdapter(this.m_file, l, Long.MAX_VALUE);
            long l2 = readerAdapter.getFilePointer();
            readerAdapter.close();
            randomAccessFile = new RandomAccessFile(this.m_file, "rw");
            randomAccessFile.setLength(l2);
        }
        catch (IOException iOException) {
            try {
                throw JDBCUtil.sqlException(iOException);
                catch (Throwable throwable) {
                    throw JDBCUtil.sqlException(throwable);
                }
            }
            catch (Throwable throwable) {
                JDBCClobFile.closeSafely(readerAdapter);
                JDBCClobFile.closeSafely(randomAccessFile);
                throw throwable;
            }
        }
        JDBCClobFile.closeSafely(readerAdapter);
        JDBCClobFile.closeSafely(randomAccessFile);
    }

    @Override
    public synchronized void free() throws SQLException {
        if (this.m_closed) {
            return;
        }
        this.m_closed = true;
        HsqlList hsqlList = this.m_streams;
        this.m_streams = null;
        Iterator iterator = hsqlList.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            this.closeSafely(object);
        }
        if (this.m_deleteOnFree) {
            try {
                this.m_file.delete();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    @Override
    public Reader getCharacterStream(long l, long l2) throws SQLException {
        ReaderAdapter readerAdapter;
        if (l < 1L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l);
        }
        if (l2 < 0L) {
            throw JDBCUtil.outOfRangeArgument("length: " + l2);
        }
        try {
            readerAdapter = new ReaderAdapter(this.m_file, l - 1L, l2){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        JDBCClobFile.this.m_streams.remove(this);
                    }
                }
            };
        }
        catch (IOException iOException) {
            throw JDBCUtil.sqlException(iOException);
        }
        catch (Throwable throwable) {
            throw JDBCUtil.sqlException(throwable);
        }
        this.m_streams.add(readerAdapter);
        return readerAdapter;
    }

    public File getFile() {
        return this.m_file;
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public boolean isDeleteOnFree() {
        return this.m_deleteOnFree;
    }

    public void setDeleteOnFree(boolean bl) {
        this.m_deleteOnFree = bl;
    }

    public JDBCClobFile() throws SQLException {
        this((String)null);
    }

    public JDBCClobFile(String string) throws SQLException {
        try {
            this.setEncoding(string);
            this.m_file = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
            this.m_deleteOnFree = true;
        }
        catch (IOException iOException) {
            throw JDBCUtil.sqlException(iOException);
        }
        catch (SecurityException securityException) {
            throw JDBCUtil.sqlException(securityException);
        }
    }

    public JDBCClobFile(File file) throws SQLException {
        this(file, null);
    }

    public JDBCClobFile(File file, String string) throws SQLException {
        if (file == null) {
            throw JDBCUtil.nullArgument("file");
        }
        try {
            this.setEncoding(string);
            this.m_file = file.getCanonicalFile();
            this.checkIsFile(false);
            this.m_deleteOnFree = false;
        }
        catch (IOException iOException) {
            throw JDBCUtil.sqlException(iOException);
        }
        catch (SQLException sQLException) {
            throw JDBCUtil.sqlException(sQLException);
        }
    }

    protected final void setEncoding(String string) throws UnsupportedEncodingException {
        boolean bl;
        Charset charset = JDBCClobFile.charsetForName(string);
        CharsetEncoder charsetEncoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        float f = charsetEncoder.maxBytesPerChar();
        float f2 = charsetEncoder.averageBytesPerChar();
        this.m_fixedWidthCharset = bl = f == (float)Math.round(f) && f == f2;
        this.m_maxCharWidth = Math.round(f);
        this.m_charset = charset;
        this.m_encoder = charsetEncoder;
        this.m_encoding = this.m_charset.name();
    }

    protected static Charset charsetForName(String string) throws UnsupportedEncodingException {
        String string2 = string;
        if (string2 == null) {
            string2 = Charset.defaultCharset().name();
        }
        try {
            if (Charset.isSupported(string2)) {
                return Charset.forName(string2);
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            LOG.warning(illegalCharsetNameException.getMessage(), illegalCharsetNameException);
        }
        throw new UnsupportedEncodingException(string2);
    }

    protected final void checkIsFile(boolean bl) throws SQLException {
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            bl2 = this.m_file.exists();
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        if (bl2) {
            try {
                bl3 = this.m_file.isFile();
            }
            catch (Exception exception) {
                throw JDBCUtil.sqlException(exception);
            }
        }
        if (bl2) {
            if (!bl3) {
                throw JDBCUtil.invalidArgument("Is not a file: " + this.m_file);
            }
        } else if (bl) {
            throw JDBCUtil.invalidArgument("Does not exist: " + this.m_file);
        }
    }

    protected void checkClosed() throws SQLException {
        if (this.m_closed) {
            throw JDBCUtil.sqlException(1251);
        }
    }

    protected void createFile() throws SQLException {
        try {
            if (!this.m_file.exists()) {
                FileUtil.getFileUtil().makeParentDirectories(this.m_file);
                this.m_file.createNewFile();
            }
        }
        catch (IOException iOException) {
            throw JDBCUtil.sqlException(iOException);
        }
        catch (Throwable throwable) {
            throw JDBCUtil.sqlException(throwable);
        }
        this.checkIsFile(true);
    }

    private static void closeSafely(RandomAccessFile randomAccessFile) {
        if (randomAccessFile != null) {
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                LOG.info(iOException.getMessage(), iOException);
            }
            catch (Throwable throwable) {
                LOG.info(throwable.getMessage(), throwable);
            }
        }
    }

    private static void closeSafely(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                LOG.info(iOException.getMessage(), iOException);
            }
            catch (Throwable throwable) {
                LOG.info(throwable.getMessage(), throwable);
            }
        }
    }

    private static void closeSafely(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                LOG.info(iOException.getMessage(), iOException);
            }
            catch (Throwable throwable) {
                LOG.info(throwable.getMessage(), throwable);
            }
        }
    }

    private static void closeSafely(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                LOG.info(iOException.getMessage(), iOException);
            }
            catch (Throwable throwable) {
                LOG.info(throwable.getMessage(), throwable);
            }
        }
    }

    private static void closeSafely(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                LOG.info(iOException.getMessage(), iOException);
            }
            catch (Throwable throwable) {
                LOG.info(throwable.getMessage(), throwable);
            }
        }
    }

    private static void closeSafely(Scanner scanner) {
        if (scanner != null) {
            try {
                scanner.close();
            }
            catch (Throwable throwable) {
                LOG.info(throwable.getMessage(), throwable);
            }
        }
    }

    private void closeSafely(Object object) {
        if (object instanceof RandomAccessFile) {
            JDBCClobFile.closeSafely((RandomAccessFile)object);
        } else if (object instanceof InputStream) {
            JDBCClobFile.closeSafely((InputStream)object);
        } else if (object instanceof OutputStream) {
            JDBCClobFile.closeSafely((OutputStream)object);
        } else if (object instanceof Reader) {
            JDBCClobFile.closeSafely((Reader)object);
        } else if (object instanceof Writer) {
            JDBCClobFile.closeSafely((Writer)object);
        } else if (object instanceof Scanner) {
            JDBCClobFile.closeSafely((Scanner)object);
        }
    }

    protected class ReaderAdapter
    extends Reader {
        private static final int CHARBUFFER_CAPACTIY = 128;
        private final Reader m_reader;
        private long m_remaining = Long.MAX_VALUE;
        private long m_filePointer;
        private ByteBuffer m_byteBuffer;
        private CharBuffer m_charBuffer;

        protected ReaderAdapter(File file, long l, long l2) throws FileNotFoundException, IOException, NullPointerException, IllegalArgumentException, SecurityException {
            long l3;
            if (file == null) {
                throw new NullPointerException("file");
            }
            if (l < 0L) {
                throw new IllegalArgumentException("pos: " + l);
            }
            if (l2 < 0L) {
                throw new IllegalArgumentException("length: " + l2);
            }
            long l4 = file.length();
            long l5 = l3 = JDBCClobFile.this.m_fixedWidthCharset ? Math.round((double)l4 / (double)JDBCClobFile.this.m_maxCharWidth) : l4;
            if (l3 - l < 0L) {
                throw new IllegalArgumentException("pos: " + l);
            }
            if (!JDBCClobFile.this.m_fixedWidthCharset) {
                int n = 128 * JDBCClobFile.this.m_maxCharWidth;
                this.m_charBuffer = CharBuffer.allocate(128);
                this.m_byteBuffer = ByteBuffer.allocate(n);
            }
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, JDBCClobFile.this.m_charset);
                this.m_reader = inputStreamReader;
            }
            catch (FileNotFoundException fileNotFoundException) {
                JDBCClobFile.closeSafely(fileInputStream);
                throw fileNotFoundException;
            }
            catch (SecurityException securityException) {
                JDBCClobFile.closeSafely(fileInputStream);
                throw securityException;
            }
            catch (NullPointerException nullPointerException) {
                JDBCClobFile.closeSafely(fileInputStream);
                throw nullPointerException;
            }
            catch (RuntimeException runtimeException) {
                JDBCClobFile.closeSafely(fileInputStream);
                throw runtimeException;
            }
            long l6 = this.skip(l);
            if (l6 < l) {
                throw new IllegalArgumentException("pos: " + l);
            }
            this.m_remaining = l2;
        }

        @Override
        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3;
            int n4;
            long l = this.m_remaining;
            if (l <= 0L) {
                return -1;
            }
            if (l < (long)n2) {
                n2 = (int)l;
            }
            if ((n4 = this.m_reader.read(cArray, n, n2)) == -1) {
                return -1;
            }
            if ((long)n4 > l) {
                n4 = (int)l;
                this.m_remaining = 0L;
            } else {
                this.m_remaining -= (long)n4;
            }
            if (JDBCClobFile.this.m_fixedWidthCharset) {
                n3 = JDBCClobFile.this.m_maxCharWidth * n4;
            } else {
                boolean bl = n4 > this.m_charBuffer.capacity();
                CharBuffer charBuffer = bl ? CharBuffer.allocate(n4) : this.m_charBuffer;
                ByteBuffer byteBuffer = bl ? ByteBuffer.allocate(n4 * JDBCClobFile.this.m_maxCharWidth) : this.m_byteBuffer;
                charBuffer.clear();
                byteBuffer.clear();
                charBuffer.put(cArray, n, n4);
                charBuffer.flip();
                JDBCClobFile.this.m_encoder.encode(charBuffer, byteBuffer, true);
                byteBuffer.flip();
                n3 = byteBuffer.limit();
                if (bl) {
                    this.m_byteBuffer = byteBuffer;
                    this.m_charBuffer = charBuffer;
                }
            }
            this.m_filePointer += (long)n3;
            return n4;
        }

        @Override
        public void close() throws IOException {
            this.m_reader.close();
        }

        public long getFilePointer() {
            return this.m_filePointer;
        }
    }

    protected class WriterAdapter
    extends Writer {
        protected final Writer m_writer;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected WriterAdapter(File file, long l) throws FileNotFoundException, IOException, SecurityException, NullPointerException, IllegalArgumentException {
            long l2;
            if (file == null) {
                throw new NullPointerException("file");
            }
            if (l < 0L) {
                throw new IllegalArgumentException("pos: " + l);
            }
            ReaderAdapter readerAdapter = null;
            try {
                readerAdapter = new ReaderAdapter(file, l, Long.MAX_VALUE);
                l2 = readerAdapter.getFilePointer();
            }
            catch (Throwable throwable) {
                JDBCClobFile.closeSafely(readerAdapter);
                throw throwable;
            }
            JDBCClobFile.closeSafely(readerAdapter);
            RandomAccessFile randomAccessFile = null;
            boolean bl = false;
            try {
                randomAccessFile = new RandomAccessFile(file, "rw");
                randomAccessFile.seek(l2);
                bl = true;
            }
            finally {
                if (!bl) {
                    JDBCClobFile.closeSafely(randomAccessFile);
                }
            }
            JDBCBlobFile.OutputStreamAdapter outputStreamAdapter = new JDBCBlobFile.OutputStreamAdapter(randomAccessFile);
            this.m_writer = JDBCClobFile.this.m_encoding == null ? new OutputStreamWriter(outputStreamAdapter) : new OutputStreamWriter((OutputStream)outputStreamAdapter, JDBCClobFile.this.m_charset);
        }

        @Override
        public void flush() throws IOException {
            this.m_writer.flush();
        }

        @Override
        public void close() throws IOException {
            this.m_writer.close();
        }

        @Override
        public void write(char[] cArray, int n, int n2) throws IOException {
            this.m_writer.write(cArray, n, n2);
        }
    }
}

