/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.math.BigDecimal;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Row;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

abstract class RowOutputBase
extends HsqlByteArrayOutputStream
implements RowOutputInterface {
    public RowOutputBase() {
    }

    public RowOutputBase(int n) {
        super(n);
    }

    public RowOutputBase(byte[] byArray) {
        super(byArray);
    }

    protected void writeFieldPrefix() {
    }

    protected abstract void writeFieldType(Type var1);

    protected abstract void writeNull(Type var1);

    protected abstract void writeChar(String var1, Type var2);

    protected abstract void writeSmallint(Number var1);

    protected abstract void writeInteger(Number var1);

    protected abstract void writeBigint(Number var1);

    protected abstract void writeReal(Double var1);

    protected abstract void writeDecimal(BigDecimal var1, Type var2);

    protected abstract void writeBoolean(Boolean var1);

    protected abstract void writeDate(TimestampData var1, Type var2);

    protected abstract void writeTime(TimeData var1, Type var2);

    protected abstract void writeTimestamp(TimestampData var1, Type var2);

    protected abstract void writeYearMonthInterval(IntervalMonthData var1, Type var2);

    protected abstract void writeDaySecondInterval(IntervalSecondData var1, Type var2);

    protected abstract void writeOther(JavaObjectData var1);

    protected abstract void writeBit(BinaryData var1);

    protected abstract void writeUUID(BinaryData var1);

    protected abstract void writeBinary(BinaryData var1);

    protected abstract void writeClob(ClobData var1, Type var2);

    protected abstract void writeBlob(BlobData var1, Type var2);

    protected abstract void writeArray(Object[] var1, Type var2);

    @Override
    public void writeData(Row row, Type[] typeArray) {
        this.writeData(typeArray.length, typeArray, row.getData(), null, null);
    }

    @Override
    public void writeData(int n, Type[] typeArray, Object[] objectArray, HashMappedList hashMappedList, int[] nArray) {
        boolean bl = nArray != null && nArray.length != 0;
        int n2 = bl ? nArray.length : n;
        for (int i = 0; i < n2; ++i) {
            int n3 = bl ? nArray[i] : i;
            Object object = objectArray[n3];
            Type type = typeArray[n3];
            if (hashMappedList != null) {
                ColumnSchema columnSchema = (ColumnSchema)hashMappedList.get(n3);
                this.writeFieldPrefix();
                this.writeString(columnSchema.getName().statementName);
            }
            this.writeData(object, type);
        }
    }

    @Override
    public void writeData(Object object, Type type) {
        if (object == null) {
            this.writeNull(type);
            return;
        }
        this.writeFieldType(type);
        switch (type.typeCode) {
            case 0: {
                break;
            }
            case 1: 
            case 12: {
                this.writeChar((String)object, type);
                break;
            }
            case -6: 
            case 5: {
                this.writeSmallint((Number)object);
                break;
            }
            case 4: {
                this.writeInteger((Number)object);
                break;
            }
            case 25: {
                this.writeBigint((Number)object);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this.writeReal((Double)object);
                break;
            }
            case 2: 
            case 3: {
                this.writeDecimal((BigDecimal)object, type);
                break;
            }
            case 16: {
                this.writeBoolean((Boolean)object);
                break;
            }
            case 91: {
                this.writeDate((TimestampData)object, type);
                break;
            }
            case 92: 
            case 94: {
                this.writeTime((TimeData)object, type);
                break;
            }
            case 93: 
            case 95: {
                this.writeTimestamp((TimestampData)object, type);
                break;
            }
            case 101: 
            case 102: 
            case 107: {
                this.writeYearMonthInterval((IntervalMonthData)object, type);
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                this.writeDaySecondInterval((IntervalSecondData)object, type);
                break;
            }
            case 1111: {
                this.writeOther((JavaObjectData)object);
                break;
            }
            case 30: {
                this.writeBlob((BlobData)object, type);
                break;
            }
            case 40: {
                this.writeClob((ClobData)object, type);
                break;
            }
            case 50: {
                this.writeArray((Object[])object, type);
                break;
            }
            case -11: {
                this.writeUUID((BinaryData)object);
                break;
            }
            case 60: 
            case 61: {
                this.writeBinary((BinaryData)object);
                break;
            }
            case 14: 
            case 15: {
                this.writeBit((BinaryData)object);
                break;
            }
            default: {
                throw Error.runtimeError(201, "RowOutputBase - " + type.getNameString());
            }
        }
    }

    @Override
    public HsqlByteArrayOutputStream getOutputStream() {
        return this;
    }

    @Override
    public abstract RowOutputInterface duplicate();
}

