/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.harvest;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.StackProperties;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.attribute.UsernameAttribute;
import org.ice4j.ice.Agent;
import org.ice4j.ice.Component;
import org.ice4j.ice.HostCandidate;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.IceProcessingState;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.NetworkUtils;
import org.ice4j.ice.harvest.CandidateHarvester;
import org.ice4j.ice.harvest.HostCandidateHarvester;
import org.ice4j.message.Message;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.socket.IceUdpSocketWrapper;
import org.ice4j.socket.MultiplexingDatagramSocket;
import org.ice4j.socket.StunDatagramPacketFilter;
import org.ice4j.stack.StunStack;
import org.ice4j.util.QueueStatistics;

public class SinglePortUdpHarvester
extends CandidateHarvester {
    private static final Logger logger = Logger.getLogger(SinglePortUdpHarvester.class.getName());
    private static final int BUFFER_SIZE = 1472;
    private static final int POOL_SIZE = 256;
    private final Map<SocketAddress, MySocket> sockets = new ConcurrentHashMap<SocketAddress, MySocket>();
    private final Map<String, MyCandidate> candidates = new ConcurrentHashMap<String, MyCandidate>();
    private final ArrayBlockingQueue<Buffer> pool = new ArrayBlockingQueue(256);
    private final TransportAddress localAddress;
    private final DatagramSocket socket;
    private final Thread thread;

    public static List<SinglePortUdpHarvester> createHarvesters(int port) {
        LinkedList<SinglePortUdpHarvester> harvesters = new LinkedList<SinglePortUdpHarvester>();
        LinkedList<TransportAddress> addresses = new LinkedList<TransportAddress>();
        boolean isIPv6Disabled = StackProperties.getBoolean("org.ice4j.ipv6.DISABLED", false);
        boolean isIPv6LinkLocalDisabled = StackProperties.getBoolean("org.ice4j.ice.harvest.DISABLE_LINK_LOCAL_ADDRESSES", false);
        try {
            for (NetworkInterface iface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                if (NetworkUtils.isInterfaceLoopback(iface) || !NetworkUtils.isInterfaceUp(iface) || !HostCandidateHarvester.isInterfaceAllowed(iface)) continue;
                Enumeration<InetAddress> ifaceAddresses = iface.getInetAddresses();
                while (ifaceAddresses.hasMoreElements()) {
                    InetAddress address = ifaceAddresses.nextElement();
                    if (!HostCandidateHarvester.isAddressAllowed(address) || isIPv6Disabled && address instanceof Inet6Address || isIPv6LinkLocalDisabled && address instanceof Inet6Address && address.isLinkLocalAddress()) continue;
                    addresses.add(new TransportAddress(address, port, Transport.UDP));
                }
            }
        }
        catch (SocketException se) {
            logger.info("Failed to get network interfaces: " + se);
        }
        for (TransportAddress address : addresses) {
            try {
                harvesters.add(new SinglePortUdpHarvester(address));
            }
            catch (IOException ioe) {
                logger.info("Failed to create SinglePortUdpHarvester for address " + address + ": " + ioe);
            }
        }
        return harvesters;
    }

    public SinglePortUdpHarvester(TransportAddress localAddress) throws IOException {
        this.localAddress = localAddress;
        this.socket = new DatagramSocket(localAddress);
        logger.info("Initialized SinglePortUdpHarvester with address " + localAddress);
        this.thread = new Thread(){

            @Override
            public void run() {
                SinglePortUdpHarvester.this.runInHarvesterThread();
            }
        };
        this.thread.setName(SinglePortUdpHarvester.class.getName() + " thread");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void runInHarvesterThread() {
        DatagramPacket pkt = null;
        while (true) {
            MyCandidate candidate;
            Component component;
            Buffer buf = this.getFreeBuffer();
            if (pkt == null) {
                pkt = new DatagramPacket(buf.buffer, 0, buf.buffer.length);
            } else {
                pkt.setData(buf.buffer, 0, buf.buffer.length);
            }
            try {
                this.socket.receive(pkt);
            }
            catch (IOException ioe) {
                logger.severe("Failed to receive from socket: " + ioe);
                break;
            }
            buf.len = pkt.getLength();
            InetSocketAddress remoteAddress = (InetSocketAddress)pkt.getSocketAddress();
            MySocket destinationSocket = this.sockets.get(remoteAddress);
            if (destinationSocket != null) {
                destinationSocket.addBuffer(buf);
                continue;
            }
            String ufrag = this.getUfrag(buf.buffer, 0, buf.len);
            if (ufrag == null || (component = (candidate = this.candidates.get(ufrag)) == null ? null : candidate.getParentComponent()) == null) continue;
            try {
                MySocket newSocket = new MySocket(remoteAddress);
                this.sockets.put(remoteAddress, newSocket);
                candidate.addSocket(newSocket, remoteAddress);
                newSocket.addBuffer(buf);
            }
            catch (SocketException se) {
                logger.info("Could not create a socket: " + se);
            }
            catch (IOException ioe) {
                logger.info("Failed to handle new socket: " + ioe);
            }
        }
    }

    private Buffer getFreeBuffer() {
        Buffer buf = this.pool.poll();
        if (buf == null) {
            buf = new Buffer(new byte[1472], 0);
        }
        return buf;
    }

    private String getUfrag(byte[] buf, int off, int len) {
        if (buf == null || buf.length < off + len || len < 20) {
            return null;
        }
        if ((buf[off + 4] & 0xFF) != 33 || (buf[off + 5] & 0xFF) != 18 || (buf[off + 6] & 0xFF) != 164 || (buf[off + 7] & 0xFF) != 66) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Not a STUN packet, magic cookie not found.");
            }
            return null;
        }
        try {
            Message stunMessage = Message.decode(buf, (char)off, (char)len);
            if (stunMessage.getMessageType() != '\u0001') {
                return null;
            }
            UsernameAttribute usernameAttribute = (UsernameAttribute)stunMessage.getAttribute('\u0006');
            if (usernameAttribute == null) {
                return null;
            }
            String usernameString = new String(usernameAttribute.getUsername());
            return usernameString.split(":")[0];
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Failed to extract local ufrag: " + e);
            }
            return null;
        }
    }

    @Override
    public Collection<LocalCandidate> harvest(Component component) {
        IceMediaStream stream = component.getParentStream();
        Agent agent = stream.getParentAgent();
        String ufrag = agent.getLocalUfrag();
        if (stream.getComponentCount() != 1 || agent.getStreamCount() != 1) {
            logger.info("More than one Component for an Agent, cannot harvest.");
            return new LinkedList<LocalCandidate>();
        }
        MyCandidate candidate = new MyCandidate(component, ufrag);
        this.candidates.put(ufrag, candidate);
        component.addLocalCandidate(candidate);
        return new ArrayList<LocalCandidate>(Arrays.asList(candidate));
    }

    @Override
    public boolean isHostHarvester() {
        return true;
    }

    private class MyCandidate
    extends HostCandidate {
        private final String ufrag;
        private boolean freed;
        private final Map<SocketAddress, IceSocketWrapper> candidateSockets;
        private final Map<SocketAddress, DatagramSocket> sockets;

        private MyCandidate(Component component, String ufrag) {
            super(SinglePortUdpHarvester.this.localAddress, component);
            this.freed = false;
            this.candidateSockets = new HashMap<SocketAddress, IceSocketWrapper>();
            this.sockets = new HashMap<SocketAddress, DatagramSocket>();
            this.ufrag = ufrag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void free() {
            Map<SocketAddress, IceSocketWrapper> map = this;
            synchronized (map) {
                if (this.freed) {
                    return;
                }
                this.freed = true;
            }
            SinglePortUdpHarvester.this.candidates.remove(this.ufrag);
            map = this.sockets;
            synchronized (map) {
                StunStack stunStack = this.getStunStack();
                for (Map.Entry<SocketAddress, DatagramSocket> e : this.sockets.entrySet()) {
                    DatagramSocket socket = e.getValue();
                    if (stunStack != null) {
                        TransportAddress localAddress = new TransportAddress(socket.getLocalAddress(), socket.getLocalPort(), Transport.UDP);
                        TransportAddress remoteAddress = new TransportAddress((InetSocketAddress)e.getKey(), Transport.UDP);
                        stunStack.removeSocket(localAddress, remoteAddress);
                    }
                    socket.close();
                }
                this.sockets.clear();
            }
            map = this.candidateSockets;
            synchronized (map) {
                this.candidateSockets.clear();
            }
            super.free();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void addSocket(DatagramSocket socket, InetSocketAddress remoteAddress) throws IOException {
            if (this.freed) {
                throw new IOException("Candidate freed");
            }
            Component component = this.getParentComponent();
            if (component == null) {
                throw new IOException("No parent component");
            }
            IceProcessingState state = component.getParentStream().getParentAgent().getState();
            if (!IceProcessingState.WAITING.equals((Object)state) && !IceProcessingState.RUNNING.equals((Object)state)) {
                throw new IOException("Agent state is " + (Object)((Object)state) + ". Cannot add socket.");
            }
            MultiplexingDatagramSocket multiplexing = new MultiplexingDatagramSocket(socket);
            IceUdpSocketWrapper candidateSocket = new IceUdpSocketWrapper(multiplexing);
            IceUdpSocketWrapper stunSocket = new IceUdpSocketWrapper(multiplexing.getSocket(new StunDatagramPacketFilter()));
            component.getParentStream().getParentAgent().getStunStack().addSocket(stunSocket, new TransportAddress(remoteAddress, Transport.UDP));
            Map<SocketAddress, Object> map = this.candidateSockets;
            synchronized (map) {
                this.candidateSockets.put(remoteAddress, candidateSocket);
            }
            map = this.sockets;
            synchronized (map) {
                this.sockets.put(remoteAddress, socket);
            }
        }

        @Override
        public IceSocketWrapper getIceSocketWrapper(SocketAddress remoteAddress) {
            return this.candidateSockets.get(remoteAddress);
        }
    }

    private class Buffer {
        byte[] buffer;
        int len;

        private Buffer(byte[] buffer, int len) {
            this.buffer = buffer;
            this.len = len;
        }
    }

    private class MySocket
    extends DatagramSocket {
        private static final int QUEUE_SIZE = 128;
        private final ArrayBlockingQueue<Buffer> queue;
        private final QueueStatistics queueStatistics;
        private SocketAddress remoteAddress;
        private boolean closed;

        public MySocket(SocketAddress remoteAddress) throws SocketException {
            super((SocketAddress)null);
            this.queue = new ArrayBlockingQueue(128);
            this.closed = false;
            this.remoteAddress = remoteAddress;
            this.queueStatistics = logger.isLoggable(Level.FINEST) ? new QueueStatistics("SinglePort" + remoteAddress.toString().replace('/', '-')) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addBuffer(Buffer buf) {
            ArrayBlockingQueue<Buffer> arrayBlockingQueue = this.queue;
            synchronized (arrayBlockingQueue) {
                if (this.queue.size() == 128) {
                    logger.info("Dropping a packet because the queue is full.");
                    if (this.queueStatistics != null) {
                        this.queueStatistics.remove(System.currentTimeMillis());
                    }
                    this.queue.poll();
                }
                this.queue.offer(buf);
                if (this.queueStatistics != null) {
                    this.queueStatistics.add(System.currentTimeMillis());
                }
                this.queue.notifyAll();
            }
        }

        @Override
        public InetAddress getLocalAddress() {
            return SinglePortUdpHarvester.this.localAddress.getAddress();
        }

        @Override
        public int getLocalPort() {
            return SinglePortUdpHarvester.this.localAddress.getPort();
        }

        @Override
        public SocketAddress getLocalSocketAddress() {
            return SinglePortUdpHarvester.this.localAddress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            this.closed = true;
            ArrayBlockingQueue<Buffer> arrayBlockingQueue = this.queue;
            synchronized (arrayBlockingQueue) {
                this.queue.notifyAll();
            }
            if (this.remoteAddress != null) {
                SinglePortUdpHarvester.this.sockets.remove(this.remoteAddress);
            }
            super.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receive(DatagramPacket p) throws IOException {
            Buffer buf = null;
            while (buf == null) {
                if (this.closed) {
                    throw new SocketException("Socket closed");
                }
                ArrayBlockingQueue<Buffer> arrayBlockingQueue = this.queue;
                synchronized (arrayBlockingQueue) {
                    if (this.queue.isEmpty()) {
                        try {
                            this.queue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    buf = this.queue.poll();
                    if (this.queueStatistics != null) {
                        this.queueStatistics.remove(System.currentTimeMillis());
                    }
                }
            }
            byte[] pData = p.getData();
            if (pData == null || pData.length < buf.len) {
                throw new IOException("packet buffer not available");
            }
            System.arraycopy(buf.buffer, 0, pData, 0, buf.len);
            p.setLength(buf.len);
            p.setSocketAddress(this.remoteAddress);
            SinglePortUdpHarvester.this.pool.offer(buf);
        }

        @Override
        public void send(DatagramPacket p) throws IOException {
            SinglePortUdpHarvester.this.socket.send(p);
        }
    }
}

