/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TableColumnManager
implements MouseListener,
ActionListener,
TableColumnModelListener,
PropertyChangeListener {
    private JTable table;
    private TableColumnModel columnModel;
    private boolean menuPopup;
    private List<TableColumn> allColumns;

    public TableColumnManager(JTable table) {
        this(table, true);
    }

    public TableColumnManager(JTable table, boolean menuPopup) {
        this.table = table;
        this.setMenuPopup(menuPopup);
        table.addPropertyChangeListener(this);
        this.reset();
    }

    public void reset() {
        this.table.getColumnModel().removeColumnModelListener(this);
        this.columnModel = this.table.getColumnModel();
        this.columnModel.addColumnModelListener(this);
        int count = this.columnModel.getColumnCount();
        this.allColumns = new ArrayList<TableColumn>(count);
        for (int i = 0; i < count; ++i) {
            this.allColumns.add(this.columnModel.getColumn(i));
        }
    }

    public boolean isMenuPopup() {
        return this.menuPopup;
    }

    public void setMenuPopup(boolean menuPopup) {
        this.table.getTableHeader().removeMouseListener(this);
        if (menuPopup) {
            this.table.getTableHeader().addMouseListener(this);
        }
        this.menuPopup = menuPopup;
    }

    public void hideColumn(int modelColumn) {
        int viewColumn = this.table.convertColumnIndexToView(modelColumn);
        if (viewColumn != -1) {
            TableColumn column = this.columnModel.getColumn(viewColumn);
            this.hideColumn(column);
        }
    }

    public void hideColumn(Object columnName) {
        if (columnName == null) {
            return;
        }
        for (int i = 0; i < this.columnModel.getColumnCount(); ++i) {
            TableColumn column = this.columnModel.getColumn(i);
            if (!columnName.equals(column.getHeaderValue())) continue;
            this.hideColumn(column);
            break;
        }
    }

    public void hideColumn(TableColumn column) {
        if (this.columnModel.getColumnCount() == 1) {
            return;
        }
        this.columnModel.removeColumnModelListener(this);
        this.columnModel.removeColumn(column);
        this.columnModel.addColumnModelListener(this);
    }

    public void showColumn(int modelColumn) {
        for (TableColumn column : this.allColumns) {
            if (column.getModelIndex() != modelColumn) continue;
            this.showColumn(column);
            break;
        }
    }

    public void showColumn(Object columnName) {
        for (TableColumn column : this.allColumns) {
            if (!column.getHeaderValue().equals(columnName)) continue;
            this.showColumn(column);
            break;
        }
    }

    private void showColumn(TableColumn column) {
        this.columnModel.removeColumnModelListener(this);
        this.columnModel.addColumn(column);
        int position = this.allColumns.indexOf(column);
        int from = this.columnModel.getColumnCount() - 1;
        int to = 0;
        for (int i = position - 1; i > -1; --i) {
            try {
                TableColumn visibleColumn = this.allColumns.get(i);
                to = this.columnModel.getColumnIndex(visibleColumn.getHeaderValue()) + 1;
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        this.columnModel.moveColumn(from, to);
        this.columnModel.addColumnModelListener(this);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.checkForPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.checkForPopup(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void checkForPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            JTableHeader header = (JTableHeader)e.getComponent();
            int column = header.columnAtPoint(e.getPoint());
            this.showPopup(column);
        }
    }

    private void showPopup(int index) {
        Object headerValue = this.columnModel.getColumn(index).getHeaderValue();
        int columnCount = this.columnModel.getColumnCount();
        SelectPopupMenu popup = new SelectPopupMenu();
        for (TableColumn tableColumn : this.allColumns) {
            Object value = tableColumn.getHeaderValue();
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(value.toString());
            item.addActionListener(this);
            try {
                this.columnModel.getColumnIndex(value);
                item.setSelected(true);
                if (columnCount == 1) {
                    item.setEnabled(false);
                }
            }
            catch (IllegalArgumentException e) {
                item.setSelected(false);
            }
            popup.add(item);
            if (value != headerValue) continue;
            ((JPopupMenu)popup).setSelected(item);
        }
        JTableHeader header = this.table.getTableHeader();
        Rectangle r = header.getHeaderRect(index);
        popup.show(header, r.x, r.height);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JMenuItem item = (JMenuItem)event.getSource();
        if (item.isSelected()) {
            this.showColumn(item.getText());
        } else {
            this.hideColumn(item.getText());
        }
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
        TableColumn column = this.columnModel.getColumn(e.getToIndex());
        if (!this.allColumns.contains(column)) {
            this.allColumns.add(column);
        }
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
        if (e.getFromIndex() == e.getToIndex()) {
            return;
        }
        int index = e.getToIndex();
        TableColumn column = this.columnModel.getColumn(index);
        this.allColumns.remove(column);
        if (index == 0) {
            this.allColumns.add(0, column);
        } else {
            TableColumn visibleColumn = this.columnModel.getColumn(--index);
            int insertionColumn = this.allColumns.indexOf(visibleColumn);
            this.allColumns.add(insertionColumn + 1, column);
        }
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("model".equals(e.getPropertyName()) && this.table.getAutoCreateColumnsFromModel()) {
            this.reset();
        }
    }

    class SelectPopupMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 918018121618942657L;

        SelectPopupMenu() {
        }

        @Override
        public void setSelected(Component sel) {
            int index = this.getComponentIndex(sel);
            this.getSelectionModel().setSelectedIndex(index);
            final MenuElement[] me = new MenuElement[]{this, this.getSubElements()[index]};
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MenuSelectionManager.defaultManager().setSelectedPath(me);
                }
            });
        }
    }
}

