/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.Arrays;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ImplicitNullAnnotationVerifier;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.eclipse.jdt.internal.compiler.util.Sorting;

class MethodVerifier15
extends MethodVerifier {
    MethodVerifier15(LookupEnvironment lookupEnvironment) {
        super(lookupEnvironment);
    }

    @Override
    protected boolean canOverridingMethodDifferInErasure(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (methodBinding.areParameterErasuresEqual(methodBinding2)) {
            return false;
        }
        return !methodBinding.declaringClass.isRawType();
    }

    @Override
    boolean canSkipInheritedMethods() {
        if (this.type.superclass() != null && (this.type.superclass().isAbstract() || this.type.superclass().isParameterizedType())) {
            return false;
        }
        return this.type.superInterfaces() == Binding.NO_SUPERINTERFACES;
    }

    @Override
    boolean canSkipInheritedMethods(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return methodBinding2 == null || TypeBinding.equalsEquals(methodBinding.declaringClass, methodBinding2.declaringClass) && !methodBinding.declaringClass.isParameterizedType();
    }

    @Override
    void checkConcreteInheritedMethod(MethodBinding methodBinding, MethodBinding[] methodBindingArray) {
        super.checkConcreteInheritedMethod(methodBinding, methodBindingArray);
        boolean bl = this.environment.globalOptions.isAnnotationBasedNullAnalysisEnabled;
        AbstractMethodDeclaration abstractMethodDeclaration = null;
        if (bl && this.type.equals(methodBinding.declaringClass)) {
            abstractMethodDeclaration = methodBinding.sourceMethod();
        }
        boolean bl2 = this.environment.usesNullTypeAnnotations();
        boolean bl3 = bl && methodBinding.hasNonNullDefaultFor(16, bl2);
        boolean bl4 = bl && methodBinding.hasNonNullDefaultFor(8, bl2);
        int n = methodBindingArray.length;
        for (int i = 0; i < n; ++i) {
            MethodBinding methodBinding2 = methodBindingArray[i];
            if (methodBinding.isVarargs() != methodBinding2.isVarargs()) {
                this.problemReporter().varargsConflict(methodBinding, methodBinding2, this.type);
            }
            MethodBinding methodBinding3 = methodBinding2.original();
            if (TypeBinding.notEquals(methodBinding3.returnType, methodBinding.returnType) && !this.isAcceptableReturnTypeOverride(methodBinding, methodBinding2)) {
                this.problemReporter().unsafeReturnTypeOverride(methodBinding, methodBinding3, this.type);
            }
            if (methodBinding3.declaringClass.isInterface() && (TypeBinding.equalsEquals(methodBinding.declaringClass, this.type.superclass) && this.type.superclass.isParameterizedType() && !this.areMethodsCompatible(methodBinding, methodBinding3) || this.type.superclass.erasure().findSuperTypeOriginatingFrom(methodBinding3.declaringClass) == null)) {
                this.type.addSyntheticBridgeMethod(methodBinding3, methodBinding.original());
            }
            if (!bl || methodBinding.isStatic() || methodBinding2.isStatic()) continue;
            this.checkNullSpecInheritance(methodBinding, abstractMethodDeclaration, bl3, bl4, true, methodBinding2, methodBindingArray, this.type.scope, null);
        }
    }

    @Override
    void checkForBridgeMethod(MethodBinding methodBinding, MethodBinding methodBinding2, MethodBinding[] methodBindingArray) {
        SyntheticMethodBinding syntheticMethodBinding;
        if (methodBinding.isVarargs() != methodBinding2.isVarargs()) {
            this.problemReporter(methodBinding).varargsConflict(methodBinding, methodBinding2, this.type);
        }
        MethodBinding methodBinding3 = methodBinding2.original();
        if (TypeBinding.notEquals(methodBinding3.returnType, methodBinding.returnType) && !this.isAcceptableReturnTypeOverride(methodBinding, methodBinding2)) {
            this.problemReporter(methodBinding).unsafeReturnTypeOverride(methodBinding, methodBinding3, this.type);
        }
        if ((syntheticMethodBinding = this.type.addSyntheticBridgeMethod(methodBinding3, methodBinding.original())) != null) {
            int n;
            int n2 = n = methodBindingArray == null ? 0 : methodBindingArray.length;
            for (int i = 0; i < n; ++i) {
                if (methodBindingArray[i] == null || !this.detectInheritedNameClash(methodBinding3, methodBindingArray[i].original())) continue;
                return;
            }
            MethodBinding[] methodBindingArray2 = (MethodBinding[])this.currentMethods.get(syntheticMethodBinding.selector);
            for (n = methodBindingArray2.length - 1; n >= 0; --n) {
                MethodBinding methodBinding4 = methodBindingArray2[n];
                if (!methodBinding4.areParameterErasuresEqual(syntheticMethodBinding) || !TypeBinding.equalsEquals(methodBinding4.returnType.erasure(), syntheticMethodBinding.returnType.erasure())) continue;
                this.problemReporter(methodBinding4).methodNameClash(methodBinding4, methodBinding2.declaringClass.isRawType() ? methodBinding2 : methodBinding2.original(), 1);
                return;
            }
        }
    }

    void checkForNameClash(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (methodBinding2.isStatic() || methodBinding.isStatic()) {
            MethodBinding methodBinding3 = methodBinding2.original();
            if (this.type.scope.compilerOptions().complianceLevel >= 0x330000L && methodBinding.areParameterErasuresEqual(methodBinding3)) {
                this.problemReporter(methodBinding).methodNameClashHidden(methodBinding, methodBinding2.declaringClass.isRawType() ? methodBinding2 : methodBinding3);
            }
            return;
        }
        if (!this.detectNameClash(methodBinding, methodBinding2, false)) {
            int n;
            TypeBinding[] typeBindingArray = methodBinding.parameters;
            int n2 = typeBindingArray.length;
            TypeBinding[] typeBindingArray2 = methodBinding2.parameters;
            if (n2 != typeBindingArray2.length) {
                return;
            }
            for (int i = 0; i < n2; ++i) {
                if (!TypeBinding.notEquals(typeBindingArray[i], typeBindingArray2[i]) || typeBindingArray[i].isBaseType() == typeBindingArray2[i].isBaseType() && typeBindingArray2[i].isCompatibleWith(typeBindingArray[i])) continue;
                return;
            }
            ReferenceBinding[] referenceBindingArray = null;
            int n3 = 0;
            ReferenceBinding referenceBinding = methodBinding2.declaringClass;
            ReferenceBinding[] referenceBindingArray2 = referenceBinding.superInterfaces();
            if (referenceBindingArray2 != Binding.NO_SUPERINTERFACES) {
                n3 = referenceBindingArray2.length;
                referenceBindingArray = referenceBindingArray2;
            }
            for (referenceBinding = referenceBinding.superclass(); referenceBinding != null && referenceBinding.isValidBinding(); referenceBinding = referenceBinding.superclass()) {
                Binding binding;
                int n4;
                MethodBinding[] methodBindingArray = referenceBinding.getMethods(methodBinding.selector);
                n = methodBindingArray.length;
                for (n4 = 0; n4 < n; ++n4) {
                    binding = this.computeSubstituteMethod(methodBindingArray[n4], methodBinding);
                    if (binding == null || this.isSubstituteParameterSubsignature(methodBinding, (MethodBinding)binding) || !this.detectNameClash(methodBinding, (MethodBinding)binding, true)) continue;
                    return;
                }
                referenceBindingArray2 = referenceBinding.superInterfaces();
                if (referenceBindingArray2 == Binding.NO_SUPERINTERFACES) continue;
                if (referenceBindingArray == null) {
                    referenceBindingArray = referenceBindingArray2;
                    n3 = referenceBindingArray.length;
                    continue;
                }
                n4 = referenceBindingArray2.length;
                if (n3 + n4 >= referenceBindingArray.length) {
                    ReferenceBinding[] referenceBindingArray3 = referenceBindingArray;
                    referenceBindingArray = new ReferenceBinding[n3 + n4 + 5];
                    System.arraycopy(referenceBindingArray3, 0, referenceBindingArray, 0, n3);
                }
                block3: for (n = 0; n < n4; ++n) {
                    binding = referenceBindingArray2[n];
                    for (int i = 0; i < n3; ++i) {
                        if (TypeBinding.equalsEquals((TypeBinding)binding, referenceBindingArray[i])) continue block3;
                    }
                    referenceBindingArray[n3++] = binding;
                }
            }
            for (int i = 0; i < n3; ++i) {
                Binding binding;
                referenceBinding = referenceBindingArray[i];
                if (!referenceBinding.isValidBinding()) continue;
                MethodBinding[] methodBindingArray = referenceBinding.getMethods(methodBinding.selector);
                int n5 = methodBindingArray.length;
                for (n = 0; n < n5; ++n) {
                    binding = this.computeSubstituteMethod(methodBindingArray[n], methodBinding);
                    if (binding == null || this.isSubstituteParameterSubsignature(methodBinding, (MethodBinding)binding) || !this.detectNameClash(methodBinding, (MethodBinding)binding, true)) continue;
                    return;
                }
                referenceBindingArray2 = referenceBinding.superInterfaces();
                if (referenceBindingArray2 == Binding.NO_SUPERINTERFACES) continue;
                n = referenceBindingArray2.length;
                if (n3 + n >= referenceBindingArray.length) {
                    ReferenceBinding[] referenceBindingArray4 = referenceBindingArray;
                    referenceBindingArray = new ReferenceBinding[n3 + n + 5];
                    System.arraycopy(referenceBindingArray4, 0, referenceBindingArray, 0, n3);
                }
                block7: for (n5 = 0; n5 < n; ++n5) {
                    binding = referenceBindingArray2[n5];
                    for (int j = 0; j < n3; ++j) {
                        if (TypeBinding.equalsEquals((TypeBinding)binding, referenceBindingArray[j])) continue block7;
                    }
                    referenceBindingArray[n3++] = binding;
                }
            }
        }
    }

    void checkInheritedMethods(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (methodBinding.isStatic()) {
            return;
        }
        if (this.environment.globalOptions.complianceLevel < 0x330000L && methodBinding.declaringClass.isInterface()) {
            return;
        }
        this.detectInheritedNameClash(methodBinding.original(), methodBinding2.original());
    }

    @Override
    void checkInheritedMethods(MethodBinding[] methodBindingArray, int n, boolean[] blArray, boolean[] blArray2) {
        int n2;
        boolean bl = true;
        MethodBinding methodBinding = null;
        MethodBinding methodBinding2 = null;
        boolean bl2 = false;
        for (n2 = 0; n2 < n; ++n2) {
            if (methodBindingArray[n2].declaringClass.isInterface() || !TypeBinding.notEquals(methodBindingArray[n2].declaringClass, this.type) || !methodBindingArray[n2].isAbstract()) continue;
            methodBinding2 = methodBindingArray[n2];
            break;
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (!blArray2[n2] || methodBindingArray[n2].isAbstract()) continue;
            if (methodBindingArray[n2].isDefaultMethod() && methodBinding2 != null && MethodVerifier15.areParametersEqual(methodBinding2, methodBindingArray[n2]) && methodBinding == null) {
                bl2 = true;
                continue;
            }
            bl2 = false;
            if (methodBinding != null) {
                if (blArray[n2] && this.areMethodsCompatible(methodBinding, methodBindingArray[n2]) || TypeBinding.equalsEquals(methodBinding.declaringClass, methodBindingArray[n2].declaringClass) && methodBinding.typeVariables.length != methodBindingArray[n2].typeVariables.length && (methodBinding.typeVariables == Binding.NO_TYPE_VARIABLES && methodBinding.original() == methodBindingArray[n2] || methodBindingArray[n2].typeVariables == Binding.NO_TYPE_VARIABLES && methodBindingArray[n2].original() == methodBinding)) continue;
                this.problemReporter().duplicateInheritedMethods(this.type, methodBinding, methodBindingArray[n2], this.environment.globalOptions.sourceLevel >= 0x340000L);
                bl = false;
            }
            methodBinding = methodBindingArray[n2];
        }
        if (bl) {
            if (bl2) {
                if (!this.type.isAbstract()) {
                    this.problemReporter().abstractMethodMustBeImplemented(this.type, methodBinding2);
                    return;
                }
            } else if (methodBinding != null && methodBinding.isDefaultMethod() && this.environment.globalOptions.complianceLevel >= 0x340000L && !this.checkInheritedDefaultMethods(methodBindingArray, blArray, n)) {
                return;
            }
            super.checkInheritedMethods(methodBindingArray, n, blArray, blArray2);
        }
    }

    boolean checkInheritedDefaultMethods(MethodBinding[] methodBindingArray, boolean[] blArray, int n) {
        if (n < 2) {
            return true;
        }
        boolean bl = true;
        block0: for (int i = 0; i < n; ++i) {
            if (!methodBindingArray[i].isDefaultMethod() || blArray[i]) continue;
            for (int j = 0; j < n; ++j) {
                if (j == i || blArray[j] || !this.isMethodSubsignature(methodBindingArray[i], methodBindingArray[j]) || this.doesMethodOverride(methodBindingArray[i], methodBindingArray[j]) || this.doesMethodOverride(methodBindingArray[j], methodBindingArray[i])) continue;
                this.problemReporter().inheritedDefaultMethodConflictsWithOtherInherited(this.type, methodBindingArray[i], methodBindingArray[j]);
                bl = false;
                continue block0;
            }
        }
        return bl;
    }

    @Override
    boolean checkInheritedReturnTypes(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (this.areReturnTypesCompatible(methodBinding, methodBinding2)) {
            return true;
        }
        if (this.isUnsafeReturnTypeOverride(methodBinding, methodBinding2)) {
            if (!methodBinding.declaringClass.implementsInterface(methodBinding2.declaringClass, false)) {
                this.problemReporter(methodBinding).unsafeReturnTypeOverride(methodBinding, methodBinding2, this.type);
            }
            return true;
        }
        return false;
    }

    @Override
    void checkAgainstInheritedMethods(MethodBinding methodBinding, MethodBinding[] methodBindingArray, int n, MethodBinding[] methodBindingArray2) {
        super.checkAgainstInheritedMethods(methodBinding, methodBindingArray, n, methodBindingArray2);
        CompilerOptions compilerOptions = this.environment.globalOptions;
        if (compilerOptions.isAnnotationBasedNullAnalysisEnabled && (methodBinding.tagBits & 0x1000L) == 0L) {
            AbstractMethodDeclaration abstractMethodDeclaration = null;
            if (this.type.equals(methodBinding.declaringClass)) {
                abstractMethodDeclaration = methodBinding.sourceMethod();
            }
            boolean bl = this.environment.usesNullTypeAnnotations();
            boolean bl2 = methodBinding.hasNonNullDefaultFor(16, bl);
            boolean bl3 = methodBinding.hasNonNullDefaultFor(8, bl);
            int n2 = n;
            while (--n2 >= 0) {
                if (methodBinding.isStatic() || methodBindingArray[n2].isStatic()) continue;
                this.checkNullSpecInheritance(methodBinding, abstractMethodDeclaration, bl2, bl3, true, methodBindingArray[n2], methodBindingArray, this.type.scope, null);
            }
        }
    }

    @Override
    void checkNullSpecInheritance(MethodBinding methodBinding, AbstractMethodDeclaration abstractMethodDeclaration, boolean bl, boolean bl2, boolean bl3, MethodBinding methodBinding2, MethodBinding[] methodBindingArray, Scope scope, ImplicitNullAnnotationVerifier.InheritedNonNullnessInfo[] inheritedNonNullnessInfoArray) {
        if (!(bl || bl2 || (bl3 &= !methodBinding.isConstructor()) || this.environment.globalOptions.inheritNullAnnotations)) {
            methodBinding.tagBits |= 0x1000L;
            return;
        }
        if (TypeBinding.notEquals(methodBinding.declaringClass, this.type) && (methodBinding.tagBits & 0x1000L) == 0L) {
            this.buddyImplicitNullAnnotationsVerifier.checkImplicitNullAnnotations(methodBinding, abstractMethodDeclaration, bl3, scope);
        }
        super.checkNullSpecInheritance(methodBinding, abstractMethodDeclaration, bl, bl2, bl3, methodBinding2, methodBindingArray, scope, inheritedNonNullnessInfoArray);
    }

    void reportRawReferences() {
        CompilerOptions compilerOptions = this.type.scope.compilerOptions();
        if (compilerOptions.sourceLevel < 0x310000L || compilerOptions.reportUnavoidableGenericTypeProblems) {
            return;
        }
        Object[] objectArray = this.currentMethods.valueTable;
        int n = objectArray.length;
        while (--n >= 0) {
            if (objectArray[n] == null) continue;
            for (MethodBinding methodBinding : (MethodBinding[])objectArray[n]) {
                if ((methodBinding.modifiers & 0x30000000) != 0) continue;
                AbstractMethodDeclaration abstractMethodDeclaration = methodBinding.sourceMethod();
                if (abstractMethodDeclaration == null) {
                    return;
                }
                TypeBinding[] typeBindingArray = methodBinding.parameters;
                Argument[] argumentArray = abstractMethodDeclaration.arguments;
                int n2 = methodBinding.parameters.length;
                for (int i = 0; i < n2; ++i) {
                    TypeBinding typeBinding = typeBindingArray[i];
                    Argument argument = argumentArray[i];
                    if (!typeBinding.leafComponentType().isRawType() || compilerOptions.getSeverity(0x20010000) == 256 || (argument.type.bits & 0x40000000) != 0) continue;
                    abstractMethodDeclaration.scope.problemReporter().rawTypeReference(argument.type, typeBinding);
                }
                if (abstractMethodDeclaration.isConstructor() || !(abstractMethodDeclaration instanceof MethodDeclaration)) continue;
                TypeReference typeReference = ((MethodDeclaration)abstractMethodDeclaration).returnType;
                TypeBinding typeBinding = methodBinding.returnType;
                if (typeReference == null || !typeBinding.leafComponentType().isRawType() || compilerOptions.getSeverity(0x20010000) == 256 || (typeReference.bits & 0x40000000) != 0) continue;
                abstractMethodDeclaration.scope.problemReporter().rawTypeReference(typeReference, typeBinding);
            }
        }
    }

    @Override
    public void reportRawReferences(MethodBinding methodBinding, MethodBinding methodBinding2) {
        TypeBinding typeBinding;
        CompilerOptions compilerOptions = this.type.scope.compilerOptions();
        if (compilerOptions.sourceLevel < 0x310000L || compilerOptions.reportUnavoidableGenericTypeProblems) {
            return;
        }
        AbstractMethodDeclaration abstractMethodDeclaration = methodBinding.sourceMethod();
        if (abstractMethodDeclaration == null) {
            return;
        }
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        TypeBinding[] typeBindingArray2 = methodBinding2.parameters;
        Argument[] argumentArray = abstractMethodDeclaration.arguments;
        int n = methodBinding.parameters.length;
        for (int i = 0; i < n; ++i) {
            typeBinding = typeBindingArray[i];
            TypeBinding typeBinding2 = typeBindingArray2[i];
            Argument argument = argumentArray[i];
            if (!typeBinding.leafComponentType().isRawType()) continue;
            if (typeBinding2.leafComponentType().isRawType()) {
                argument.binding.tagBits |= 0x200L;
                continue;
            }
            if (compilerOptions.getSeverity(0x20010000) == 256 || (argument.type.bits & 0x40000000) != 0) continue;
            abstractMethodDeclaration.scope.problemReporter().rawTypeReference(argument.type, typeBinding);
        }
        TypeReference typeReference = null;
        if (!abstractMethodDeclaration.isConstructor() && abstractMethodDeclaration instanceof MethodDeclaration && (typeReference = ((MethodDeclaration)abstractMethodDeclaration).returnType) != null) {
            TypeBinding typeBinding3 = methodBinding2.returnType;
            typeBinding = methodBinding.returnType;
            if (typeBinding.leafComponentType().isRawType() && !typeBinding3.leafComponentType().isRawType() && (typeReference.bits & 0x40000000) == 0 && compilerOptions.getSeverity(0x20010000) != 256) {
                abstractMethodDeclaration.scope.problemReporter().rawTypeReference(typeReference, typeBinding);
            }
        }
    }

    @Override
    void checkMethods() {
        boolean bl = this.mustImplementAbstractMethods();
        boolean bl2 = bl && this.canSkipInheritedMethods();
        boolean bl3 = this.type.isOrEnclosedByPrivateType();
        char[][] cArray = this.inheritedMethods.keyTable;
        int n = cArray.length;
        while (--n >= 0) {
            Object object;
            MethodBinding methodBinding;
            int n2;
            Object object2;
            int n3;
            int n4;
            if (cArray[n] == null) continue;
            MethodBinding[] methodBindingArray = (MethodBinding[])this.currentMethods.get(cArray[n]);
            MethodBinding[] methodBindingArray2 = (MethodBinding[])this.inheritedMethods.valueTable[n];
            methodBindingArray2 = Sorting.concreteFirst(methodBindingArray2, methodBindingArray2.length);
            if (methodBindingArray == null && !bl3) {
                n4 = methodBindingArray2.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    methodBindingArray2[n3].original().modifiers |= 0x8000000;
                }
            }
            if (methodBindingArray == null && this.type.isPublic()) {
                n4 = methodBindingArray2.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    object2 = methodBindingArray2[n3];
                    if (!((MethodBinding)object2).isPublic() || ((MethodBinding)object2).declaringClass.isInterface() || ((MethodBinding)object2).declaringClass.isPublic()) continue;
                    this.type.addSyntheticBridgeMethod(((MethodBinding)object2).original());
                }
            }
            if (methodBindingArray == null && bl2) continue;
            if (methodBindingArray2.length == 1 && methodBindingArray == null) {
                if (!bl || !methodBindingArray2[0].isAbstract()) continue;
                this.checkAbstractMethod(methodBindingArray2[0]);
                continue;
            }
            n4 = -1;
            n3 = methodBindingArray2.length;
            object2 = new MethodBinding[n3];
            MethodBinding[] methodBindingArray3 = new MethodBinding[n3];
            boolean[] blArray = new boolean[n3];
            boolean[] blArray2 = new boolean[n3];
            boolean[] blArray3 = new boolean[n3];
            Arrays.fill(blArray3, true);
            if (methodBindingArray != null) {
                int n5 = methodBindingArray.length;
                for (n2 = 0; n2 < n5; ++n2) {
                    methodBinding = methodBindingArray[n2];
                    MethodBinding[] methodBindingArray4 = null;
                    for (int i = 0; i < n3; ++i) {
                        object = this.computeSubstituteMethod(methodBindingArray2[i], methodBinding);
                        if (object == null) continue;
                        if (methodBindingArray3[i] == null && this.isSubstituteParameterSubsignature(methodBinding, (MethodBinding)object)) {
                            blArray2[i] = blArray[i] = MethodVerifier15.couldMethodOverride(methodBinding, (MethodBinding)object);
                            object2[++n4] = object;
                            methodBindingArray3[i] = methodBinding;
                            continue;
                        }
                        this.checkForNameClash(methodBinding, (MethodBinding)object);
                        if (n3 <= 1) continue;
                        if (methodBindingArray4 == null) {
                            methodBindingArray4 = new MethodBinding[n3];
                        }
                        methodBindingArray4[i] = object;
                    }
                    if (n4 < 0) continue;
                    this.checkAgainstInheritedMethods(methodBinding, (MethodBinding[])object2, n4 + 1, methodBindingArray4);
                    while (n4 >= 0) {
                        object2[n4--] = null;
                    }
                }
            }
            for (n2 = 0; n2 < n3; ++n2) {
                MethodBinding methodBinding2 = methodBindingArray3[n2];
                if (methodBinding2 == null && methodBindingArray != null && this.type.isPublic() && (methodBinding = methodBindingArray2[n2]).isPublic() && !methodBinding.declaringClass.isInterface() && !methodBinding.declaringClass.isPublic()) {
                    this.type.addSyntheticBridgeMethod(methodBinding.original());
                }
                if (!bl3 && methodBinding2 == null && methodBindingArray != null) {
                    methodBindingArray2[n2].original().modifiers |= 0x8000000;
                }
                methodBinding = methodBindingArray2[n2];
                for (int i = n2 + 1; i < n3; ++i) {
                    MethodBinding methodBinding3 = methodBindingArray2[i];
                    if ((methodBinding2 != methodBindingArray3[i] || methodBinding2 == null) && !this.canSkipInheritedMethods(methodBinding, methodBinding3) && TypeBinding.notEquals(methodBinding.declaringClass, methodBinding3.declaringClass) && !this.isSkippableOrOverridden(methodBinding, methodBinding3, blArray, blArray2, blArray3, i) && !this.isSkippableOrOverridden(methodBinding3, methodBinding, blArray, blArray2, blArray3, n2)) continue;
                }
            }
            for (n2 = 0; n2 < n3; ++n2) {
                Object object3;
                int n6;
                MethodBinding methodBinding4 = methodBindingArray3[n2];
                if (blArray[n2]) continue;
                methodBinding = methodBindingArray2[n2];
                if (methodBinding4 == null) {
                    object2[++n4] = methodBinding;
                }
                for (n6 = n2 + 1; n6 < n3; ++n6) {
                    if (methodBindingArray3[n6] != null) continue;
                    object3 = methodBindingArray2[n6];
                    if (methodBinding4 == methodBindingArray3[n6] && methodBinding4 != null || this.canSkipInheritedMethods(methodBinding, (MethodBinding)object3)) continue;
                    object = this.findReplacedMethod(methodBinding, (MethodBinding)object3);
                    if (object != null) {
                        object2[++n4] = object;
                        blArray[n6] = true;
                        continue;
                    }
                    object = this.findReplacedMethod((MethodBinding)object3, methodBinding);
                    if (object != null) {
                        object2[++n4] = object;
                        blArray[n6] = true;
                        continue;
                    }
                    if (methodBinding4 != null) continue;
                    this.checkInheritedMethods(methodBinding, (MethodBinding)object3);
                }
                if (n4 == -1) continue;
                if (n4 > 0) {
                    n6 = n4 + 1;
                    if (n6 != n3) {
                        object3 = new boolean[n6];
                        object = new boolean[n6];
                        block10: for (int i = 0; i < n6; ++i) {
                            for (int j = 0; j < n3; ++j) {
                                if (object2[i] != methodBindingArray2[j]) continue;
                                object3[i] = blArray2[j];
                                object[i] = blArray3[j];
                                continue block10;
                            }
                        }
                    } else {
                        object3 = blArray2;
                        object = blArray3;
                    }
                    this.checkInheritedMethods((MethodBinding[])object2, n6, (boolean[])object3, (boolean[])object);
                } else if (bl && ((MethodBinding)object2[0]).isAbstract() && methodBinding4 == null) {
                    this.checkAbstractMethod((MethodBinding)object2[0]);
                }
                while (n4 >= 0) {
                    object2[n4--] = null;
                }
            }
        }
    }

    boolean isSkippableOrOverridden(MethodBinding methodBinding, MethodBinding methodBinding2, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, int n) {
        boolean bl = methodBinding.declaringClass.isInterface();
        boolean bl2 = methodBinding2.declaringClass.isInterface();
        if (!bl && bl2) {
            if (!methodBinding.isAbstract() && this.isParameterSubsignature(methodBinding, methodBinding2)) {
                blArray3[n] = false;
                return true;
            }
            if (this.isInterfaceMethodImplemented(methodBinding2, methodBinding, methodBinding2.declaringClass)) {
                blArray[n] = true;
                blArray2[n] = true;
                return true;
            }
        } else if (bl == bl2 && methodBinding.declaringClass.isCompatibleWith(methodBinding2.declaringClass) && this.isMethodSubsignature(methodBinding, methodBinding2)) {
            blArray[n] = true;
            blArray2[n] = true;
            return true;
        }
        return false;
    }

    MethodBinding findReplacedMethod(MethodBinding methodBinding, MethodBinding methodBinding2) {
        MethodBinding methodBinding3 = this.computeSubstituteMethod(methodBinding2, methodBinding);
        if (methodBinding3 != null && (!methodBinding.isAbstract() || methodBinding2.isAbstract() || methodBinding2.isDefaultMethod() && methodBinding.declaringClass.isClass()) && this.isSubstituteParameterSubsignature(methodBinding, methodBinding3)) {
            return methodBinding3;
        }
        return null;
    }

    void checkTypeVariableMethods(TypeParameter typeParameter) {
        char[][] cArray = this.inheritedMethods.keyTable;
        int n = cArray.length;
        block0: while (--n >= 0) {
            MethodBinding[] methodBindingArray;
            if (cArray[n] == null || (methodBindingArray = (MethodBinding[])this.inheritedMethods.valueTable[n]).length == 1) continue;
            int n2 = -1;
            MethodBinding[] methodBindingArray2 = new MethodBinding[methodBindingArray.length];
            int n3 = methodBindingArray.length;
            for (int i = 0; i < n3; ++i) {
                while (n2 >= 0) {
                    methodBindingArray2[n2--] = null;
                }
                MethodBinding methodBinding = methodBindingArray[i];
                if (methodBinding != null) {
                    methodBindingArray2[++n2] = methodBinding;
                    for (int j = i + 1; j < n3; ++j) {
                        MethodBinding methodBinding2 = methodBindingArray[j];
                        if (this.canSkipInheritedMethods(methodBinding, methodBinding2) || (methodBinding2 = this.computeSubstituteMethod(methodBinding2, methodBinding)) == null || !this.isSubstituteParameterSubsignature(methodBinding, methodBinding2)) continue;
                        methodBindingArray2[++n2] = methodBinding2;
                        methodBindingArray[j] = null;
                    }
                }
                if (n2 <= 0) continue;
                MethodBinding methodBinding3 = methodBindingArray2[0];
                int n4 = n2 + 1;
                while (--n4 > 0) {
                    MethodBinding methodBinding4 = methodBindingArray2[n4];
                    MethodBinding methodBinding5 = null;
                    MethodBinding methodBinding6 = null;
                    if (methodBinding3.declaringClass.isInterface()) {
                        methodBinding5 = methodBinding3;
                    } else if (methodBinding3.declaringClass.isClass()) {
                        methodBinding6 = methodBinding3;
                    }
                    if (methodBinding4.declaringClass.isInterface()) {
                        methodBinding5 = methodBinding4;
                    } else if (methodBinding4.declaringClass.isClass()) {
                        methodBinding6 = methodBinding4;
                    }
                    if (methodBinding5 != null && methodBinding6 != null && !this.isAsVisible(methodBinding6, methodBinding5)) {
                        this.problemReporter().inheritedMethodReducesVisibility(typeParameter, methodBinding6, new MethodBinding[]{methodBinding5});
                    }
                    if (this.areReturnTypesCompatible(methodBinding3, methodBinding4) || methodBinding3.declaringClass.isInterface() && methodBinding4.declaringClass.isInterface() && this.areReturnTypesCompatible(methodBinding4, methodBinding3)) continue;
                }
                if (n4 <= 0) continue;
                this.problemReporter().inheritedMethodsHaveIncompatibleReturnTypes(typeParameter, methodBindingArray2, n2 + 1);
                continue block0;
            }
        }
    }

    boolean detectInheritedNameClash(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (!methodBinding.areParameterErasuresEqual(methodBinding2)) {
            return false;
        }
        if (TypeBinding.notEquals(methodBinding.returnType.erasure(), methodBinding2.returnType.erasure())) {
            return false;
        }
        if (TypeBinding.notEquals(methodBinding.declaringClass.erasure(), methodBinding2.declaringClass.erasure())) {
            if (methodBinding.declaringClass.findSuperTypeOriginatingFrom(methodBinding2.declaringClass) != null) {
                return false;
            }
            if (methodBinding2.declaringClass.findSuperTypeOriginatingFrom(methodBinding.declaringClass) != null) {
                return false;
            }
        }
        this.problemReporter().inheritedMethodsHaveNameClash(this.type, methodBinding, methodBinding2);
        return true;
    }

    boolean detectNameClash(MethodBinding methodBinding, MethodBinding methodBinding2, boolean bl) {
        MethodBinding[] methodBindingArray;
        MethodBinding methodBinding3 = methodBinding2;
        MethodBinding methodBinding4 = methodBinding3.original();
        if (!methodBinding.areParameterErasuresEqual(methodBinding4)) {
            return false;
        }
        int n = 1;
        if (this.environment.globalOptions.complianceLevel == 0x320000L && TypeBinding.notEquals(methodBinding.returnType.erasure(), methodBinding4.returnType.erasure())) {
            n = 0;
        }
        if (!bl && (methodBindingArray = (MethodBinding[])this.currentMethods.get(methodBinding2.selector)).length > 1) {
            for (MethodBinding methodBinding5 : methodBindingArray) {
                if (methodBinding5 == methodBinding || !this.doesMethodOverride(methodBinding5, methodBinding2)) continue;
                methodBinding3 = methodBinding5;
                break;
            }
        }
        if (!methodBinding.areParameterErasuresEqual(methodBinding4 = methodBinding3.original())) {
            return false;
        }
        methodBinding4 = methodBinding2.original();
        this.problemReporter(methodBinding).methodNameClash(methodBinding, methodBinding2.declaringClass.isRawType() ? methodBinding2 : methodBinding4, n);
        return n != 0;
    }

    boolean doTypeVariablesClash(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return methodBinding.typeVariables != Binding.NO_TYPE_VARIABLES && !(methodBinding2 instanceof ParameterizedGenericMethodBinding);
    }

    @Override
    SimpleSet findSuperinterfaceCollisions(ReferenceBinding referenceBinding, ReferenceBinding[] referenceBindingArray) {
        int n;
        int n2;
        int n3;
        ReferenceBinding referenceBinding2;
        ReferenceBinding[] referenceBindingArray2 = null;
        int n4 = 0;
        ReferenceBinding[] referenceBindingArray3 = referenceBindingArray;
        if (referenceBindingArray3 != Binding.NO_SUPERINTERFACES) {
            n4 = referenceBindingArray3.length;
            referenceBindingArray2 = referenceBindingArray3;
        }
        boolean bl = this.type.isHierarchyInconsistent();
        for (referenceBinding2 = referenceBinding; referenceBinding2 != null && referenceBinding2.isValidBinding(); referenceBinding2 = referenceBinding2.superclass()) {
            bl |= referenceBinding2.isHierarchyInconsistent();
            referenceBindingArray3 = referenceBinding2.superInterfaces();
            if (referenceBindingArray3 == Binding.NO_SUPERINTERFACES) continue;
            if (referenceBindingArray2 == null) {
                referenceBindingArray2 = referenceBindingArray3;
                n4 = referenceBindingArray2.length;
                continue;
            }
            n3 = referenceBindingArray3.length;
            if (n4 + n3 >= referenceBindingArray2.length) {
                ReferenceBinding[] referenceBindingArray4 = referenceBindingArray2;
                referenceBindingArray2 = new ReferenceBinding[n4 + n3 + 5];
                System.arraycopy(referenceBindingArray4, 0, referenceBindingArray2, 0, n4);
            }
            block1: for (n2 = 0; n2 < n3; ++n2) {
                ReferenceBinding referenceBinding3 = referenceBindingArray3[n2];
                for (int i = 0; i < n4; ++i) {
                    if (TypeBinding.equalsEquals(referenceBinding3, referenceBindingArray2[i])) continue block1;
                }
                referenceBindingArray2[n4++] = referenceBinding3;
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            referenceBinding2 = referenceBindingArray2[n3];
            if (!referenceBinding2.isValidBinding()) continue;
            bl |= referenceBinding2.isHierarchyInconsistent();
            referenceBindingArray3 = referenceBinding2.superInterfaces();
            if (referenceBindingArray3 == Binding.NO_SUPERINTERFACES) continue;
            n2 = referenceBindingArray3.length;
            if (n4 + n2 >= referenceBindingArray2.length) {
                ReferenceBinding[] referenceBindingArray5 = referenceBindingArray2;
                referenceBindingArray2 = new ReferenceBinding[n4 + n2 + 5];
                System.arraycopy(referenceBindingArray5, 0, referenceBindingArray2, 0, n4);
            }
            block4: for (int i = 0; i < n2; ++i) {
                ReferenceBinding referenceBinding4 = referenceBindingArray3[i];
                for (n = 0; n < n4; ++n) {
                    if (TypeBinding.equalsEquals(referenceBinding4, referenceBindingArray2[n])) continue block4;
                }
                referenceBindingArray2[n4++] = referenceBinding4;
            }
        }
        if (!bl) {
            return null;
        }
        SimpleSet simpleSet = null;
        for (n2 = 0; n2 < n4; ++n2) {
            ReferenceBinding referenceBinding5 = referenceBindingArray2[n2];
            if (!referenceBinding5.isValidBinding()) continue;
            TypeBinding typeBinding = referenceBinding5.erasure();
            for (n = n2 + 1; n < n4; ++n) {
                ReferenceBinding referenceBinding6 = referenceBindingArray2[n];
                if (!referenceBinding6.isValidBinding() || !TypeBinding.equalsEquals(referenceBinding6.erasure(), typeBinding)) continue;
                if (simpleSet == null) {
                    simpleSet = new SimpleSet(n4);
                }
                simpleSet.add(referenceBindingArray2[n2]);
                simpleSet.add(referenceBindingArray2[n]);
            }
        }
        return simpleSet;
    }

    boolean isAcceptableReturnTypeOverride(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (methodBinding2.declaringClass.isRawType()) {
            return true;
        }
        MethodBinding methodBinding3 = methodBinding2.original();
        TypeBinding typeBinding = methodBinding3.returnType.leafComponentType();
        if (typeBinding.isParameterizedTypeWithActualArguments()) {
            return !methodBinding.returnType.leafComponentType().isRawType();
        }
        TypeBinding typeBinding2 = methodBinding.returnType.leafComponentType();
        switch (typeBinding2.kind()) {
            case 4100: {
                if (!TypeBinding.equalsEquals(typeBinding2, methodBinding2.returnType.leafComponentType())) break;
                return true;
            }
        }
        return !typeBinding.isTypeVariable() || ((TypeVariableBinding)typeBinding).declaringElement != methodBinding3;
    }

    @Override
    boolean isInterfaceMethodImplemented(MethodBinding methodBinding, MethodBinding methodBinding2, ReferenceBinding referenceBinding) {
        if (methodBinding.original() != methodBinding && methodBinding2.declaringClass.isInterface()) {
            return false;
        }
        if ((methodBinding = this.computeSubstituteMethod(methodBinding, methodBinding2)) == null || !this.doesMethodOverride(methodBinding2, methodBinding)) {
            return false;
        }
        return TypeBinding.equalsEquals(methodBinding.returnType, methodBinding2.returnType) || TypeBinding.notEquals(this.type, methodBinding2.declaringClass) && !methodBinding2.declaringClass.isInterface() && this.areReturnTypesCompatible(methodBinding2, methodBinding);
    }

    @Override
    public boolean isMethodSubsignature(MethodBinding methodBinding, MethodBinding methodBinding2) {
        MethodBinding methodBinding3;
        if (!CharOperation.equals(methodBinding.selector, methodBinding2.selector)) {
            return false;
        }
        if (methodBinding.declaringClass.isParameterizedType()) {
            methodBinding = methodBinding.original();
        }
        return this.isParameterSubsignature(methodBinding, (methodBinding3 = methodBinding.findOriginalInheritedMethod(methodBinding2)) == null ? methodBinding2 : methodBinding3);
    }

    boolean isUnsafeReturnTypeOverride(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (TypeBinding.equalsEquals(methodBinding.returnType, methodBinding2.returnType.erasure())) {
            TypeBinding[] typeBindingArray = methodBinding.parameters;
            TypeBinding[] typeBindingArray2 = methodBinding2.parameters;
            int n = typeBindingArray.length;
            for (int i = 0; i < n; ++i) {
                if (MethodVerifier15.areTypesEqual(typeBindingArray[i], typeBindingArray2[i])) continue;
                return true;
            }
        }
        return methodBinding.typeVariables == Binding.NO_TYPE_VARIABLES && methodBinding2.original().typeVariables != Binding.NO_TYPE_VARIABLES && methodBinding.returnType.erasure().findSuperTypeOriginatingFrom(methodBinding2.returnType.erasure()) != null;
    }

    @Override
    boolean reportIncompatibleReturnTypeError(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (this.isUnsafeReturnTypeOverride(methodBinding, methodBinding2)) {
            this.problemReporter(methodBinding).unsafeReturnTypeOverride(methodBinding, methodBinding2, this.type);
            return false;
        }
        return super.reportIncompatibleReturnTypeError(methodBinding, methodBinding2);
    }

    @Override
    void verify() {
        if (this.type.isAnnotationType()) {
            this.type.detectAnnotationCycle();
        }
        super.verify();
        this.reportRawReferences();
        int n = this.type.typeVariables.length;
        while (--n >= 0) {
            TypeVariableBinding typeVariableBinding = this.type.typeVariables[n];
            if (typeVariableBinding.superInterfaces == Binding.NO_SUPERINTERFACES || typeVariableBinding.superInterfaces.length == 1 && typeVariableBinding.superclass.id == 1) continue;
            this.currentMethods = new HashtableOfObject(0);
            ReferenceBinding referenceBinding = typeVariableBinding.superclass();
            if (referenceBinding.kind() == 4100) {
                referenceBinding = (ReferenceBinding)referenceBinding.erasure();
            }
            ReferenceBinding[] referenceBindingArray = typeVariableBinding.superInterfaces();
            ReferenceBinding[] referenceBindingArray2 = new ReferenceBinding[referenceBindingArray.length];
            int n2 = referenceBindingArray.length;
            while (--n2 >= 0) {
                referenceBindingArray2[n2] = referenceBindingArray[n2].kind() == 4100 ? (ReferenceBinding)referenceBindingArray[n2].erasure() : referenceBindingArray[n2];
            }
            this.computeInheritedMethods(referenceBinding, referenceBindingArray2);
            this.checkTypeVariableMethods(this.type.scope.referenceContext.typeParameters[n]);
        }
    }
}

