#ifndef _EFL_INPUT_EVENT_EO_H_
#define _EFL_INPUT_EVENT_EO_H_

#ifndef _EFL_INPUT_EVENT_EO_CLASS_TYPE
#define _EFL_INPUT_EVENT_EO_CLASS_TYPE

typedef Eo Efl_Input_Event;

#endif

#ifndef _EFL_INPUT_EVENT_EO_TYPES
#define _EFL_INPUT_EVENT_EO_TYPES


#endif
/**
 * @brief Represents a generic event data.
 *
 * @note Most Efl Events do not carry Efl Objects, rather simple data
 * structures. This class is intended to carry more complex event data, such as
 * pointer events.
 *
 * @since 1.23
 *
 * @ingroup Efl_Input_Event
 */
#define EFL_INPUT_EVENT_MIXIN efl_input_event_mixin_get()

EWAPI const Efl_Class *efl_input_event_mixin_get(void);

/**
 * @brief The time at which an event was generated.
 *
 * If the event is generated by a server (eg. X.org or Wayland), then the time
 * may be set by the server. Usually this time will be based on the monotonic
 * clock, if available, but this class can not guarantee it.
 *
 * Call this when generating events manually.
 *
 * @param[in] obj The object.
 * @param[in] ms Time in milliseconds when the event happened.
 *
 * @since 1.23
 *
 * @ingroup Efl_Input_Event
 */
EOAPI void efl_input_timestamp_set(Eo *obj, double ms);

/**
 * @brief The time at which an event was generated.
 *
 * If the event is generated by a server (eg. X.org or Wayland), then the time
 * may be set by the server. Usually this time will be based on the monotonic
 * clock, if available, but this class can not guarantee it.
 *
 * @param[in] obj The object.
 *
 * @return Time in milliseconds when the event happened.
 *
 * @since 1.23
 *
 * @ingroup Efl_Input_Event
 */
EOAPI double efl_input_timestamp_get(const Eo *obj);

/** Resets the internal data to 0 or default values.
 *
 * @since 1.23
 *
 * @ingroup Efl_Input_Event
 */
EOAPI void efl_input_reset(Eo *obj);

/**
 * @brief Input device that originated this event.
 *
 * @param[in] obj The object.
 * @param[in] dev Input device origin
 *
 * @since 1.23
 *
 * @ingroup Efl_Input_Event
 */
EOAPI void efl_input_device_set(Eo *obj, Efl_Input_Device *dev);

/**
 * @brief Input device that originated this event.
 *
 * @param[in] obj The object.
 *
 * @return Input device origin
 *
 * @since 1.23
 *
 * @ingroup Efl_Input_Event
 */
EOAPI Efl_Input_Device *efl_input_device_get(const Eo *obj);

/**
 * @brief Extra flags for this event, may be changed by the user.
 *
 * @param[in] obj The object.
 * @param[in] flags Input event flags
 *
 * @since 1.23
 *
 * @ingroup Efl_Input_Event
 */
EOAPI void efl_input_event_flags_set(Eo *obj, Efl_Input_Flags flags);

/**
 * @brief Extra flags for this event, may be changed by the user.
 *
 * @param[in] obj The object.
 *
 * @return Input event flags
 *
 * @since 1.23
 *
 * @ingroup Efl_Input_Event
 */
EOAPI Efl_Input_Flags efl_input_event_flags_get(const Eo *obj);

/**
 * @brief @c true if @ref efl_input_event_flags_get indicates the event is on
 * hold.
 *
 * @param[in] obj The object.
 * @param[in] val @c true if the event is on hold, @c false otherwise
 *
 * @since 1.23
 *
 * @ingroup Efl_Input_Event
 */
EOAPI void efl_input_processed_set(Eo *obj, Eina_Bool val);

/**
 * @brief @c true if @ref efl_input_event_flags_get indicates the event is on
 * hold.
 *
 * @param[in] obj The object.
 *
 * @return @c true if the event is on hold, @c false otherwise
 *
 * @since 1.23
 *
 * @ingroup Efl_Input_Event
 */
EOAPI Eina_Bool efl_input_processed_get(const Eo *obj);

/**
 * @brief @c true if @ref efl_input_event_flags_get indicates the event
 * happened while scrolling.
 *
 * @param[in] obj The object.
 * @param[in] val @c true if the event happened while scrolling, @c false
 * otherwise
 *
 * @since 1.23
 *
 * @ingroup Efl_Input_Event
 */
EOAPI void efl_input_scrolling_set(Eo *obj, Eina_Bool val);

/**
 * @brief @c true if @ref efl_input_event_flags_get indicates the event
 * happened while scrolling.
 *
 * @param[in] obj The object.
 *
 * @return @c true if the event happened while scrolling, @c false otherwise
 *
 * @since 1.23
 *
 * @ingroup Efl_Input_Event
 */
EOAPI Eina_Bool efl_input_scrolling_get(const Eo *obj);

/**
 * @brief @c true if the event was fake, not triggered by real hardware.
 *
 * @param[in] obj The object.
 *
 * @return @c true if the event was not from real hardware, @c false otherwise
 *
 * @since 1.23
 *
 * @ingroup Efl_Input_Event
 */
EOAPI Eina_Bool efl_input_fake_get(const Eo *obj);

#endif
