/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util.logging;

import java.io.File;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.config.PathsAndFiles;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.util.logging.JavaConsole;

public class LogConfig {
    private String icedteaLogDir;
    private boolean enableLogging;
    private boolean enableHeaders;
    private boolean logToFile;
    private boolean logClientAppToFile;
    private boolean logToStreams;
    private boolean logToSysLog;
    private boolean legacyLogaAsedFileLog;

    private LogConfig() {
        DeploymentConfiguration config = JNLPRuntime.getConfiguration();
        this.enableLogging = Boolean.parseBoolean(config.getProperty("deployment.log"));
        this.enableHeaders = Boolean.parseBoolean(config.getProperty("deployment.log.headers"));
        this.logToFile = Boolean.parseBoolean(config.getProperty("deployment.log.file"));
        this.logToStreams = Boolean.parseBoolean(config.getProperty("deployment.log.stdstreams"));
        this.logToSysLog = Boolean.parseBoolean(config.getProperty("deployment.log.system"));
        this.legacyLogaAsedFileLog = Boolean.parseBoolean(config.getProperty("deployment.log.file.legacylog"));
        this.logClientAppToFile = Boolean.parseBoolean(config.getProperty("deployment.log.file.clientapp"));
        this.icedteaLogDir = PathsAndFiles.LOG_DIR.getFullPath();
        if (this.icedteaLogDir != null) {
            File f = new File(this.icedteaLogDir);
            if (f.isDirectory() || f.mkdirs()) {
                this.icedteaLogDir = this.icedteaLogDir + File.separator;
            } else {
                this.enableLogging = false;
            }
        } else {
            this.enableLogging = false;
        }
    }

    public static LogConfig getLogConfig() {
        return LogConfigHolder.INSTANCE;
    }

    static synchronized void resetLogConfig() {
        LogConfigHolder.INSTANCE = new LogConfig();
    }

    public String getIcedteaLogDir() {
        return this.icedteaLogDir;
    }

    public boolean isEnableLogging() {
        return this.enableLogging;
    }

    public boolean isLogToFile() {
        return this.logToFile;
    }

    public boolean isLogToStreams() {
        return this.logToStreams;
    }

    public boolean isLogToSysLog() {
        return this.logToSysLog;
    }

    public boolean isEnableHeaders() {
        return this.enableHeaders;
    }

    void setEnableHeaders(boolean enableHeaders) {
        this.enableHeaders = enableHeaders;
    }

    void setEnableLogging(boolean enableLogging) {
        this.enableLogging = enableLogging;
    }

    void setIcedteaLogDir(String icedteaLogDir) {
        this.icedteaLogDir = icedteaLogDir;
    }

    void setLogToFile(boolean logToFile) {
        this.logToFile = logToFile;
    }

    void setLogToStreams(boolean logToStreams) {
        this.logToStreams = logToStreams;
    }

    void setLogToSysLog(boolean logToSysLog) {
        this.logToSysLog = logToSysLog;
    }

    boolean isLogToConsole() {
        return JavaConsole.isEnabled();
    }

    boolean isLegacyLogBasedFileLog() {
        return this.legacyLogaAsedFileLog;
    }

    boolean setLegacyLogBasedFileLog(boolean b) {
        this.legacyLogaAsedFileLog = b;
        return this.legacyLogaAsedFileLog;
    }

    void serLogToFileForClientApp(boolean b) {
        this.logClientAppToFile = b;
    }

    boolean isLogToFileForClientApp() {
        return this.logClientAppToFile;
    }

    private static class LogConfigHolder {
        private static volatile LogConfig INSTANCE = new LogConfig();

        private LogConfigHolder() {
        }
    }
}

