/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;

public class MotifMenuUI
extends BasicMenuUI {
    public static ComponentUI createUI(JComponent x) {
        return new MotifMenuUI();
    }

    @Override
    protected ChangeListener createChangeListener(JComponent c) {
        return new MotifChangeHandler((JMenu)c, this);
    }

    private boolean popupIsOpen(JMenu m, MenuElement[] me) {
        JPopupMenu pm = m.getPopupMenu();
        for (int i = me.length - 1; i >= 0; --i) {
            if (me[i].getComponent() != pm) continue;
            return true;
        }
        return false;
    }

    @Override
    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new MouseInputHandler();
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            JMenu menu = (JMenu)e.getComponent();
            if (menu.isEnabled()) {
                MenuElement[] path;
                if (menu.isTopLevelMenu()) {
                    if (menu.isSelected()) {
                        manager.clearSelectedPath();
                    } else {
                        Container cnt = menu.getParent();
                        if (cnt != null && cnt instanceof JMenuBar) {
                            MenuElement[] me = new MenuElement[]{(MenuElement)((Object)cnt), menu};
                            manager.setSelectedPath(me);
                        }
                    }
                }
                if ((path = MotifMenuUI.this.getPath()).length > 0) {
                    MenuElement[] newPath = new MenuElement[path.length + 1];
                    System.arraycopy(path, 0, newPath, 0, path.length);
                    newPath[path.length] = menu.getPopupMenu();
                    manager.setSelectedPath(newPath);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            JMenuItem menuItem = (JMenuItem)e.getComponent();
            Point p = e.getPoint();
            if (p.x < 0 || p.x >= menuItem.getWidth() || p.y < 0 || p.y >= menuItem.getHeight()) {
                manager.processMouseEvent(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            MenuSelectionManager.defaultManager().processMouseEvent(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    public class MotifChangeHandler
    extends BasicMenuUI.ChangeHandler {
        public MotifChangeHandler(JMenu m, MotifMenuUI ui) {
            super(MotifMenuUI.this, m, ui);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JMenuItem c = (JMenuItem)e.getSource();
            if (c.isArmed() || c.isSelected()) {
                c.setBorderPainted(true);
            } else {
                c.setBorderPainted(false);
            }
            super.stateChanged(e);
        }
    }
}

