/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.ObjectStreamException;
import java.lang.reflect.Array;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;

public class ArrayType<T>
extends OpenType<T> {
    static final long serialVersionUID = 720504429830309770L;
    private int dimension;
    private OpenType<?> elementType;
    private boolean primitiveArray;
    private transient Integer myHashCode = null;
    private transient String myToString = null;
    private static final int PRIMITIVE_WRAPPER_NAME_INDEX = 0;
    private static final int PRIMITIVE_TYPE_NAME_INDEX = 1;
    private static final int PRIMITIVE_TYPE_KEY_INDEX = 2;
    private static final int PRIMITIVE_OPEN_TYPE_INDEX = 3;
    private static final Object[][] PRIMITIVE_ARRAY_TYPES = new Object[][]{{Boolean.class.getName(), Boolean.TYPE.getName(), "Z", SimpleType.BOOLEAN}, {Character.class.getName(), Character.TYPE.getName(), "C", SimpleType.CHARACTER}, {Byte.class.getName(), Byte.TYPE.getName(), "B", SimpleType.BYTE}, {Short.class.getName(), Short.TYPE.getName(), "S", SimpleType.SHORT}, {Integer.class.getName(), Integer.TYPE.getName(), "I", SimpleType.INTEGER}, {Long.class.getName(), Long.TYPE.getName(), "J", SimpleType.LONG}, {Float.class.getName(), Float.TYPE.getName(), "F", SimpleType.FLOAT}, {Double.class.getName(), Double.TYPE.getName(), "D", SimpleType.DOUBLE}};

    static boolean isPrimitiveContentType(String primitiveKey) {
        for (Object[] typeDescr : PRIMITIVE_ARRAY_TYPES) {
            if (!typeDescr[2].equals(primitiveKey)) continue;
            return true;
        }
        return false;
    }

    static String getPrimitiveTypeKey(String elementClassName) {
        for (Object[] typeDescr : PRIMITIVE_ARRAY_TYPES) {
            if (!elementClassName.equals(typeDescr[0])) continue;
            return (String)typeDescr[2];
        }
        return null;
    }

    static String getPrimitiveTypeName(String elementClassName) {
        for (Object[] typeDescr : PRIMITIVE_ARRAY_TYPES) {
            if (!elementClassName.equals(typeDescr[0])) continue;
            return (String)typeDescr[1];
        }
        return null;
    }

    static SimpleType<?> getPrimitiveOpenType(String primitiveTypeName) {
        for (Object[] typeDescr : PRIMITIVE_ARRAY_TYPES) {
            if (!primitiveTypeName.equals(typeDescr[1])) continue;
            return (SimpleType)typeDescr[3];
        }
        return null;
    }

    public ArrayType(int dimension, OpenType<?> elementType) throws OpenDataException {
        super(ArrayType.buildArrayClassName(dimension, elementType), ArrayType.buildArrayClassName(dimension, elementType), ArrayType.buildArrayDescription(dimension, elementType));
        if (elementType.isArray()) {
            ArrayType at = (ArrayType)elementType;
            this.dimension = at.getDimension() + dimension;
            this.elementType = at.getElementOpenType();
            this.primitiveArray = at.isPrimitiveArray();
        } else {
            this.dimension = dimension;
            this.elementType = elementType;
            this.primitiveArray = false;
        }
    }

    public ArrayType(SimpleType<?> elementType, boolean primitiveArray) throws OpenDataException {
        super(ArrayType.buildArrayClassName(1, elementType, primitiveArray), ArrayType.buildArrayClassName(1, elementType, primitiveArray), ArrayType.buildArrayDescription(1, elementType, primitiveArray), true);
        this.dimension = 1;
        this.elementType = elementType;
        this.primitiveArray = primitiveArray;
    }

    ArrayType(String className, String typeName, String description, int dimension, OpenType<?> elementType, boolean primitiveArray) {
        super(className, typeName, description, true);
        this.dimension = dimension;
        this.elementType = elementType;
        this.primitiveArray = primitiveArray;
    }

    private static String buildArrayClassName(int dimension, OpenType<?> elementType) throws OpenDataException {
        boolean isPrimitiveArray = false;
        if (elementType.isArray()) {
            isPrimitiveArray = ((ArrayType)elementType).isPrimitiveArray();
        }
        return ArrayType.buildArrayClassName(dimension, elementType, isPrimitiveArray);
    }

    private static String buildArrayClassName(int dimension, OpenType<?> elementType, boolean isPrimitiveArray) throws OpenDataException {
        if (dimension < 1) {
            throw new IllegalArgumentException("Value of argument dimension must be greater than 0");
        }
        StringBuilder result = new StringBuilder();
        String elementClassName = elementType.getClassName();
        for (int i = 1; i <= dimension; ++i) {
            result.append('[');
        }
        if (elementType.isArray()) {
            result.append(elementClassName);
        } else if (isPrimitiveArray) {
            String key = ArrayType.getPrimitiveTypeKey(elementClassName);
            if (key == null) {
                throw new OpenDataException("Element type is not primitive: " + elementClassName);
            }
            result.append(key);
        } else {
            result.append("L");
            result.append(elementClassName);
            result.append(';');
        }
        return result.toString();
    }

    private static String buildArrayDescription(int dimension, OpenType<?> elementType) throws OpenDataException {
        boolean isPrimitiveArray = false;
        if (elementType.isArray()) {
            isPrimitiveArray = ((ArrayType)elementType).isPrimitiveArray();
        }
        return ArrayType.buildArrayDescription(dimension, elementType, isPrimitiveArray);
    }

    private static String buildArrayDescription(int dimension, OpenType<?> elementType, boolean isPrimitiveArray) throws OpenDataException {
        if (elementType.isArray()) {
            ArrayType at = (ArrayType)elementType;
            dimension += at.getDimension();
            elementType = at.getElementOpenType();
            isPrimitiveArray = at.isPrimitiveArray();
        }
        StringBuilder result = new StringBuilder(dimension + "-dimension array of ");
        String elementClassName = elementType.getClassName();
        if (isPrimitiveArray) {
            String primitiveType = ArrayType.getPrimitiveTypeName(elementClassName);
            if (primitiveType == null) {
                throw new OpenDataException("Element is not a primitive type: " + elementClassName);
            }
            result.append(primitiveType);
        } else {
            result.append(elementClassName);
        }
        return result.toString();
    }

    public int getDimension() {
        return this.dimension;
    }

    public OpenType<?> getElementOpenType() {
        return this.elementType;
    }

    public boolean isPrimitiveArray() {
        return this.primitiveArray;
    }

    @Override
    public boolean isValue(Object obj) {
        if (obj == null) {
            return false;
        }
        Class<?> objClass = obj.getClass();
        String objClassName = objClass.getName();
        if (!objClass.isArray()) {
            return false;
        }
        if (this.getClassName().equals(objClassName)) {
            return true;
        }
        if (this.elementType.getClassName().equals(TabularData.class.getName()) || this.elementType.getClassName().equals(CompositeData.class.getName())) {
            int[] dims;
            boolean isTabular = this.elementType.getClassName().equals(TabularData.class.getName());
            Class elementClass = isTabular ? TabularData.class : CompositeData.class;
            Class<?> targetClass = Array.newInstance(elementClass, dims = new int[this.getDimension()]).getClass();
            if (!targetClass.isAssignableFrom(objClass)) {
                return false;
            }
            return this.checkElementsType((Object[])obj, this.dimension);
        }
        return false;
    }

    private boolean checkElementsType(Object[] x_dim_Array, int dim) {
        if (dim > 1) {
            for (int i = 0; i < x_dim_Array.length; ++i) {
                if (this.checkElementsType((Object[])x_dim_Array[i], dim - 1)) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < x_dim_Array.length; ++i) {
            if (x_dim_Array[i] == null || this.getElementOpenType().isValue(x_dim_Array[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean isAssignableFrom(OpenType<?> ot) {
        if (!(ot instanceof ArrayType)) {
            return false;
        }
        ArrayType at = (ArrayType)ot;
        return at.getDimension() == this.getDimension() && at.isPrimitiveArray() == this.isPrimitiveArray() && at.getElementOpenType().isAssignableFrom(this.getElementOpenType());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArrayType)) {
            return false;
        }
        ArrayType other = (ArrayType)obj;
        if (this.dimension != other.dimension) {
            return false;
        }
        if (!this.elementType.equals(other.elementType)) {
            return false;
        }
        return this.primitiveArray == other.primitiveArray;
    }

    @Override
    public int hashCode() {
        if (this.myHashCode == null) {
            int value = 0;
            value += this.dimension;
            value += this.elementType.hashCode();
            this.myHashCode = value += Boolean.valueOf(this.primitiveArray).hashCode();
        }
        return this.myHashCode;
    }

    @Override
    public String toString() {
        if (this.myToString == null) {
            this.myToString = this.getClass().getName() + "(name=" + this.getTypeName() + ",dimension=" + this.dimension + ",elementType=" + this.elementType + ",primitiveArray=" + this.primitiveArray + ")";
        }
        return this.myToString;
    }

    public static <E> ArrayType<E[]> getArrayType(OpenType<E> elementType) throws OpenDataException {
        return new ArrayType<E[]>(1, elementType);
    }

    public static <T> ArrayType<T> getPrimitiveArrayType(Class<T> arrayClass) {
        if (!arrayClass.isArray()) {
            throw new IllegalArgumentException("arrayClass must be an array");
        }
        int n = 1;
        Class<?> componentType = arrayClass.getComponentType();
        while (componentType.isArray()) {
            ++n;
            componentType = componentType.getComponentType();
        }
        String componentTypeName = componentType.getName();
        if (!componentType.isPrimitive()) {
            throw new IllegalArgumentException("component type of the array must be a primitive type");
        }
        SimpleType<?> simpleType = ArrayType.getPrimitiveOpenType(componentTypeName);
        try {
            ArrayType<T> at = new ArrayType<T>(simpleType, true);
            if (n > 1) {
                at = new ArrayType<T>(n - 1, at);
            }
            return at;
        }
        catch (OpenDataException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.primitiveArray) {
            return this.convertFromWrapperToPrimitiveTypes();
        }
        return this;
    }

    private <T> ArrayType<T> convertFromWrapperToPrimitiveTypes() {
        String cn = this.getClassName();
        String tn = this.getTypeName();
        String d = this.getDescription();
        for (Object[] typeDescr : PRIMITIVE_ARRAY_TYPES) {
            if (cn.indexOf((String)typeDescr[0]) == -1) continue;
            cn = cn.replaceFirst("L" + typeDescr[0] + ";", (String)typeDescr[2]);
            tn = tn.replaceFirst("L" + typeDescr[0] + ";", (String)typeDescr[2]);
            d = d.replaceFirst((String)typeDescr[0], (String)typeDescr[1]);
            break;
        }
        return new ArrayType<T>(cn, tn, d, this.dimension, this.elementType, this.primitiveArray);
    }

    private Object writeReplace() throws ObjectStreamException {
        if (this.primitiveArray) {
            return this.convertFromPrimitiveToWrapperTypes();
        }
        return this;
    }

    private <T> ArrayType<T> convertFromPrimitiveToWrapperTypes() {
        String cn = this.getClassName();
        String tn = this.getTypeName();
        String d = this.getDescription();
        for (Object[] typeDescr : PRIMITIVE_ARRAY_TYPES) {
            if (cn.indexOf((String)typeDescr[2]) == -1) continue;
            cn = cn.replaceFirst((String)typeDescr[2], "L" + typeDescr[0] + ";");
            tn = tn.replaceFirst((String)typeDescr[2], "L" + typeDescr[0] + ";");
            d = d.replaceFirst((String)typeDescr[1], (String)typeDescr[0]);
            break;
        }
        return new ArrayType<T>(cn, tn, d, this.dimension, this.elementType, this.primitiveArray);
    }
}

