/*
 * Decompiled with CFR 0.152.
 */
package sun.net;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TelnetOutputStream
extends BufferedOutputStream {
    boolean stickyCRLF = false;
    boolean seenCR = false;
    public boolean binaryMode = false;

    public TelnetOutputStream(OutputStream fd, boolean binary) {
        super(fd);
        this.binaryMode = binary;
    }

    public void setStickyCRLF(boolean on) {
        this.stickyCRLF = on;
    }

    @Override
    public void write(int c) throws IOException {
        if (this.binaryMode) {
            super.write(c);
            return;
        }
        if (this.seenCR) {
            if (c != 10) {
                super.write(0);
            }
            super.write(c);
            if (c != 13) {
                this.seenCR = false;
            }
        } else {
            if (c == 10) {
                super.write(13);
                super.write(10);
                return;
            }
            if (c == 13) {
                if (this.stickyCRLF) {
                    this.seenCR = true;
                } else {
                    super.write(13);
                    c = 0;
                }
            }
            super.write(c);
        }
    }

    @Override
    public void write(byte[] bytes, int off, int length) throws IOException {
        if (this.binaryMode) {
            super.write(bytes, off, length);
            return;
        }
        while (--length >= 0) {
            this.write(bytes[off++]);
        }
    }
}

