/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect;

public class SignatureIterator {
    private final String sig;
    private int idx;

    public SignatureIterator(String sig) {
        this.sig = sig;
        this.reset();
    }

    public void reset() {
        this.idx = 1;
    }

    public boolean atEnd() {
        return this.sig.charAt(this.idx) == ')';
    }

    public String next() {
        if (this.atEnd()) {
            return null;
        }
        char c = this.sig.charAt(this.idx);
        if (c != '[' && c != 'L') {
            ++this.idx;
            return new String(new char[]{c});
        }
        int endIdx = this.idx;
        if (c == '[') {
            while ((c = this.sig.charAt(endIdx)) == '[') {
                ++endIdx;
            }
        }
        if (c == 'L') {
            while (this.sig.charAt(endIdx) != ';') {
                ++endIdx;
            }
        }
        int beginIdx = this.idx;
        this.idx = endIdx + 1;
        return this.sig.substring(beginIdx, this.idx);
    }

    public String returnType() {
        if (!this.atEnd()) {
            throw new InternalError("Illegal use of SignatureIterator");
        }
        return this.sig.substring(this.idx + 1, this.sig.length());
    }
}

