/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.cert.CRLReason;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.Extension;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import sun.misc.IOUtils;
import sun.security.action.GetIntegerAction;
import sun.security.provider.certpath.CertId;
import sun.security.provider.certpath.OCSPRequest;
import sun.security.provider.certpath.OCSPResponse;
import sun.security.util.Debug;
import sun.security.x509.AccessDescription;
import sun.security.x509.AuthorityInfoAccessExtension;
import sun.security.x509.GeneralName;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.URIName;
import sun.security.x509.X509CertImpl;

public final class OCSP {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    private static final int CONNECT_TIMEOUT = OCSP.initializeTimeout();

    private static int initializeTimeout() {
        Integer tmp = AccessController.doPrivileged(new GetIntegerAction("com.sun.security.ocsp.timeout"));
        if (tmp == null || tmp < 0) {
            return 15000;
        }
        return tmp * 1000;
    }

    private OCSP() {
    }

    public static RevocationStatus check(X509Certificate cert, X509Certificate issuerCert, URI responderURI, X509Certificate responderCert, Date date) throws IOException, CertPathValidatorException {
        return OCSP.check(cert, issuerCert, responderURI, responderCert, date, Collections.emptyList(), "generic");
    }

    public static RevocationStatus check(X509Certificate cert, X509Certificate issuerCert, URI responderURI, X509Certificate responderCert, Date date, List<Extension> extensions, String variant) throws IOException, CertPathValidatorException {
        return OCSP.check(cert, responderURI, null, issuerCert, responderCert, date, extensions, variant);
    }

    public static RevocationStatus check(X509Certificate cert, URI responderURI, TrustAnchor anchor, X509Certificate issuerCert, X509Certificate responderCert, Date date, List<Extension> extensions, String variant) throws IOException, CertPathValidatorException {
        CertId certId;
        try {
            X509CertImpl certImpl = X509CertImpl.toImpl(cert);
            certId = new CertId(issuerCert, certImpl.getSerialNumberObject());
        }
        catch (IOException | CertificateException e) {
            throw new CertPathValidatorException("Exception while encoding OCSPRequest", e);
        }
        OCSPResponse ocspResponse = OCSP.check(Collections.singletonList(certId), responderURI, new OCSPResponse.IssuerInfo(anchor, issuerCert), responderCert, date, extensions, variant);
        return ocspResponse.getSingleResponse(certId);
    }

    static OCSPResponse check(List<CertId> certIds, URI responderURI, OCSPResponse.IssuerInfo issuerInfo, X509Certificate responderCert, Date date, List<Extension> extensions, String variant) throws IOException, CertPathValidatorException {
        byte[] nonce = null;
        for (Extension ext : extensions) {
            if (!ext.getId().equals(PKIXExtensions.OCSPNonce_Id.toString())) continue;
            nonce = ext.getValue();
        }
        OCSPResponse ocspResponse = null;
        try {
            byte[] response = OCSP.getOCSPBytes(certIds, responderURI, extensions);
            ocspResponse = new OCSPResponse(response);
            ocspResponse.verify(certIds, issuerInfo, responderCert, date, nonce, variant);
        }
        catch (IOException ioe) {
            throw new CertPathValidatorException("Unable to determine revocation status due to network error", ioe, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
        }
        return ocspResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getOCSPBytes(List<CertId> certIds, URI responderURI, List<Extension> extensions) throws IOException {
        OCSPRequest request = new OCSPRequest(certIds, extensions);
        byte[] bytes = request.encodeBytes();
        InputStream in = null;
        OutputStream out = null;
        byte[] response = null;
        try {
            URL url = responderURI.toURL();
            if (debug != null) {
                debug.println("connecting to OCSP service at: " + url);
            }
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setConnectTimeout(CONNECT_TIMEOUT);
            con.setReadTimeout(CONNECT_TIMEOUT);
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-type", "application/ocsp-request");
            con.setRequestProperty("Content-length", String.valueOf(bytes.length));
            out = con.getOutputStream();
            out.write(bytes);
            out.flush();
            if (debug != null && con.getResponseCode() != 200) {
                debug.println("Received HTTP error: " + con.getResponseCode() + " - " + con.getResponseMessage());
            }
            in = con.getInputStream();
            int contentLength = con.getContentLength();
            response = IOUtils.readFully(in, contentLength, false);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
        return response;
    }

    public static URI getResponderURI(X509Certificate cert) {
        try {
            return OCSP.getResponderURI(X509CertImpl.toImpl(cert));
        }
        catch (CertificateException ce) {
            return null;
        }
    }

    static URI getResponderURI(X509CertImpl certImpl) {
        AuthorityInfoAccessExtension aia = certImpl.getAuthorityInfoAccessExtension();
        if (aia == null) {
            return null;
        }
        List<AccessDescription> descriptions = aia.getAccessDescriptions();
        for (AccessDescription description : descriptions) {
            GeneralName generalName;
            if (!description.getAccessMethod().equals(AccessDescription.Ad_OCSP_Id) || (generalName = description.getAccessLocation()).getType() != 6) continue;
            URIName uri = (URIName)generalName.getName();
            return uri.getURI();
        }
        return null;
    }

    static class NetworkFailureException
    extends CertPathValidatorException {
        private static final long serialVersionUID = 0L;

        NetworkFailureException(Throwable t) {
            super(t);
        }
    }

    public static interface RevocationStatus {
        public CertStatus getCertStatus();

        public Date getRevocationTime();

        public CRLReason getRevocationReason();

        public Map<String, Extension> getSingleExtensions();

        public static enum CertStatus {
            GOOD,
            REVOKED,
            UNKNOWN;

        }
    }
}

