/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.PublicKey;
import java.util.Arrays;
import javax.security.auth.x500.X500Principal;
import sun.security.util.DerValue;
import sun.security.x509.KeyIdentifier;

public final class ResponderId {
    private Type type;
    private X500Principal responderName;
    private KeyIdentifier responderKeyId;
    private byte[] encodedRid;

    public ResponderId(X500Principal subjectName) throws IOException {
        this.responderName = subjectName;
        this.responderKeyId = null;
        this.encodedRid = this.principalToBytes();
        this.type = Type.BY_NAME;
    }

    public ResponderId(PublicKey pubKey) throws IOException {
        this.responderKeyId = new KeyIdentifier(pubKey);
        this.responderName = null;
        this.encodedRid = this.keyIdToBytes();
        this.type = Type.BY_KEY;
    }

    public ResponderId(byte[] encodedData) throws IOException {
        DerValue outer = new DerValue(encodedData);
        if (outer.isContextSpecific((byte)Type.BY_NAME.value()) && outer.isConstructed()) {
            this.responderName = new X500Principal(outer.getDataBytes());
            this.encodedRid = this.principalToBytes();
            this.type = Type.BY_NAME;
        } else if (outer.isContextSpecific((byte)Type.BY_KEY.value()) && outer.isConstructed()) {
            this.responderKeyId = new KeyIdentifier(new DerValue(outer.getDataBytes()));
            this.encodedRid = this.keyIdToBytes();
            this.type = Type.BY_KEY;
        } else {
            throw new IOException("Invalid ResponderId content");
        }
    }

    public byte[] getEncoded() {
        return (byte[])this.encodedRid.clone();
    }

    public Type getType() {
        return this.type;
    }

    public int length() {
        return this.encodedRid.length;
    }

    public X500Principal getResponderName() {
        return this.responderName;
    }

    public KeyIdentifier getKeyIdentifier() {
        return this.responderKeyId;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof ResponderId) {
            ResponderId respObj = (ResponderId)obj;
            return Arrays.equals(this.encodedRid, respObj.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.encodedRid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this.type) {
            case BY_NAME: {
                sb.append((Object)this.type).append(": ").append(this.responderName);
                break;
            }
            case BY_KEY: {
                sb.append((Object)this.type).append(": ");
                for (byte keyIdByte : this.responderKeyId.getIdentifier()) {
                    sb.append(String.format("%02X", keyIdByte));
                }
                break;
            }
            default: {
                sb.append("Unknown ResponderId Type: ").append((Object)this.type);
            }
        }
        return sb.toString();
    }

    private byte[] principalToBytes() throws IOException {
        DerValue dv = new DerValue(DerValue.createTag((byte)-128, true, (byte)Type.BY_NAME.value()), this.responderName.getEncoded());
        return dv.toByteArray();
    }

    private byte[] keyIdToBytes() throws IOException {
        DerValue inner = new DerValue(4, this.responderKeyId.getIdentifier());
        DerValue outer = new DerValue(DerValue.createTag((byte)-128, true, (byte)Type.BY_KEY.value()), inner.toByteArray());
        return outer.toByteArray();
    }

    public static enum Type {
        BY_NAME(1, "byName"),
        BY_KEY(2, "byKey");

        private final int tagNumber;
        private final String ridTypeName;

        private Type(int value, String name) {
            this.tagNumber = value;
            this.ridTypeName = name;
        }

        public int value() {
            return this.tagNumber;
        }

        public String toString() {
            return this.ridTypeName;
        }
    }
}

