/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import sun.security.util.BiFunction;
import sun.security.util.Function;

public class Preconditions {
    private static RuntimeException outOfBounds(BiFunction<String, List<Integer>, ? extends RuntimeException> oobef, String checkKind, Integer ... args) {
        List<Integer> largs = Collections.unmodifiableList(Arrays.asList(args));
        RuntimeException e = oobef == null ? null : oobef.apply(checkKind, largs);
        return e == null ? new IndexOutOfBoundsException(Preconditions.outOfBoundsMessage(checkKind, largs)) : e;
    }

    private static RuntimeException outOfBoundsCheckIndex(BiFunction<String, List<Integer>, ? extends RuntimeException> oobe, int index, int length) {
        return Preconditions.outOfBounds(oobe, "checkIndex", index, length);
    }

    private static RuntimeException outOfBoundsCheckFromToIndex(BiFunction<String, List<Integer>, ? extends RuntimeException> oobe, int fromIndex, int toIndex, int length) {
        return Preconditions.outOfBounds(oobe, "checkFromToIndex", fromIndex, toIndex, length);
    }

    private static RuntimeException outOfBoundsCheckFromIndexSize(BiFunction<String, List<Integer>, ? extends RuntimeException> oobe, int fromIndex, int size, int length) {
        return Preconditions.outOfBounds(oobe, "checkFromIndexSize", fromIndex, size, length);
    }

    public static <X extends RuntimeException> BiFunction<String, List<Integer>, X> outOfBoundsExceptionFormatter(final Function<String, X> f) {
        return new BiFunction<String, List<Integer>, X>(){

            @Override
            public X apply(String checkKind, List<Integer> args) {
                return (RuntimeException)f.apply(Preconditions.outOfBoundsMessage(checkKind, args));
            }
        };
    }

    private static String outOfBoundsMessage(String checkKind, List<Integer> args) {
        if (checkKind == null && args == null) {
            return String.format("Range check failed", new Object[0]);
        }
        if (checkKind == null) {
            return String.format("Range check failed: %s", args);
        }
        if (args == null) {
            return String.format("Range check failed: %s", checkKind);
        }
        int argSize = 0;
        switch (checkKind) {
            case "checkIndex": {
                argSize = 2;
                break;
            }
            case "checkFromToIndex": 
            case "checkFromIndexSize": {
                argSize = 3;
                break;
            }
        }
        switch (args.size() != argSize ? "" : checkKind) {
            case "checkIndex": {
                return String.format("Index %d out-of-bounds for length %d", args.get(0), args.get(1));
            }
            case "checkFromToIndex": {
                return String.format("Range [%d, %d) out-of-bounds for length %d", args.get(0), args.get(1), args.get(2));
            }
            case "checkFromIndexSize": {
                return String.format("Range [%d, %<d + %d) out-of-bounds for length %d", args.get(0), args.get(1), args.get(2));
            }
        }
        return String.format("Range check failed: %s %s", checkKind, args);
    }

    public static <X extends RuntimeException> int checkIndex(int index, int length, BiFunction<String, List<Integer>, X> oobef) {
        if (index < 0 || index >= length) {
            throw Preconditions.outOfBoundsCheckIndex(oobef, index, length);
        }
        return index;
    }

    public static <X extends RuntimeException> int checkFromToIndex(int fromIndex, int toIndex, int length, BiFunction<String, List<Integer>, X> oobef) {
        if (fromIndex < 0 || fromIndex > toIndex || toIndex > length) {
            throw Preconditions.outOfBoundsCheckFromToIndex(oobef, fromIndex, toIndex, length);
        }
        return fromIndex;
    }

    public static <X extends RuntimeException> int checkFromIndexSize(int fromIndex, int size, int length, BiFunction<String, List<Integer>, X> oobef) {
        if ((length | fromIndex | size) < 0 || size > length - fromIndex) {
            throw Preconditions.outOfBoundsCheckFromIndexSize(oobef, fromIndex, size, length);
        }
        return fromIndex;
    }
}

