/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript;

import sun.org.mozilla.javascript.Context;
import sun.org.mozilla.javascript.ES6Iterator;
import sun.org.mozilla.javascript.ScriptRuntime;
import sun.org.mozilla.javascript.Scriptable;
import sun.org.mozilla.javascript.ScriptableObject;

public final class NativeStringIterator
extends ES6Iterator {
    private static final long serialVersionUID = 1L;
    private static final String ITERATOR_TAG = "StringIterator";
    private String string;
    private int index;

    static void init(ScriptableObject scope, boolean sealed) {
        ES6Iterator.init(scope, sealed, new NativeStringIterator(), ITERATOR_TAG);
    }

    private NativeStringIterator() {
    }

    NativeStringIterator(Scriptable scope, Scriptable stringLike) {
        super(scope);
        this.index = 0;
        this.string = ScriptRuntime.toString(stringLike);
    }

    @Override
    public String getClassName() {
        return "String Iterator";
    }

    @Override
    protected boolean isDone(Context cx, Scriptable scope) {
        return this.index >= this.string.length();
    }

    @Override
    protected Object nextValue(Context cx, Scriptable scope) {
        int newIndex = this.string.offsetByCodePoints(this.index, 1);
        String value = this.string.substring(this.index, newIndex);
        this.index = newIndex;
        return value;
    }

    @Override
    protected String getTag() {
        return ITERATOR_TAG;
    }
}

