/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.HeapFloatBufferR;

class HeapFloatBuffer
extends FloatBuffer {
    HeapFloatBuffer(int n, int n2) {
        super(-1, 0, n2, n, new float[n], 0);
    }

    HeapFloatBuffer(float[] fArray, int n, int n2) {
        super(-1, n, n + n2, fArray.length, fArray, 0);
    }

    protected HeapFloatBuffer(float[] fArray, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4, fArray, n5);
    }

    @Override
    public FloatBuffer slice() {
        int n;
        int n2 = this.position();
        int n3 = n2 <= (n = this.limit()) ? n - n2 : 0;
        return new HeapFloatBuffer(this.hb, -1, 0, n3, n3, n2 + this.offset);
    }

    @Override
    public FloatBuffer duplicate() {
        return new HeapFloatBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public FloatBuffer asReadOnlyBuffer() {
        return new HeapFloatBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int n) {
        return n + this.offset;
    }

    @Override
    public float get() {
        return this.hb[this.ix(this.nextGetIndex())];
    }

    @Override
    public float get(int n) {
        return this.hb[this.ix(this.checkIndex(n))];
    }

    @Override
    public FloatBuffer get(float[] fArray, int n, int n2) {
        HeapFloatBuffer.checkBounds(n, n2, fArray.length);
        int n3 = this.position();
        if (n2 > this.limit() - n3) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.hb, this.ix(n3), fArray, n, n2);
        this.position(n3 + n2);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public FloatBuffer put(float f) {
        this.hb[this.ix((int)this.nextPutIndex())] = f;
        return this;
    }

    @Override
    public FloatBuffer put(int n, float f) {
        this.hb[this.ix((int)this.checkIndex((int)n))] = f;
        return this;
    }

    @Override
    public FloatBuffer put(float[] fArray, int n, int n2) {
        HeapFloatBuffer.checkBounds(n, n2, fArray.length);
        int n3 = this.position();
        if (n2 > this.limit() - n3) {
            throw new BufferOverflowException();
        }
        System.arraycopy(fArray, n, this.hb, this.ix(n3), n2);
        this.position(n3 + n2);
        return this;
    }

    @Override
    public FloatBuffer put(FloatBuffer floatBuffer) {
        if (floatBuffer instanceof HeapFloatBuffer) {
            if (floatBuffer == this) {
                throw new IllegalArgumentException();
            }
            HeapFloatBuffer heapFloatBuffer = (HeapFloatBuffer)floatBuffer;
            int n = this.position();
            int n2 = heapFloatBuffer.position();
            int n3 = heapFloatBuffer.limit() - n2;
            if (n3 > this.limit() - n) {
                throw new BufferOverflowException();
            }
            System.arraycopy(heapFloatBuffer.hb, heapFloatBuffer.ix(n2), this.hb, this.ix(n), n3);
            heapFloatBuffer.position(n2 + n3);
            this.position(n + n3);
        } else if (floatBuffer.isDirect()) {
            int n = floatBuffer.remaining();
            int n4 = this.position();
            if (n > this.limit() - n4) {
                throw new BufferOverflowException();
            }
            floatBuffer.get(this.hb, this.ix(n4), n);
            this.position(n4 + n);
        } else {
            super.put(floatBuffer);
        }
        return this;
    }

    @Override
    public FloatBuffer compact() {
        int n = this.position();
        int n2 = this.limit() - n;
        System.arraycopy(this.hb, this.ix(n), this.hb, this.ix(0), n2);
        this.position(n2);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

