/*
 * Decompiled with CFR 0.152.
 */
package java.security.spec;

import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.util.Objects;

public class PSSParameterSpec
implements AlgorithmParameterSpec {
    private final String mdName;
    private final String mgfName;
    private final AlgorithmParameterSpec mgfSpec;
    private final int saltLen;
    private final int trailerField;
    public static final int TRAILER_FIELD_BC = 1;
    public static final PSSParameterSpec DEFAULT = new PSSParameterSpec("SHA-1", "MGF1", MGF1ParameterSpec.SHA1, 20, 1);

    private PSSParameterSpec() {
        throw new RuntimeException("default constructor not allowed");
    }

    public PSSParameterSpec(String string, String string2, AlgorithmParameterSpec algorithmParameterSpec, int n, int n2) {
        Objects.requireNonNull(string, "digest algorithm is null");
        Objects.requireNonNull(string2, "mask generation function algorithm is null");
        if (n < 0) {
            throw new IllegalArgumentException("negative saltLen value: " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("negative trailerField: " + n2);
        }
        this.mdName = string;
        this.mgfName = string2;
        this.mgfSpec = algorithmParameterSpec;
        this.saltLen = n;
        this.trailerField = n2;
    }

    public PSSParameterSpec(int n) {
        this("SHA-1", "MGF1", MGF1ParameterSpec.SHA1, n, 1);
    }

    public String getDigestAlgorithm() {
        return this.mdName;
    }

    public String getMGFAlgorithm() {
        return this.mgfName;
    }

    public AlgorithmParameterSpec getMGFParameters() {
        return this.mgfSpec;
    }

    public int getSaltLength() {
        return this.saltLen;
    }

    public int getTrailerField() {
        return this.trailerField;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MD: " + this.mdName + "\n").append("MGF: " + this.mgfSpec + "\n").append("SaltLength: " + this.saltLen + "\n").append("TrailerField: " + this.trailerField + "\n");
        return stringBuilder.toString();
    }
}

