/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc;

import java.awt.Color;
import org.openoffice.xmerge.converter.xml.Style;
import org.openoffice.xmerge.converter.xml.StyleCatalog;
import org.openoffice.xmerge.converter.xml.sxc.Format;
import org.openoffice.xmerge.util.Debug;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CellStyle
extends Style
implements Cloneable {
    private Format fmt = new Format();
    private static String[] ignored = new String[]{"style:text-autospace", "style:text-underline-color", "fo:margin-left", "fo:margin-right", "fo:text-indent", "fo:margin-top", "fo:margin-bottom", "text:line-number", "text:number-lines", "style:country-asian", "style:font-size-asian", "style:font-name-complex", "style:language-complex", "style:country-complex", "style:font-size-complex", "style:punctuation-wrap", "fo:language", "fo:country", "style:font-name-asian", "style:language-asian", "style:line-break", "fo:keep-with-next"};

    public CellStyle(Node node, StyleCatalog sc) {
        super(node, sc);
        NamedNodeMap attrNodes = node.getAttributes();
        if (attrNodes != null) {
            int len = attrNodes.getLength();
            for (int i = 0; i < len; ++i) {
                Node attr = attrNodes.item(i);
                this.handleAttribute(attr.getNodeName(), attr.getNodeValue());
            }
        }
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            int len = children.getLength();
            for (int i = 0; i < len; ++i) {
                NamedNodeMap childAttrNodes;
                Node child = children.item(i);
                String nodeName = child.getNodeName();
                if (!nodeName.equals("style:properties") || (childAttrNodes = child.getAttributes()) == null) continue;
                int nChildAttrNodes = childAttrNodes.getLength();
                for (int j = 0; j < nChildAttrNodes; ++j) {
                    Node attr = childAttrNodes.item(j);
                    this.handleAttribute(attr.getNodeName(), attr.getNodeValue());
                }
            }
        }
    }

    public CellStyle(String name, String family, String parent, Format fmt, StyleCatalog sc) {
        super(name, family, parent, sc);
        this.fmt = fmt;
    }

    public Format getFormat() {
        return this.fmt;
    }

    private Color parseColorString(String value) {
        int red = 0;
        int green = 0;
        int blue = 0;
        try {
            red = Integer.parseInt(value.substring(1, 3), 16);
            green = Integer.parseInt(value.substring(3, 5), 16);
            blue = Integer.parseInt(value.substring(5, 7), 16);
        }
        catch (NumberFormatException e) {
            Debug.log(2, "Problem parsing a color string", e);
        }
        catch (IndexOutOfBoundsException e) {
            Debug.log(2, "Problem parsing a color string", e);
        }
        return new Color(red, green, blue, 0);
    }

    private void handleAttribute(String attr, String value) {
        if (attr.equals("fo:font-weight")) {
            this.fmt.setAttribute(1, value.equals("bold"));
        } else if (attr.equals("fo:font-style")) {
            if (value.equals("italic") || value.equals("oblique")) {
                this.fmt.setAttribute(2, true);
            } else if (value.equals("normal")) {
                this.fmt.setAttribute(2, false);
            }
        } else if (attr.equals("style:text-underline")) {
            this.fmt.setAttribute(4, !value.equals("none"));
        } else if (attr.equals("style:text-crossing-out")) {
            this.fmt.setAttribute(8, !value.equals("none"));
        } else if (attr.equals("style:text-position")) {
            if (value.startsWith("super ")) {
                this.fmt.setAttribute(16, true);
            } else if (value.startsWith("sub ")) {
                this.fmt.setAttribute(32, true);
            } else if (value.startsWith("0% ")) {
                this.fmt.setAttribute(48, false);
            } else {
                String firstPart = value.substring(0, value.indexOf(32));
                if (firstPart.endsWith("%")) {
                    int amount;
                    firstPart = firstPart.substring(0, value.indexOf(37));
                    try {
                        amount = Integer.parseInt(firstPart);
                    }
                    catch (NumberFormatException e) {
                        amount = 0;
                        Debug.log(2, "Problem with style:text-position tag", e);
                    }
                    if (amount < 0) {
                        this.fmt.setAttribute(32, true);
                    } else if (amount > 0) {
                        this.fmt.setAttribute(16, false);
                    }
                }
            }
        } else if (attr.equals("fo:font-size")) {
            if (value.endsWith("pt")) {
                String num = value.substring(0, value.length() - 2);
                this.fmt.setFontSize(Integer.parseInt(num));
            }
        } else if (attr.equals("style:font-name")) {
            this.fmt.setFontName(value);
        } else if (attr.equals("fo:color")) {
            this.fmt.setForeground(this.parseColorString(value));
        } else if (attr.equals("fo:background-color")) {
            this.fmt.setBackground(this.parseColorString(value));
        } else if (attr.equals("fo:text-align")) {
            if (value.equals("center")) {
                this.fmt.setAlign(2);
            } else if (value.equals("end")) {
                this.fmt.setAlign(1);
            } else if (value.equals("start")) {
                this.fmt.setAlign(3);
            }
        } else if (attr.equals("fo:vertical-align")) {
            if (value.equals("top")) {
                this.fmt.setVertAlign(1);
            } else if (value.equals("middle")) {
                this.fmt.setVertAlign(2);
            } else if (value.equals("bottom")) {
                this.fmt.setVertAlign(3);
            }
        } else if (attr.equals("fo:border")) {
            this.fmt.setAttribute(256, !value.equals("none"));
            this.fmt.setAttribute(512, !value.equals("none"));
            this.fmt.setAttribute(64, !value.equals("none"));
            this.fmt.setAttribute(128, !value.equals("none"));
        } else if (attr.equals("fo:border-top")) {
            this.fmt.setAttribute(256, !value.equals("none"));
        } else if (attr.equals("fo:border-bottom")) {
            this.fmt.setAttribute(512, !value.equals("none"));
        } else if (attr.equals("fo:border-left")) {
            this.fmt.setAttribute(64, !value.equals("none"));
        } else if (attr.equals("fo:border-right")) {
            this.fmt.setAttribute(128, !value.equals("none"));
        } else if (attr.equals("fo:wrap-option")) {
            this.fmt.setAttribute(1024, value.equals("wrap"));
        } else if (!this.isIgnored(attr)) {
            Debug.log(1, "CellStyle Unhandled: " + attr + "=" + value);
        }
    }

    @Override
    public Style getResolved() {
        CellStyle resolved = null;
        try {
            resolved = (CellStyle)this.clone();
        }
        catch (Exception e) {
            Debug.log(2, "Can't clone", e);
        }
        CellStyle parentStyle = null;
        if (this.sc != null) {
            if (this.parent != null) {
                parentStyle = (CellStyle)this.sc.lookup(this.parent, this.family, null, this.getClass());
                if (parentStyle == null) {
                    Debug.log(2, "parent style lookup of " + this.parent + " failed!");
                } else {
                    parentStyle = (CellStyle)parentStyle.getResolved();
                }
            } else if (!this.name.equals("DEFAULT_STYLE")) {
                parentStyle = (CellStyle)this.sc.lookup("DEFAULT_STYLE", null, null, this.getClass());
            }
        }
        if (parentStyle != null) {
            parentStyle = (CellStyle)parentStyle.getResolved();
            Format parentFormat = parentStyle.getFormat();
            Format resolvedFormat = resolved.getFormat();
            if (this.fmt.getAlign() == 3 && parentFormat.getAlign() != 3) {
                resolvedFormat.setAlign(parentFormat.getAlign());
            }
            if (this.fmt.getVertAlign() == 3 && parentFormat.getVertAlign() != 3) {
                resolvedFormat.setVertAlign(parentFormat.getVertAlign());
            }
            if (this.fmt.getFontSize() == 0 && parentFormat.getFontSize() != 0) {
                resolvedFormat.setFontSize(parentFormat.getFontSize());
            }
            if (this.fmt.getFontName() == null && parentFormat.getFontName() != null) {
                resolvedFormat.setFontName(parentFormat.getFontName());
            }
            if (this.fmt.getForeground() == null && parentFormat.getForeground() != null) {
                resolvedFormat.setForeground(parentFormat.getForeground());
            }
            if (this.fmt.getBackground() == null && parentFormat.getBackground() != null) {
                resolvedFormat.setBackground(parentFormat.getBackground());
            }
            for (int m = 1; m <= 32; m <<= 1) {
                if (!this.fmt.getAttribute(m) || !parentFormat.getAttribute(m)) continue;
                resolvedFormat.setAttribute(m, parentFormat.getAttribute(m));
            }
        }
        return resolved;
    }

    @Override
    public Node createNode(Document parentDoc, String name) {
        Element node = parentDoc.createElement(name);
        this.writeAttributes(node);
        return node;
    }

    @Override
    public boolean isSubset(Style style) {
        if (style.getClass() != this.getClass()) {
            return false;
        }
        CellStyle tStyle = (CellStyle)style;
        Format rhs = tStyle.getFormat();
        return this.fmt.isSubset(rhs);
    }

    private void writeAttributes(Element node) {
        if (this.fmt.getAlign() == 1) {
            node.setAttribute("fo:text-align", "end");
        }
        if (this.fmt.getAlign() == 3) {
            node.setAttribute("fo:text-align", "start");
        }
        if (this.fmt.getAlign() == 2) {
            node.setAttribute("fo:text-align", "center");
        }
        if (this.fmt.getVertAlign() == 1) {
            node.setAttribute("fo:vertical-align", "top");
        }
        if (this.fmt.getVertAlign() == 2) {
            node.setAttribute("fo:vertical-align", "middle");
        }
        if (this.fmt.getVertAlign() == 3) {
            node.setAttribute("fo:vertical-align", "bottom");
        }
        if (this.fmt.getAttribute(1)) {
            node.setAttribute("fo:font-weight", "bold");
        }
        if (this.fmt.getAttribute(2)) {
            node.setAttribute("fo:font-style", "italic");
        }
        if (this.fmt.getAttribute(4)) {
            node.setAttribute("style:text-underline", "single");
        }
        if (this.fmt.getAttribute(8)) {
            node.setAttribute("style:text-crossing-out", "single-line");
        }
        if (this.fmt.getAttribute(16)) {
            node.setAttribute("style:text-position", "super 58%");
        }
        if (this.fmt.getAttribute(32)) {
            node.setAttribute("style:text-position", "sub 58%");
        }
        if (this.fmt.getFontSize() != 0) {
            node.setAttribute("fo:font-size", Integer.toString(this.fmt.getFontSize()) + "pt");
        }
        if (this.fmt.getFontName() != null) {
            node.setAttribute("style:font-name", this.fmt.getFontName());
        }
        if (this.fmt.getForeground() != null) {
            node.setAttribute("fo:color", this.buildColorString(this.fmt.getForeground()));
        }
        if (this.fmt.getBackground() != null) {
            node.setAttribute("fo:background-color", this.buildColorString(this.fmt.getBackground()));
        }
        if (this.fmt.getAttribute(256)) {
            node.setAttribute("fo:border-top", "0.0008inch solid #000000");
        }
        if (this.fmt.getAttribute(512)) {
            node.setAttribute("fo:border-bottom", "0.0008inch solid #000000");
        }
        if (this.fmt.getAttribute(128)) {
            node.setAttribute("fo:border-right", "0.0008inch solid #000000");
        }
        if (this.fmt.getAttribute(64)) {
            node.setAttribute("fo:border-left", "0.0008inch solid #000000");
        }
        if (this.fmt.getAttribute(1024)) {
            node.setAttribute("fo:wrap-option", "wrap");
        }
    }

    private String buildColorString(Color c) {
        return String.format("#%06X", c.getRGB() & 0xFFFFFF);
    }

    private boolean isIgnored(String attribute) {
        for (int i = 0; i < ignored.length; ++i) {
            if (!ignored[i].equals(attribute)) continue;
            return true;
        }
        return false;
    }
}

