/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wiki;

import com.sun.star.awt.XContainerWindowEventHandler;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlContainer;
import com.sun.star.awt.XDialog;
import com.sun.star.awt.XDialogEventHandler;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.wiki.Helper;
import com.sun.star.wiki.Settings;
import com.sun.star.wiki.WikiEditSettingDialog;
import java.util.Map;

public final class WikiOptionsEventHandlerImpl
extends WeakBase
implements XServiceInfo,
XContainerWindowEventHandler,
XDialogEventHandler {
    static final String[] m_pServiceNames = new String[]{"com.sun.star.wiki.WikiOptionsEventHandler"};
    static final String m_sImplementationName = WikiOptionsEventHandlerImpl.class.getName();
    private static final String sExternalEvent = "external_event";
    private static final String sAdd = "Add";
    private static final String sEdit = "Edit";
    private static final String sRemove = "Remove";
    private static final String sListStatus = "ListStatus";
    private static final String sListEdit = "ListEdit";
    private static final String sInitialize = "initialize";
    private static final String sOk = "ok";
    private static final String sBack = "back";
    private final XComponentContext m_xContext;
    private XDialog m_xDialog;
    private XControlContainer m_xControlContainer;
    private Settings m_aSettings;

    public WikiOptionsEventHandlerImpl(XComponentContext xContext) {
        this.m_xContext = xContext;
    }

    private XPropertySet GetPropSet(String sControl) {
        if (this.m_xControlContainer != null) {
            XControl xControl = this.m_xControlContainer.getControl(sControl);
            XPropertySet xListProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xControl.getModel());
            return xListProps;
        }
        return null;
    }

    private void RefreshView() {
        if (this.m_aSettings != null) {
            String[] pWikiList = this.m_aSettings.getWikiURLs();
            XPropertySet xListProps = this.GetPropSet("WikiList");
            if (xListProps != null) {
                try {
                    xListProps.setPropertyValue("StringItemList", (Object)pWikiList);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void CheckButtonState() {
        XPropertySet xListProps = this.GetPropSet("WikiList");
        if (xListProps != null) {
            try {
                short[] pSel = (short[])xListProps.getPropertyValue("SelectedItems");
                XPropertySet xEditProps = this.GetPropSet("EditButton");
                XPropertySet xRemoveProps = this.GetPropSet("RemoveButton");
                Boolean bState = pSel.length != 0;
                xEditProps.setPropertyValue("Enabled", (Object)bState);
                xRemoveProps.setPropertyValue("Enabled", (Object)bState);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void AddSetting() {
        WikiEditSettingDialog aSettingDialog = new WikiEditSettingDialog(this.m_xContext, "vnd.sun.star.script:WikiEditor.EditSetting?location=application");
        if (aSettingDialog.show()) {
            this.RefreshView();
        }
        aSettingDialog.DisposeDialog();
    }

    private void EditSetting() {
        XPropertySet xListProps = this.GetPropSet("WikiList");
        if (xListProps != null) {
            Map<String, String> ht = null;
            try {
                short[] pSel = (short[])xListProps.getPropertyValue("SelectedItems");
                String[] pItems = (String[])xListProps.getPropertyValue("StringItemList");
                if (pSel.length > 0 && pItems.length > pSel[0]) {
                    String selName = pItems[pSel[0]];
                    ht = this.m_aSettings.getSettingByUrl(selName);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            WikiEditSettingDialog aSettingDialog = new WikiEditSettingDialog(this.m_xContext, "vnd.sun.star.script:WikiEditor.EditSetting?location=application", ht, true);
            if (aSettingDialog.show()) {
                this.RefreshView();
            }
            aSettingDialog.DisposeDialog();
        }
    }

    private void RemoveSetting() {
        XPropertySet xListProps = this.GetPropSet("WikiList");
        if (xListProps != null) {
            try {
                short[] pSel = (short[])xListProps.getPropertyValue("SelectedItems");
                String[] pItems = (String[])this.GetPropSet("WikiList").getPropertyValue("StringItemList");
                if (pSel.length > 0 && pItems.length > pSel[0]) {
                    this.m_aSettings.removeSettingByUrl(pItems[pSel[0]]);
                    this.RefreshView();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void InitStrings() {
        try {
            this.GetPropSet("FixedLine1").setPropertyValue("Label", (Object)Helper.GetLocalizedString(this.m_xContext, 31));
            this.GetPropSet("AddButton").setPropertyValue("Label", (Object)Helper.GetLocalizedString(this.m_xContext, 12));
            this.GetPropSet("EditButton").setPropertyValue("Label", (Object)Helper.GetLocalizedString(this.m_xContext, 13));
            this.GetPropSet("RemoveButton").setPropertyValue("Label", (Object)Helper.GetLocalizedString(this.m_xContext, 15));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getImplementationName() {
        return m_sImplementationName;
    }

    public boolean supportsService(String sService) {
        int len = m_pServiceNames.length;
        for (int i = 0; i < len; ++i) {
            if (!sService.equals(m_pServiceNames[i])) continue;
            return true;
        }
        return false;
    }

    public String[] getSupportedServiceNames() {
        return m_pServiceNames;
    }

    public boolean callHandlerMethod(XWindow xWindow, Object aEventObject, String sMethod) throws WrappedTargetException, RuntimeException {
        if (sMethod.equals(sExternalEvent)) {
            String sEvent = AnyConverter.toString((Object)aEventObject);
            if (sEvent != null) {
                if (sEvent.equals(sOk)) {
                    if (this.m_aSettings != null) {
                        this.m_aSettings.storeConfiguration();
                    }
                } else if (sEvent.equals(sInitialize) || sEvent.equals(sBack)) {
                    if (sEvent.equals(sInitialize)) {
                        this.m_xDialog = (XDialog)UnoRuntime.queryInterface(XDialog.class, (Object)xWindow);
                        this.m_xControlContainer = (XControlContainer)UnoRuntime.queryInterface(XControlContainer.class, (Object)this.m_xDialog);
                        this.m_aSettings = Settings.getSettings(this.m_xContext);
                        this.m_aSettings.loadConfiguration();
                        this.InitStrings();
                    } else if (this.m_aSettings != null) {
                        this.m_aSettings.loadConfiguration();
                    }
                    this.RefreshView();
                    this.CheckButtonState();
                }
            }
        } else if (sMethod.equals(sAdd)) {
            this.AddSetting();
        } else if (sMethod.equals(sEdit) || sMethod.equals(sListEdit)) {
            this.EditSetting();
        } else if (sMethod.equals(sRemove)) {
            this.RemoveSetting();
            this.CheckButtonState();
        } else if (sMethod.equals(sListStatus)) {
            this.CheckButtonState();
        }
        return true;
    }

    public boolean callHandlerMethod(XDialog xDialog, Object aEventObject, String sMethod) throws WrappedTargetException, RuntimeException {
        return true;
    }

    public String[] getSupportedMethodNames() {
        return new String[]{sExternalEvent, sAdd, sEdit, sRemove};
    }
}

